/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.ui.l10n.Messages;

public final class EngineMappingDescriptor {
    public static final String ENGINE_MAPPING_ID = "id";
    public static final String QUERY_TAB_ID = "queryTabID";
    public static final String PARTICIPANTS_TAB_ID = "participantsTabID";
    public static final String SEARCH_ENGINE_ID = "engineID";
    public String ID;
    public String label;
    public String queryTabID;
    public String paticipantsTabID;
    public String searchEngineID;
    private IConfigurationElement configElement;

    public EngineMappingDescriptor(IConfigurationElement element) throws CoreException {
        this.configElement = element;
        this.load();
    }

    private void load() throws CoreException {
        this.ID = this.configElement.getAttribute(ENGINE_MAPPING_ID);
        this.queryTabID = this.configElement.getAttribute(QUERY_TAB_ID);
        this.paticipantsTabID = this.configElement.getAttribute(PARTICIPANTS_TAB_ID);
        this.searchEngineID = this.configElement.getAttribute(SEARCH_ENGINE_ID);
        if (this.ID == null || this.queryTabID == null || this.paticipantsTabID == null || this.searchEngineID == null) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getContributor().getName(), 0, String.valueOf(Messages.getString("ParticipantTabDescriptor.invalidExtensionErrorMessage")) + this.ID, null));
        }
    }

    public String getID() {
        return this.ID;
    }

    public String getQueryTabID() {
        return this.queryTabID;
    }

    public String getPaticipantsTabID() {
        return this.paticipantsTabID;
    }

    public String getSearchEngineID() {
        return this.searchEngineID;
    }
}

