/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.search.common.ui.evaluators.references;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.eval.IModelSearchQueryEvaluator;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.search.common.ui.l10n.Messages;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUML2ReferencesToUML2ClassModelSearchQueryEvaluator<Q extends IModelSearchQuery, T extends Resource>
implements IModelSearchQueryEvaluator<Q, T> {
    private NamedElement namedElement;

    public AbstractUML2ReferencesToUML2ClassModelSearchQueryEvaluator(NamedElement clazz) {
        this.namedElement = clazz;
    }

    public String getLabel() {
        return Messages.getString("UML2ReferencesToUML2ClassModelSearchQueryEvaluator.Label");
    }

    protected Property getMemberEnd(Association association, boolean sourceNotTarget) {
        return (Property)association.getMemberEnds().get(sourceNotTarget ? 0 : 1);
    }

    protected Property getSourceEnd(Association association) {
        return this.getMemberEnd(association, true);
    }

    protected Property getTargetEnd(Association association) {
        return this.getMemberEnd(association, false);
    }

    private List<Object> _computeAssociations(Q query, T resource, AggregationKind k, boolean notify) {
        ArrayList<Object> matches = new ArrayList<Object>();
        ArrayList refs = new ArrayList();
        if (this.namedElement instanceof Classifier) {
            refs.addAll(UML2Util.getNonNavigableInverseReferences((EObject)this.namedElement));
            for (EStructuralFeature.Setting nonNavigableInverseReference : refs) {
                EObject eObject;
                if (nonNavigableInverseReference.getEStructuralFeature() != UMLPackage.Literals.TYPED_ELEMENT__TYPE || !((eObject = nonNavigableInverseReference.getEObject()) instanceof Property)) continue;
                Association association = ((Property)eObject).getAssociation();
                AggregationKind kind = ((Property)eObject).getAggregation();
                if (kind != k) continue;
                matches.add(association);
                this.processMatch((EObject)association, query, resource, notify);
            }
        }
        return matches;
    }

    protected List<Object> computeAssociations(Q query, T resource, boolean notify) {
        return this._computeAssociations(query, resource, AggregationKind.NONE_LITERAL, notify);
    }

    protected List<Object> computeAggregations(Q query, T resource, boolean notify) {
        return this._computeAssociations(query, resource, AggregationKind.SHARED_LITERAL, notify);
    }

    protected List<Object> computeCompositions(Q query, T resource, boolean notify) {
        return this._computeAssociations(query, resource, AggregationKind.COMPOSITE_LITERAL, notify);
    }

    protected List<Object> computeGeneralizations(Q query, T resource, boolean notify) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.namedElement instanceof Classifier) {
            for (Generalization generalization : ((Classifier)this.namedElement).getGeneralizations()) {
                elements.add(generalization);
                elements.add(this.processMatch((EObject)generalization, query, resource, notify));
            }
        }
        return elements;
    }

    protected List<Object> computeRealizations(Q query, T resource, boolean notify) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.namedElement instanceof Classifier) {
            for (Dependency dependency : this.namedElement.getClientDependencies()) {
                if (!(dependency instanceof Realization) || dependency instanceof Substitution) continue;
                elements.add(this.processMatch((EObject)dependency, query, resource, notify));
            }
        }
        return elements;
    }

    protected List<Object> computeAbstractions(Q query, T resource, boolean notify) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.namedElement instanceof Classifier) {
            for (Dependency dependency : this.namedElement.getClientDependencies()) {
                if (dependency instanceof Abstraction || dependency instanceof Usage || dependency instanceof Realization || dependency instanceof Substitution) continue;
                elements.add(this.processMatch((EObject)dependency, query, resource, notify));
            }
        }
        return elements;
    }

    protected List<Object> computeDependencies(Q query, T resource, boolean notify) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.namedElement instanceof Classifier) {
            for (Dependency dependency : this.namedElement.getClientDependencies()) {
                elements.add(this.processMatch((EObject)dependency, query, resource, notify));
            }
        }
        return elements;
    }

    protected List<Object> computeSubstitutions(Q query, T resource, boolean notify) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.namedElement instanceof Classifier) {
            for (Dependency dependency : this.namedElement.getClientDependencies()) {
                if (!(dependency instanceof Substitution)) continue;
                elements.add(this.processMatch((EObject)dependency, query, resource, notify));
            }
        }
        return elements;
    }

    protected List<Object> computeUsages(Q query, T resource, boolean notify) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.namedElement instanceof Classifier) {
            for (Dependency dependency : this.namedElement.getClientDependencies()) {
                if (!(dependency instanceof Usage)) continue;
                elements.add(this.processMatch((EObject)dependency, query, resource, notify));
            }
        }
        return elements;
    }

    protected Object processMatch(EObject o, Q query, T resource, boolean notify) {
        URI eClassURI = o.eResource().getURI();
        if (resource.getURI().equals((Object)eClassURI)) {
            query.processSearchResultMatching(resource, (Object)o, notify);
        }
        return o;
    }

    public NamedElement getNamedElement() {
        return this.namedElement;
    }

    public void setNamedElement(NamedElement e) {
        this.namedElement = e;
    }
}

