/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardState;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardPersistence {
    private static final String DS_ELEMENT = "dashboardState";
    private static final String PROJECT_KEY = "project";

    public static Map<IProject, DashboardState> read(IMemento memento) {
        HashMap<IProject, DashboardState> states = new HashMap<IProject, DashboardState>();
        IMemento[] iMementoArray = memento.getChildren(DS_ELEMENT);
        int n = 0;
        int n2 = iMementoArray.length;
        while (n < n2) {
            IProject project;
            IMemento stateMemento = iMementoArray[n];
            String projectName = stateMemento.getString(PROJECT_KEY);
            if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
                states.put(project, new DashboardState(stateMemento));
            }
            ++n;
        }
        return states;
    }

    public static void write(IMemento memento, Map<IProject, DashboardState> states) {
        for (IProject project : states.keySet()) {
            DashboardState state = states.get(project);
            IMemento stateMemento = memento.createChild(DS_ELEMENT);
            stateMemento.putString(PROJECT_KEY, project.getName());
            state.write(stateMemento);
        }
    }
}

