/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

class ViewmapProducerWizardPage
extends WizardPage {
    private Button generateRCPButton;
    private Button useMapModeButton;
    private Button useRuntimeFiguresButton;

    protected ViewmapProducerWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createControls(composite);
        this.initControls();
        this.validatePage();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createControls(Composite result) {
        this.useMapModeButton = new Button(result, 32);
        this.useMapModeButton.setText(Messages.ViewmapProducerWizardPage_btn_mapmode);
        this.useMapModeButton.setLayoutData((Object)new GridData(36));
        this.useRuntimeFiguresButton = new Button(result, 32);
        this.useRuntimeFiguresButton.setText(Messages.ViewmapProducerWizardPage_btn_runtime);
        this.useRuntimeFiguresButton.setLayoutData((Object)new GridData(36));
        this.generateRCPButton = new Button(result, 32);
        this.generateRCPButton.setText(Messages.ViewmapProducerWizardPage_btn_rcp);
        this.generateRCPButton.setLayoutData((Object)new GridData(36));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewmapProducerWizardPage.this.handleSelection(e.widget);
            }

            public void widgetSelected(SelectionEvent e) {
                ViewmapProducerWizardPage.this.handleSelection(e.widget);
            }
        };
        this.useMapModeButton.addSelectionListener(selectionListener);
        this.useRuntimeFiguresButton.addSelectionListener(selectionListener);
        this.generateRCPButton.addSelectionListener(selectionListener);
    }

    void handleSelection(Widget w) {
        if (this.generateRCPButton.equals(w)) {
            this.getOperation().getOptions().setGenerateRCP(this.generateRCPButton.getSelection());
        } else if (this.useMapModeButton.equals(w)) {
            this.getOperation().getOptions().setUseMapMode(this.useMapModeButton.getSelection());
        } else if (this.useRuntimeFiguresButton.equals(w)) {
            this.getOperation().getOptions().setUseRuntimeFigures(this.useRuntimeFiguresButton.getSelection());
        }
        this.validatePage();
    }

    private void validatePage() {
        IStatus checkOptions = this.checkOptions();
        if (checkOptions.isOK()) {
            this.setMessage(null);
            this.setPageComplete(true);
        } else {
            this.setMessage(checkOptions.getMessage(), 1);
            this.setPageComplete(checkOptions.getSeverity() < 2);
        }
    }

    private IStatus checkOptions() {
        boolean hasLite = TransformOptions.checkLiteOptionPresent();
        if (hasLite && !this.useRuntimeFiguresButton.getSelection() && this.useMapModeButton.getSelection()) {
            return Plugin.createInfo(Messages.ViewmapProducerWizardPage_i_not_recommended);
        }
        return Status.OK_STATUS;
    }

    private void initControls() {
        TransformOptions options = this.getOperation().getOptions();
        this.generateRCPButton.setSelection(options.getGenerateRCP());
        boolean hasLite = TransformOptions.checkLiteOptionPresent();
        boolean useRuntimeFigures = options.getUseRuntimeFigures();
        if (hasLite) {
            this.useRuntimeFiguresButton.setEnabled(true);
            this.useRuntimeFiguresButton.setSelection(useRuntimeFigures);
        } else {
            this.useRuntimeFiguresButton.setEnabled(false);
            this.useRuntimeFiguresButton.setSelection(true);
            options.setUseRuntimeFigures(true);
        }
        this.useMapModeButton.setSelection(options.getUseMapMode());
    }

    private TransformToGenModelOperation getOperation() {
        TransformToGenModelWizard wizard = (TransformToGenModelWizard)this.getWizard();
        return wizard.getTransformOperation();
    }
}

