/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.codegen.popup.actions.Messages;
import org.eclipse.gmf.internal.common.ui.ElementSelectorExtension;
import org.eclipse.gmf.internal.common.ui.ExtensibleModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ListElementSelectorExtension;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPageExtension;
import org.eclipse.gmf.internal.common.ui.PredefinedModelExtension;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GMFGenExtensionModelWizard
extends Wizard
implements IWorkbenchWizard {
    private static final String GMFGEN_FILE_EXTENSION = "gmfgen";
    private static final String ECORE_FILE_EXTENSION = "ecore";
    private IWorkbench myWorkbench;
    private IStructuredSelection mySelection;
    private ElementSelectorExtension myRootElementSelectorExtension;
    private ResourceSet myResourceSet;
    private ResourceLocationProvider myResourceLocationProvider;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.myWorkbench = workbench;
        this.mySelection = selection;
        this.setWindowTitle(Messages.GMFGenExtensionModelWizard_windowTitle);
    }

    public IWorkbench getWorkbench() {
        return this.myWorkbench;
    }

    public IStructuredSelection getSelection() {
        return this.mySelection;
    }

    protected ResourceSet getResourceSet() {
        if (this.myResourceSet == null) {
            this.myResourceSet = new ResourceSetImpl();
        }
        return this.myResourceSet;
    }

    public ElementSelectorExtension getRootElementSelectorExtension() {
        return this.myRootElementSelectorExtension;
    }

    public ResourceLocationProvider getResourceLocationProvider() {
        return this.myResourceLocationProvider;
    }

    public void addPages() {
        this.myResourceLocationProvider = new ResourceLocationProvider((ISelection)this.getSelection());
        ExtensibleModelSelectionPage domainModelSelectionPage = new ExtensibleModelSelectionPage("domain", this.myResourceLocationProvider, this.getResourceSet(), ECORE_FILE_EXTENSION);
        domainModelSelectionPage.setTitle(Messages.GMFGenExtensionModelWizard_pageTitle);
        domainModelSelectionPage.setDescription(Messages.GMFGenExtensionModelWizard_pageDescription);
        List uris = this.myResourceLocationProvider.getSelectedURIs(ECORE_FILE_EXTENSION);
        domainModelSelectionPage.addExtension("prem", (ModelSelectionPageExtension)new PredefinedModelExtension((ModelSelectionPage)domainModelSelectionPage, uris));
        this.myRootElementSelectorExtension = new ListElementSelectorExtension(){

            protected String getModelElementName() {
                return Messages.GMFGenExtensionModelWizard_classChooserLabel;
            }

            protected String getModelElementLabel(EObject modelElement) {
                String name = ((EClass)modelElement).getName();
                if (name == null || name.trim().length() == 0) {
                    name = Messages.GMFGenExtensionModelWizard_unnamedClassName;
                }
                return name;
            }

            protected boolean isApplicable(EObject element) {
                EClass clazz = (EClass)element;
                return !clazz.isAbstract();
            }

            protected EClass getModelElementClass() {
                return EcorePackage.eINSTANCE.getEClass();
            }

            protected void sortModelElements(List<EObject> elements) {
            }
        };
        domainModelSelectionPage.addExtension("domainElement", (ModelSelectionPageExtension)this.myRootElementSelectorExtension);
        this.addPage((IWizardPage)domainModelSelectionPage);
        super.addPages();
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        ElementSelectorExtension extension = GMFGenExtensionModelWizard.this.getRootElementSelectorExtension();
                        EClass rootClass = (EClass)extension.getModelElement();
                        EObject instantiated = rootClass.getEPackage().getEFactoryInstance().create(rootClass);
                        List gmfgenURIs = GMFGenExtensionModelWizard.this.getResourceLocationProvider().getSelectedURIs(GMFGenExtensionModelWizard.GMFGEN_FILE_EXTENSION);
                        int i = 0;
                        while (i < gmfgenURIs.size()) {
                            URI nextGmfgenURI = (URI)gmfgenURIs.get(i);
                            GMFGenExtensionModelWizard.this.addExtensionMetamodelRootToGmfgen(nextGmfgenURI, instantiated);
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        Plugin.log((Exception)ex);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            List selectedGmfgenFiles = this.getResourceLocationProvider().getSelectedFiles(GMFGEN_FILE_EXTENSION, false);
            WizardUtil.selectReveal((IWorkbench)this.getWorkbench(), (ISelection)new StructuredSelection(selectedGmfgenFiles));
            if (!selectedGmfgenFiles.isEmpty()) {
                WizardUtil.openInEditor((IWorkbench)this.getWorkbench(), (IFile)((IFile)selectedGmfgenFiles.get(0)));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (PartInitException ex) {
            Plugin.log((CoreException)ex);
        }
        return true;
    }

    protected void addExtensionMetamodelRootToGmfgen(URI nextGmfgenURI, EObject instantiated) throws IOException {
        Resource gmfgenModel = this.getResourceSet().createResource(nextGmfgenURI);
        gmfgenModel.load(this.getResourceSet().getLoadOptions());
        gmfgenModel.getContents().add((Object)instantiated);
        gmfgenModel.save(null);
        gmfgenModel.unload();
    }
}

