/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileEditorInputProxy;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class EcoreDocumentProvider
extends StorageDocumentProvider
implements IDiagramDocumentProvider {
    private final String myContentObjectURI;

    public EcoreDocumentProvider() {
        this(null);
    }

    public EcoreDocumentProvider(String rootObjectURI) {
        this.myContentObjectURI = rootObjectURI;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (!(element instanceof FileEditorInputProxy)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 0, "Incorrect element used: " + element + " instead of FileEditorInputProxy", null));
        }
        FileEditorInputProxy editorInput = (FileEditorInputProxy)element;
        IDiagramDocument document = (IDiagramDocument)this.createDocument(editorInput);
        ResourceSetInfo info = new ResourceSetInfo(document, editorInput);
        info.setModificationStamp(this.computeModificationStamp(info));
        info.fStatus = null;
        ResourceSetModificationListener modificationListener = new ResourceSetModificationListener(info);
        info.getResourceSet().eAdapters().add((Object)modificationListener);
        return info;
    }

    private long computeModificationStamp(ResourceSetInfo info) {
        int result = 0;
        for (Resource nextResource : info.getResourceSet().getResources()) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
            if (file == null) continue;
            result = file.getLocation() != null ? (int)((long)result + file.getLocation().toFile().lastModified()) : (int)((long)result + file.getModificationStamp());
        }
        return result;
    }

    protected IDocument createEmptyDocument() {
        return new DiagramDocument();
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        if (editorInput instanceof FileEditorInputProxy && document instanceof IDiagramDocument) {
            FileEditorInputProxy editorInputProxy = (FileEditorInputProxy)editorInput;
            IDiagramDocument diagramDocument = (IDiagramDocument)document;
            diagramDocument.setEditingDomain(editorInputProxy.getEditingDomain());
        }
        return super.setDocumentContent(document, editorInput);
    }

    protected void setDocumentContentFromStorage(IDocument document, IStorage storage) throws CoreException {
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        Diagram diagram = diagramDocument.getDiagram();
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        diagram = DiagramIOUtil.load((TransactionalEditingDomain)domain, (IStorage)storage, (boolean)true, (IProgressMonitor)this.getProgressMonitor());
        if (this.myContentObjectURI != null && diagram != null && diagram.eResource() != null && !diagram.eResource().getURIFragment((EObject)diagram).equals(this.myContentObjectURI)) {
            EObject anotherContentObject = diagram.eResource().getEObject(this.myContentObjectURI);
            document.setContent((Object)anotherContentObject);
        } else {
            document.setContent((Object)diagram);
        }
    }

    public long getModificationStamp(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            return this.computeModificationStamp(info);
        }
        return super.getModificationStamp(element);
    }

    public long getSynchronizationStamp(Object element) {
        ResourceSetInfo info;
        if (element instanceof FileEditorInputProxy && (info = this.getResourceSetInfo(element)) != null) {
            return info.getModificationStamp();
        }
        return super.getSynchronizationStamp(element);
    }

    public boolean isDeleted(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IPath path = input.getFile().getLocation();
            if (path == null) {
                return true;
            }
            return !path.toFile().exists();
        }
        return super.isDeleted(element);
    }

    public ResourceSetInfo getResourceSetInfo(Object editorInput) {
        return (ResourceSetInfo)super.getElementInfo(editorInput);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof ResourceSetInfo) {
            ResourceSetInfo resourceSetInfo = (ResourceSetInfo)info;
            resourceSetInfo.dispose();
        }
        super.disposeElementInfo(element, info);
    }

    protected void doValidateState(Object element, Object computationContext) throws CoreException {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            ArrayList<IFile> files2Validate = new ArrayList<IFile>();
            for (Resource nextResource : info.getResourceSet().getResources()) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null || !file.isReadOnly()) continue;
                files2Validate.add(file);
            }
            ResourcesPlugin.getWorkspace().validateEdit(files2Validate.toArray(new IFile[files2Validate.size()]), computationContext);
        }
        super.doValidateState(element, computationContext);
    }

    public boolean isModifiable(Object element) {
        if (!this.isStateValidated(element) && element instanceof FileEditorInputProxy) {
            return true;
        }
        return super.isModifiable(element);
    }

    protected void updateCache(IStorageEditorInput input) throws CoreException {
        ResourceSetInfo info = this.getResourceSetInfo(input);
        if (info != null) {
            for (Resource nextResource : info.getResourceSet().getResources()) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null || !file.isReadOnly()) continue;
                info.fIsReadOnly = true;
                info.fIsModifiable = false;
                return;
            }
            info.fIsReadOnly = false;
            info.fIsModifiable = true;
            return;
        }
        super.updateCache(input);
    }

    public boolean isSynchronized(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            return info.isSynchronized();
        }
        return super.isSynchronized(element);
    }

    protected ISchedulingRule getResetRule(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
            for (Resource nextResource : info.getResourceSet().getResources()) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null) continue;
                rules.add(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)file));
            }
            return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return null;
    }

    protected ISchedulingRule getSaveRule(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
            for (Resource nextResource : info.getResourceSet().getResources()) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null) continue;
                rules.add(this.computeSchedulingRule((IResource)file));
            }
            return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return null;
    }

    protected ISchedulingRule getSynchronizeRule(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
            for (Resource nextResource : info.getResourceSet().getResources()) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null) continue;
                rules.add(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)file));
            }
            return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return null;
    }

    protected ISchedulingRule getValidateStateRule(Object element) {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            for (Resource nextResource : info.getResourceSet().getResources()) {
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null) continue;
                files.add(file);
            }
            return ResourcesPlugin.getWorkspace().getRuleFactory().validateEditRule((IResource[])files.toArray(new IFile[files.size()]));
        }
        return null;
    }

    private ISchedulingRule computeSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists()) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists()) {
        }
        return ResourcesPlugin.getWorkspace().getRuleFactory().createRule(toCreateOrModify);
    }

    protected void doSynchronize(Object element, IProgressMonitor monitor) throws CoreException {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null && element instanceof FileEditorInputProxy) {
            this.handleResourcesChanged(info, (Collection)info.getResourceSet().getResources(), monitor);
            return;
        }
        super.doSynchronize(element, monitor);
    }

    protected void handleResourcesMoved(Map movedPathToResource) {
        for (Map.Entry nextEntry : movedPathToResource.entrySet()) {
            IPath newPath = (IPath)nextEntry.getKey();
            Resource resource = (Resource)nextEntry.getValue();
            resource.setURI(URI.createURI((String)newPath.toString()));
        }
    }

    protected void markWholeResourceSetAsDirty(ResourceSet resourceSet) {
        for (Resource nextResource : resourceSet.getResources()) {
            nextResource.setModified(true);
        }
    }

    protected void handleResourcesChanged(ResourceSetInfo info, Collection changedResources, IProgressMonitor monitor) {
        info.stopResourceListening();
        for (Resource nextResource : changedResources) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
            if (file != null) {
                try {
                    file.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    this.handleCoreException(e, "FileDocumentProvider.handleElementContentChanged");
                }
            }
            nextResource.unload();
        }
        info.startResourceListening();
        this.fireElementContentAboutToBeReplaced(info.getEditorInput());
        this.removeUnchangedElementListeners(info.getEditorInput(), (AbstractDocumentProvider.ElementInfo)info);
        info.fStatus = null;
        try {
            this.setDocumentContent(info.fDocument, (IEditorInput)info.getEditorInput());
        }
        catch (CoreException e) {
            info.fStatus = e.getStatus();
        }
        if (!info.fCanBeSaved) {
            info.setModificationStamp(this.computeModificationStamp(info));
        }
        this.addUnchangedElementListeners(info.getEditorInput(), (AbstractDocumentProvider.ElementInfo)info);
        this.fireElementContentReplaced(info.getEditorInput());
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        ResourceSetInfo info = this.getResourceSetInfo(element);
        if (info != null) {
            if (!overwrite && !info.isSynchronized()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 274, "The file has been changed on the file system", null));
            }
            info.stopResourceListening();
            this.fireElementStateChanging(element);
            try {
                try {
                    monitor.beginTask("Saving diagram editor", info.getResourceSet().getResources().size());
                    for (Resource nextResource : info.getResourceSet().getResources()) {
                        monitor.setTaskName("Saving " + nextResource.getURI());
                        if (nextResource.isLoaded() && (!nextResource.isTrackingModification() || nextResource.isModified())) {
                            nextResource.save(Collections.EMPTY_MAP);
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
                catch (IOException e) {
                    this.fireElementStateChangeFailed(element);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.gmf.ecore.editor", 5, e.getLocalizedMessage(), null));
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
            }
            finally {
                info.startResourceListening();
            }
            if (info != null) {
                info.setModificationStamp(this.computeModificationStamp(info));
                info.setSynchronized();
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    protected void handleElementMoved(FileEditorInputProxy input, IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile newFile = workspace.getRoot().getFile(path);
        this.fireElementMoved(input, newFile == null ? null : new FileEditorInput(newFile));
    }

    protected void handleElementDeleted(FileEditorInputProxy input) {
        this.fireElementDeleted(input);
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput editorInput, TransactionalEditingDomain domain) {
        if (editorInput instanceof IFileEditorInput) {
            return new FileEditorInputProxy((IFileEditorInput)editorInput, domain);
        }
        assert (false);
        return null;
    }

    public IDiagramDocument getDiagramDocument(Object element) {
        IDocument doc = this.getDocument(element);
        if (doc instanceof IDiagramDocument) {
            return (IDiagramDocument)doc;
        }
        return null;
    }

    protected class ResourceSetInfo
    extends StorageDocumentProvider.StorageInfo {
        private long myModificationStamp;
        private ResourceSetSynchronizer mySynchronizer;
        private ResourceSet myResourceSet;
        private Collection myUnSynchronizedResources;
        private FileEditorInputProxy myEditorInput;

        public ResourceSetInfo(IDiagramDocument document, FileEditorInputProxy editorInput) {
            super((StorageDocumentProvider)EcoreDocumentProvider.this, (IDocument)document);
            this.myModificationStamp = -1L;
            this.myUnSynchronizedResources = new ArrayList();
            this.myResourceSet = document.getEditingDomain().getResourceSet();
            this.myEditorInput = editorInput;
            this.mySynchronizer = new ResourceSetSynchronizer(this);
            this.startResourceListening();
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        public void setModificationStamp(long modificationStamp) {
            this.myModificationStamp = modificationStamp;
        }

        public ResourceSetSynchronizer getSynchronizer() {
            return this.mySynchronizer;
        }

        public ResourceSet getResourceSet() {
            return this.myResourceSet;
        }

        public FileEditorInputProxy getEditorInput() {
            return this.myEditorInput;
        }

        public void dispose() {
            this.stopResourceListening();
        }

        public boolean isSynchronized() {
            return this.myUnSynchronizedResources.size() == 0;
        }

        public void setSynchronized() {
            this.myUnSynchronizedResources.clear();
        }

        public void setUnSynchronized(Resource resource) {
            this.myUnSynchronizedResources.add(resource);
        }

        public void setSynchronized(Resource resource) {
            this.myUnSynchronizedResources.remove(resource);
        }

        public final void stopResourceListening() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.mySynchronizer);
        }

        public final void startResourceListening() {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.mySynchronizer, 1);
        }
    }

    protected class ResourceSetSynchronizer
    implements IResourceChangeListener {
        private ResourceSetInfo myInfo;

        protected ResourceSetSynchronizer(ResourceSetInfo info) {
            this.myInfo = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            final ResourceDeltaVisitor deltaVisitor = new ResourceDeltaVisitor();
            try {
                event.getDelta().accept((IResourceDeltaVisitor)deltaVisitor);
            }
            catch (CoreException e) {
                EcoreDocumentProvider.this.handleCoreException(e, "FileDocumentProvider.resourceChanged");
            }
            ResourceSetInfo resourceSetInfo = this.myInfo;
            synchronized (resourceSetInfo) {
                if (!this.myInfo.isSynchronized()) {
                    return;
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (deltaVisitor.getDeletedResources().size() > 0) {
                        EcoreDocumentProvider.this.handleElementDeleted(ResourceSetSynchronizer.this.myInfo.getEditorInput());
                        return;
                    }
                    Map.Entry diagramEntry = ResourceSetSynchronizer.this.getDiagramResourceEntry(deltaVisitor.getMovedResourcesMap());
                    if (diagramEntry != null) {
                        deltaVisitor.getMovedResourcesMap().remove(diagramEntry.getKey());
                        EcoreDocumentProvider.this.handleElementMoved(ResourceSetSynchronizer.this.myInfo.getEditorInput(), (IPath)diagramEntry.getKey());
                    }
                    if (deltaVisitor.getMovedResourcesMap().size() > 0) {
                        EcoreDocumentProvider.this.handleResourcesMoved(deltaVisitor.getMovedResourcesMap());
                    }
                    if (deltaVisitor.getChangedResources().size() > 0 || deltaVisitor.getMovedResourcesMap().size() > 0) {
                        EcoreDocumentProvider.this.handleResourcesChanged(ResourceSetSynchronizer.this.myInfo, deltaVisitor.getChangedResources(), null);
                    }
                    if (deltaVisitor.getMovedResourcesMap().size() > 0) {
                        EcoreDocumentProvider.this.markWholeResourceSetAsDirty(ResourceSetSynchronizer.this.myInfo.getResourceSet());
                    }
                }
            });
        }

        private Map.Entry getDiagramResourceEntry(Map movedResources) {
            for (Map.Entry nextEntry : movedResources.entrySet()) {
                Resource nextResource = (Resource)nextEntry.getValue();
                IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
                if (file == null || !file.equals((Object)this.myInfo.getEditorInput().getFile())) continue;
                return nextEntry;
            }
            return null;
        }

        private class ResourceDeltaVisitor
        implements IResourceDeltaVisitor {
            private Collection myChangedResources = new ArrayList();
            private Map myMovedResources = new HashMap();
            private Collection myDeletedResources = new ArrayList();

            private ResourceDeltaVisitor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean visit(IResourceDelta delta) {
                if (delta.getFlags() == 131072) return true;
                if (delta.getResource().getType() != 1) return true;
                if ((delta.getKind() & 6) == 0) return true;
                Resource resource = ResourceSetSynchronizer.this.myInfo.getResourceSet().getResource(URI.createURI((String)delta.getFullPath().toString()), false);
                if (resource == null) return true;
                if (!resource.isLoaded()) return true;
                ResourceSetInfo resourceSetInfo = ResourceSetSynchronizer.this.myInfo;
                synchronized (resourceSetInfo) {
                    if (((ResourceSetSynchronizer)ResourceSetSynchronizer.this).myInfo.fCanBeSaved) {
                        ResourceSetSynchronizer.this.myInfo.setUnSynchronized(resource);
                        return false;
                    }
                }
                if ((delta.getKind() & 2) == 0) {
                    this.myChangedResources.add(resource);
                    return true;
                }
                if ((0x2000 & delta.getFlags()) != 0) {
                    IPath destination = delta.getMovedToPath();
                    this.myMovedResources.put(destination, resource);
                    return true;
                }
                this.myDeletedResources.add(resource);
                return true;
            }

            public Collection getChangedResources() {
                return this.myChangedResources;
            }

            public Collection getDeletedResources() {
                return this.myDeletedResources;
            }

            public Map getMovedResourcesMap() {
                return this.myMovedResources;
            }
        }
    }

    private class ResourceSetModificationListener
    extends EContentAdapter {
        private NotificationFilter myModifiedFilter;
        private ResourceSetInfo myInfo;

        public ResourceSetModificationListener(ResourceSetInfo info) {
            this.myInfo = info;
            this.myModifiedFilter = NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createFeatureFilter(Resource.class, (int)3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification notification) {
            Resource resource;
            if (notification.getNotifier() instanceof ResourceSet) {
                super.notifyChanged(notification);
            }
            if (this.myModifiedFilter.matches(notification) && notification.getNotifier() instanceof Resource && (resource = (Resource)notification.getNotifier()).isLoaded()) {
                boolean modified = false;
                Iterator it = this.myInfo.getResourceSet().getResources().iterator();
                while (it.hasNext() && !modified) {
                    Resource nextResource = (Resource)it.next();
                    if (!nextResource.isLoaded()) continue;
                    modified = nextResource.isModified();
                }
                boolean dirtyStateChanged = false;
                ResourceSetInfo resourceSetInfo = this.myInfo;
                synchronized (resourceSetInfo) {
                    if (modified != this.myInfo.fCanBeSaved) {
                        this.myInfo.fCanBeSaved = modified;
                        dirtyStateChanged = true;
                    }
                    if (!resource.isModified()) {
                        this.myInfo.setSynchronized(resource);
                    }
                }
                if (dirtyStateChanged) {
                    EcoreDocumentProvider.this.fireElementDirtyStateChanged(this.myInfo.getEditorInput(), modified);
                    if (!modified) {
                        this.myInfo.setModificationStamp(EcoreDocumentProvider.this.computeModificationStamp(this.myInfo));
                    }
                }
            }
        }
    }
}

