/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.expressions;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.OperationCallExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.Visitor;
import org.eclipse.emf.ocl.expressions.util.AbstractVisitor;
import org.eclipse.emf.ocl.helper.HelperUtil;
import org.eclipse.emf.ocl.helper.IOCLHelper;
import org.eclipse.emf.ocl.helper.OCLParsingException;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.EcoreEnvironmentFactory;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.gmf.ecore.expressions.EcoreAbstractExpression;

public class EcoreOCLFactory {
    private EcoreOCLFactory() {
    }

    public static EcoreAbstractExpression getExpression(String body, EClassifier context, Map environment) {
        return new Expression(body, context, environment);
    }

    public static EcoreAbstractExpression getExpression(String body, EClassifier context) {
        return EcoreOCLFactory.getExpression(body, context, Collections.EMPTY_MAP);
    }

    private static class Expression
    extends EcoreAbstractExpression {
        private WeakReference queryRef;

        public Expression(String body, EClassifier context, Map environment) {
            super(body, context, environment);
        }

        protected Query getQuery() {
            Query oclQuery = null;
            if (this.queryRef != null) {
                oclQuery = (Query)this.queryRef.get();
            }
            if (oclQuery == null) {
                IOCLHelper oclHelper = this.environment().isEmpty() ? HelperUtil.createOCLHelper() : HelperUtil.createOCLHelper((EnvironmentFactory)Expression.createCustomEnv(this.environment()));
                oclHelper.setContext((Object)this.context());
                try {
                    OCLExpression oclExpression = oclHelper.createQuery(this.body());
                    oclQuery = QueryFactory.eINSTANCE.createQuery(oclExpression);
                    this.queryRef = new WeakReference<Query>(oclQuery);
                    this.setStatus(0, null, null);
                }
                catch (OCLParsingException e) {
                    this.setStatus(4, e.getMessage(), e);
                }
            }
            return oclQuery;
        }

        protected Object doEvaluate(Object context, Map env) {
            Query oclQuery = this.getQuery();
            if (oclQuery == null) {
                return null;
            }
            EvaluationEnvironment evalEnv = oclQuery.getEvaluationEnvironment();
            for (Map.Entry nextEntry : env.entrySet()) {
                evalEnv.replace((String)nextEntry.getKey(), nextEntry.getValue());
            }
            try {
                this.initExtentMap(context);
                Object result = oclQuery.evaluate(context);
                Object object = result != Types.OCL_INVALID ? result : null;
                return object;
            }
            finally {
                evalEnv.clear();
                oclQuery.setExtentMap(Collections.EMPTY_MAP);
            }
        }

        protected Object performCast(Object value, ETypedElement targetType) {
            if (targetType.getEType() instanceof EEnum && value instanceof EEnumLiteral) {
                EEnumLiteral literal = (EEnumLiteral)value;
                return literal.getInstance() != null ? literal.getInstance() : literal;
            }
            return super.performCast(value, targetType);
        }

        private void initExtentMap(Object context) {
            if (!this.getStatus().isOK() || context == null) {
                return;
            }
            final Query queryToInit = this.getQuery();
            final Object extentContext = context;
            queryToInit.setExtentMap(Collections.EMPTY_MAP);
            if (queryToInit.queryText() != null && queryToInit.queryText().indexOf("allInstances") >= 0) {
                AbstractVisitor visitior = new AbstractVisitor(){
                    private boolean usesAllInstances = false;

                    public Object visitOperationCallExp(OperationCallExp oc) {
                        if (!this.usesAllInstances) {
                            boolean bl = this.usesAllInstances = 40 == oc.getOperationCode();
                            if (this.usesAllInstances) {
                                queryToInit.setExtentMap(EcoreEnvironmentFactory.ECORE_INSTANCE.createExtentMap(extentContext));
                            }
                        }
                        return super.visitOperationCallExp(oc);
                    }
                };
                queryToInit.getExpression().accept((Visitor)visitior);
            }
        }

        private static EcoreEnvironmentFactory createCustomEnv(Map environment) {
            final Map env = environment;
            return new EcoreEnvironmentFactory(){

                public Environment createClassifierContext(Object context) {
                    Environment ecoreEnv = super.createClassifierContext(context);
                    for (String varName : env.keySet()) {
                        EClassifier varType = (EClassifier)env.get(varName);
                        ecoreEnv.addElement(varName, Expression.createVar(varName, varType), false);
                    }
                    return ecoreEnv;
                }
            };
        }

        private static Variable createVar(String name, EClassifier type) {
            Variable var = ExpressionsFactory.eINSTANCE.createVariable();
            var.setName(name);
            var.setType(EcoreEnvironment.getOCLType((EClassifier)type));
            return var;
        }
    }
}

