/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers;

import com.ibm.icu.util.StringTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.ActivityUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteTemplateEntry;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersPlugin;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteDrawer;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteSeparator;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteStack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class DefaultPaletteProvider
extends AbstractProvider
implements IPaletteProvider {
    private static final String CONTRIBUTION = "contribution";
    private static final String FACTORY_CLASS = "factoryClass";
    private static final String ENTRY = "entry";
    private static final String KIND = "kind";
    private static final String ID = "id";
    private static final String PATH = "path";
    private static final String LABEL = "label";
    private static final String DESCRIPTION = "description";
    private static final String SMALL_ICON = "small_icon";
    private static final String LARGE_ICON = "large_icon";
    private static final String EXPAND = "expand";
    private static final String FORCE = "force";
    private static final String CONTENT = "content";
    private static final String DEFINE_ONLY = "defineOnly";
    private static final String PREDEFINED_ENTRY = "predefinedEntry";
    private static final String REMOVE = "remove";
    private static final String DRAWER = "drawer";
    private static final String STACK = "stack";
    private static final String SEPARATOR = "separator";
    private static final String TEMPLATE = "template";
    private static final String TOOL = "tool";
    private static final int ENUM_DRAWER = 0;
    private static final int ENUM_STACK = 1;
    private static final int ENUM_SEPARATOR = 2;
    private static final int ENUM_TEMPLATE = 3;
    private static final int ENUM_TOOL = 4;
    private static final String NONE = "None";
    private static final String HIDEONLY = "HideOnly";
    private static final String LIMITED = "limited";
    private static final String FULL = "full";
    private List contributions = new ArrayList();
    private String pluginID;

    private static PaletteEntry findPredefinedEntry(Map predefinedEntries, String path) {
        StringTokenizer tokens = new StringTokenizer(path, "/");
        PaletteEntry root = (PaletteEntry)predefinedEntries.get(tokens.nextToken());
        while (tokens.hasMoreElements()) {
            if (root instanceof PaletteContainer) {
                root = DefaultPaletteProvider.findChildPaletteEntry((PaletteContainer)root, tokens.nextToken());
                continue;
            }
            return null;
        }
        return root;
    }

    private static PaletteEntry findPaletteEntry(PaletteEntry root, String aPath) {
        StringTokenizer tokens = new StringTokenizer(aPath, "/");
        while (tokens.hasMoreElements()) {
            if (root instanceof PaletteContainer) {
                root = DefaultPaletteProvider.findChildPaletteEntry((PaletteContainer)root, tokens.nextToken());
                continue;
            }
            return null;
        }
        return root;
    }

    private static PaletteEntry findChildPaletteEntry(PaletteContainer container, String childId) {
        for (PaletteEntry entry : container.getChildren()) {
            if (!entry.getId().equals(childId)) continue;
            return entry;
        }
        return null;
    }

    private static void appendPaletteEntry(PaletteRoot root, Map predefinedEntries, String path, PaletteEntry paletteEntry) {
        PaletteEntry fEntry = DefaultPaletteProvider.findPaletteEntry((PaletteEntry)root, path);
        if (fEntry == null) {
            fEntry = DefaultPaletteProvider.findPredefinedEntry(predefinedEntries, path);
        }
        if (fEntry == null) {
            Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"Invalid palette entry path");
        } else if (fEntry instanceof PaletteContainer) {
            ((PaletteContainer)fEntry).add(paletteEntry);
        } else if (fEntry instanceof PaletteSeparator) {
            DefaultPaletteProvider.appendTo((PaletteSeparator)fEntry, paletteEntry);
        } else {
            fEntry.getParent().add(fEntry.getParent().getChildren().indexOf(fEntry) + 1, paletteEntry);
        }
    }

    private static void appendTo(PaletteSeparator separator, PaletteEntry entry) {
        List children = separator.getParent().getChildren();
        int index = children.indexOf(separator);
        ++index;
        while (index < children.size()) {
            if (children.get(index) instanceof PaletteSeparator) break;
            ++index;
        }
        separator.getParent().add(index, entry);
    }

    public void setContributions(IConfigurationElement configElement) {
        this.pluginID = configElement.getContributor().getName();
        IConfigurationElement[] configChildren = configElement.getChildren(CONTRIBUTION);
        int i = 0;
        while (i < configChildren.length) {
            this.contributions.add(new ContributionDescriptor(configChildren[i]));
            ++i;
        }
    }

    public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
        Iterator iter = this.contributions.iterator();
        while (iter.hasNext()) {
            ((ContributionDescriptor)iter.next()).contribute(content, root, predefinedEntries, this.pluginID);
        }
    }

    public boolean provides(IOperation operation) {
        return false;
    }

    private static class ContributionDescriptor {
        private PaletteFactoryProxy paletteFactory;
        private List entries = new ArrayList();

        public ContributionDescriptor(IConfigurationElement configElement) {
            this.paletteFactory = new PaletteFactoryProxy(configElement);
            IConfigurationElement[] configChildren = configElement.getChildren(DefaultPaletteProvider.ENTRY);
            int i = 0;
            while (i < configChildren.length) {
                this.entries.add(new EntryDescriptor(configChildren[i]));
                ++i;
            }
            configChildren = configElement.getChildren(DefaultPaletteProvider.PREDEFINED_ENTRY);
            i = 0;
            while (i < configChildren.length) {
                this.entries.add(new PredefinedEntryDescriptor(configChildren[i]));
                ++i;
            }
        }

        public void contribute(Object content, PaletteRoot root, Map predefinedEntries, String pluginID) {
            for (IEntryDescriptor descriptor : this.entries) {
                if (!ActivityUtil.isEnabled((String)descriptor.getID(), (String)pluginID)) continue;
                descriptor.contribute(content, root, this.paletteFactory, predefinedEntries);
            }
        }
    }

    private static class DrawerExpandHelper {
        private Boolean force;
        private AbstractProviderConfiguration.ObjectDescriptor content;

        public DrawerExpandHelper(Boolean force) {
            this.force = force;
        }

        public DrawerExpandHelper(IConfigurationElement configElement) {
            String forceStr = configElement.getAttribute(DefaultPaletteProvider.FORCE);
            this.force = forceStr == null ? Boolean.FALSE : Boolean.valueOf(forceStr);
            IConfigurationElement[] configChildren = configElement.getChildren(DefaultPaletteProvider.CONTENT);
            if (configChildren.length > 0) {
                this.content = new AbstractProviderConfiguration.ObjectDescriptor(configChildren[0]);
            }
        }

        public boolean expand(Object targetContent) {
            if (this.force == Boolean.TRUE) {
                return true;
            }
            return this.content != null && this.content.sameAs(targetContent);
        }
    }

    private static class EntryDescriptor
    implements IEntryDescriptor {
        private Integer kind;
        private String id;
        private String path;
        private String label;
        private String description;
        private Integer permission;
        private ImageDescriptor small_icon;
        private ImageDescriptor large_icon;
        private DrawerExpandHelper expandHelper;
        private boolean defineOnly;

        public EntryDescriptor(IConfigurationElement configElement) {
            String kindStr = configElement.getAttribute(DefaultPaletteProvider.KIND);
            if (DefaultPaletteProvider.DRAWER.equals(kindStr)) {
                this.kind = new Integer(0);
            } else if (DefaultPaletteProvider.STACK.equals(kindStr)) {
                this.kind = new Integer(1);
            } else if (DefaultPaletteProvider.SEPARATOR.equals(kindStr)) {
                this.kind = new Integer(2);
            } else if (DefaultPaletteProvider.TEMPLATE.equals(kindStr)) {
                this.kind = new Integer(3);
            } else if (DefaultPaletteProvider.TOOL.equals(kindStr)) {
                this.kind = new Integer(4);
            } else {
                Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"No factory class name is provided");
            }
            this.id = configElement.getAttribute(DefaultPaletteProvider.ID);
            if (this.id == null) {
                Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"No factory class name is provided");
            }
            this.defineOnly = Boolean.valueOf(configElement.getAttribute(DefaultPaletteProvider.DEFINE_ONLY));
            this.path = configElement.getAttribute(DefaultPaletteProvider.PATH);
            if (this.path == null && !this.defineOnly) {
                Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"Path must be provided when contributing a palette entry");
            }
            this.label = configElement.getAttribute(DefaultPaletteProvider.LABEL);
            if (this.label == null) {
                this.label = DiagramUIMessages.PaletteEntry_DefaultLabel;
            }
            this.description = configElement.getAttribute(DefaultPaletteProvider.DESCRIPTION);
            if (DefaultPaletteProvider.NONE.equals(kindStr)) {
                this.permission = new Integer(1);
            }
            if (DefaultPaletteProvider.HIDEONLY.equals(kindStr)) {
                this.permission = new Integer(3);
            }
            if (DefaultPaletteProvider.LIMITED.equals(kindStr)) {
                this.permission = new Integer(7);
            }
            if (DefaultPaletteProvider.FULL.equals(kindStr)) {
                this.permission = new Integer(15);
            }
            String smallIconPath = configElement.getAttribute(DefaultPaletteProvider.SMALL_ICON);
            this.small_icon = this.findIconImageDescriptor(configElement, smallIconPath);
            String largeIconPath = configElement.getAttribute(DefaultPaletteProvider.LARGE_ICON);
            this.large_icon = this.findIconImageDescriptor(configElement, largeIconPath);
            if (this.kind == 0) {
                IConfigurationElement[] configChildren = configElement.getChildren(DefaultPaletteProvider.EXPAND);
                this.expandHelper = configChildren.length > 0 ? new DrawerExpandHelper(configChildren[0]) : new DrawerExpandHelper(Boolean.FALSE);
            }
        }

        private ImageDescriptor findIconImageDescriptor(IConfigurationElement configElement, String iconPath) {
            String pluginId = configElement.getDeclaringExtension().getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)pluginId);
            try {
                if (iconPath != null) {
                    URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(iconPath), null);
                    URL uRL = fullPathString = fullPathString != null ? fullPathString : new URL(iconPath);
                    if (fullPathString != null) {
                        return ImageDescriptor.createFromURL((URL)fullPathString);
                    }
                }
            }
            catch (MalformedURLException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, DefaultPaletteProvider.class, (String)e.getLocalizedMessage(), (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)5, (String)e.getMessage(), (Throwable)e);
            }
            return null;
        }

        public void contribute(Object content, PaletteRoot root, PaletteFactoryProxy paletteFactory, Map predefinedEntries) {
            if (this.kind == null || this.id == null || this.label == null) {
                return;
            }
            PaletteSeparator paletteEntry = null;
            switch (this.kind) {
                case 0: {
                    PaletteDrawer drawer = new PaletteDrawer(this.id, this.label);
                    if (this.expandHelper.expand(content)) {
                        drawer.setInitialState(0);
                    }
                    paletteEntry = drawer;
                    break;
                }
                case 1: {
                    paletteEntry = new PaletteStack(this.id, this.label, this.description, this.small_icon);
                    break;
                }
                case 2: {
                    paletteEntry = new PaletteSeparator(this.id);
                    break;
                }
                case 3: {
                    paletteEntry = new PaletteTemplateEntry(this.id, this.label, (PaletteFactory)paletteFactory);
                    break;
                }
                case 4: {
                    paletteEntry = new PaletteToolEntry(this.id, this.label, (PaletteFactory)paletteFactory);
                }
            }
            if (paletteEntry != null) {
                paletteEntry.setDescription(this.description);
                paletteEntry.setSmallIcon(this.small_icon);
                paletteEntry.setLargeIcon(this.large_icon);
                if (this.permission != null) {
                    paletteEntry.setUserModificationPermission(this.permission.intValue());
                }
                if (this.defineOnly) {
                    predefinedEntries.put(this.id, paletteEntry);
                } else {
                    DefaultPaletteProvider.appendPaletteEntry(root, predefinedEntries, this.path, (PaletteEntry)paletteEntry);
                }
            }
        }

        public String getID() {
            return this.id;
        }
    }

    private static interface IEntryDescriptor {
        public void contribute(Object var1, PaletteRoot var2, PaletteFactoryProxy var3, Map var4);

        public String getID();
    }

    private static class PaletteFactoryProxy
    extends PaletteFactory.Adapter {
        private IConfigurationElement configElement;
        private PaletteFactory factory;

        public PaletteFactoryProxy(IConfigurationElement configElement) {
            this.configElement = configElement;
        }

        public Object getTemplate(String templateId) {
            if (this.factory == null) {
                try {
                    Object ext = this.configElement.createExecutableExtension(DefaultPaletteProvider.FACTORY_CLASS);
                    this.factory = (PaletteFactory)ext;
                }
                catch (CoreException coreException) {
                    Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"No factory class name is provided");
                }
            }
            if (this.factory != null) {
                Object template = this.factory.getTemplate(templateId);
                if (template == null) {
                    Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"No factory class name is provided");
                }
                return template;
            }
            return null;
        }

        public Tool createTool(String toolId) {
            if (this.factory == null) {
                try {
                    Object ext = this.configElement.createExecutableExtension(DefaultPaletteProvider.FACTORY_CLASS);
                    this.factory = (PaletteFactory)ext;
                }
                catch (CoreException coreException) {
                    Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"No factory class name is provided");
                }
            }
            if (this.factory != null) {
                Tool tool = this.factory.createTool(toolId);
                if (tool == null) {
                    Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"No factory class name is provided");
                }
                return tool;
            }
            return null;
        }
    }

    private static class PredefinedEntryDescriptor
    implements IEntryDescriptor {
        private String id;
        private String path;
        private DrawerExpandHelper expandHelper;
        private boolean remove;

        public PredefinedEntryDescriptor(IConfigurationElement configElement) {
            this.id = configElement.getAttribute(DefaultPaletteProvider.ID);
            if (this.id == null) {
                Log.info((Plugin)DiagramProvidersPlugin.getInstance(), (int)7, (String)"No ID provided");
            }
            this.path = configElement.getAttribute(DefaultPaletteProvider.PATH);
            IConfigurationElement[] configChildren = configElement.getChildren(DefaultPaletteProvider.EXPAND);
            this.expandHelper = configChildren.length > 0 ? new DrawerExpandHelper(configChildren[0]) : new DrawerExpandHelper(Boolean.FALSE);
            this.remove = Boolean.valueOf(configElement.getAttribute(DefaultPaletteProvider.REMOVE));
        }

        public void contribute(Object content, PaletteRoot root, PaletteFactoryProxy paletteFactory, Map predefinedEntries) {
            if (this.id == null) {
                return;
            }
            PaletteEntry paletteEntry = DefaultPaletteProvider.findPaletteEntry((PaletteEntry)root, this.id);
            if (paletteEntry != null) {
                if (this.remove) {
                    paletteEntry.getParent().remove(paletteEntry);
                    return;
                }
                if (paletteEntry instanceof PaletteDrawer && this.expandHelper.expand(content)) {
                    ((PaletteDrawer)paletteEntry).setInitialState(0);
                }
            }
            if (paletteEntry == null) {
                paletteEntry = DefaultPaletteProvider.findPredefinedEntry(predefinedEntries, this.id);
            }
            if (paletteEntry != null && this.path != null) {
                DefaultPaletteProvider.appendPaletteEntry(root, predefinedEntries, this.path, paletteEntry);
                if (paletteEntry instanceof PaletteDrawer && this.expandHelper.expand(content)) {
                    ((PaletteDrawer)paletteEntry).setInitialState(0);
                }
            }
        }

        public String getID() {
            return this.id;
        }
    }
}

