/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconProvider;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;

public class DiagramIconProvider
extends AbstractProvider
implements IIconProvider {
    private static HashMap typeIconMap = new HashMap();

    static {
        typeIconMap.put(DiagramNotationType.NOTE, "icons/note.gif");
        typeIconMap.put(DiagramNotationType.TEXT, "icons/text.gif");
    }

    public Image getIcon(IAdaptable hint, int flags) {
        View view = (View)hint.getAdapter(View.class);
        if (view != null) {
            if (DiagramViewProvider.isTextView(view)) {
                return SharedImages.get((String)"icons/text.gif");
            }
            if (DiagramViewProvider.isNoteView(view)) {
                return SharedImages.get((String)"icons/note.gif");
            }
        } else if (hint.getAdapter(IElementType.class) != null) {
            String fileName = (String)typeIconMap.get(hint);
            return SharedImages.get((String)fileName);
        }
        return null;
    }

    public boolean provides(IOperation operation) {
        IIconOperation oper = (IIconOperation)operation;
        IAdaptable adapter = oper.getHint();
        if (adapter == null) {
            return false;
        }
        View view = (View)adapter.getAdapter(View.class);
        if (view != null && (DiagramViewProvider.isNoteView(view) || DiagramViewProvider.isTextView(view))) {
            return true;
        }
        if (oper.getHint().getAdapter(IElementType.class) != null) {
            String fileName = (String)typeIconMap.get(oper.getHint());
            return fileName != null;
        }
        return false;
    }
}

