/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.services.editpart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;

public class EditPartProviderConfiguration
extends AbstractProviderConfiguration {
    private static final String CONTEXT = "context";
    private static final String VIEWS = "views";
    private static final String PROVIDES_ROOT_EDITPART = "providesRootEditPart";
    private List requests = new ArrayList();

    public static EditPartProviderConfiguration parse(IConfigurationElement configElement) {
        Assert.isNotNull((Object)configElement, (String)"null provider configuration element");
        return new EditPartProviderConfiguration(configElement);
    }

    private EditPartProviderConfiguration(IConfigurationElement configElement) {
        HashMap<String, AbstractProviderConfiguration.ObjectDescriptor> objects = new HashMap<String, AbstractProviderConfiguration.ObjectDescriptor>();
        IConfigurationElement[] configChildren = configElement.getChildren("object");
        int i = 0;
        while (i < configChildren.length) {
            String id = configChildren[i].getAttribute("id");
            if (id != null) {
                objects.put(id, new AbstractProviderConfiguration.ObjectDescriptor(configChildren[i]));
            }
            ++i;
        }
        configChildren = configElement.getChildren(CONTEXT);
        i = 0;
        while (i < configChildren.length) {
            String s;
            List views = EditPartProviderConfiguration.getObjectList((String)configChildren[i].getAttribute(VIEWS), objects, (IConfigurationElement)configElement);
            if (views != null) {
                this.requests.add(new ContextDescriptor(views));
            }
            if ((s = configChildren[i].getAttribute(PROVIDES_ROOT_EDITPART)) != null) {
                this.requests.add(new ContextDescriptor(Boolean.valueOf(s)));
            }
            ++i;
        }
    }

    public boolean supports(View view) {
        if (this.requests.isEmpty()) {
            return true;
        }
        for (ContextDescriptor request : this.requests) {
            if (!request.matches(view)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsRootEditPart() {
        if (this.requests.isEmpty()) {
            return true;
        }
        for (ContextDescriptor request : this.requests) {
            if (!request.providesRootEditPart()) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$0(Object object, List list) {
        return AbstractProviderConfiguration.objectMatches((Object)object, (List)list);
    }

    private static class ContextDescriptor {
        private List views;
        private boolean providesRootEditPart;

        public ContextDescriptor(List views) {
            this.views = views;
        }

        public ContextDescriptor(boolean providesRootEditPart) {
            this.providesRootEditPart = providesRootEditPart;
        }

        public boolean matches(View view) {
            return this.views != null && EditPartProviderConfiguration.access$0(view, this.views);
        }

        public boolean providesRootEditPart() {
            return this.providesRootEditPart;
        }
    }
}

