/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.internal.image;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidParameterException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.AbstractRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.Draw2dRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;

public final class ImageRenderedImage
extends AbstractRenderedImage {
    public ImageRenderedImage(byte[] buff, RenderedImageKey key) {
        super(buff, key);
    }

    protected Image renderImage() {
        try {
            ImageLoader loader = new ImageLoader();
            ByteArrayInputStream byteIS = new ByteArrayInputStream(this.getBuffer());
            ImageData[] imgData = loader.load((InputStream)byteIS);
            if (imgData == null) {
                throw new InvalidParameterException();
            }
            int origWidth = imgData[0].width;
            int origHeight = imgData[0].height;
            int bufferWidth = this.getKey().getWidth() == 0 ? origWidth : this.getKey().getWidth();
            int bufferHeight = this.getKey().getHeight() == 0 ? origHeight : this.getKey().getHeight();
            int newWidth = bufferWidth;
            int newHeight = bufferHeight;
            if (this.getKey().shouldMaintainAspectRatio()) {
                double origAspectRatio = (double)origHeight / (double)origWidth;
                if (origAspectRatio > (double)newHeight / (double)newWidth) {
                    newWidth = (int)Math.round((double)newHeight / origAspectRatio);
                } else {
                    newHeight = (int)Math.round((double)newWidth * origAspectRatio);
                }
                double scale = 1.0;
                if (newWidth > bufferWidth) {
                    scale = bufferWidth / newWidth;
                }
                if (newHeight > bufferHeight) {
                    scale = Math.min(scale, (double)bufferHeight / (double)newHeight);
                }
                newWidth = (int)((double)newWidth * scale);
                newHeight = (int)((double)newHeight * scale);
                Image origImage = new Image((Device)PlatformUI.getWorkbench().getDisplay(), imgData[0]);
                Image image = new Image((Device)PlatformUI.getWorkbench().getDisplay(), new Rectangle(0, 0, bufferWidth, bufferHeight));
                GC gc = new GC((Drawable)image);
                SWTGraphics swtG = new SWTGraphics(gc);
                swtG.drawImage(origImage, 0, 0, origWidth, origHeight, (bufferWidth - newWidth) / 2, (bufferHeight - newHeight) / 2, newWidth, newHeight);
                swtG.dispose();
                gc.dispose();
                origImage.dispose();
                return image;
            }
            ImageData scaledImgData = imgData[0].scaledTo(newWidth, newHeight);
            return new Image((Device)PlatformUI.getWorkbench().getDisplay(), scaledImgData);
        }
        catch (Exception e) {
            Log.error((Plugin)Draw2dRenderPlugin.getInstance(), (int)4, (String)e.toString(), (Throwable)e);
            return null;
        }
    }
}

