/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.properties.descriptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.gmf.runtime.common.ui.services.properties.PropertiesServiceAdapterFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class EObjectContainmentListPropertyValue
implements IPropertySource {
    protected static final PropertiesServiceAdapterFactory propertiesProvider = new PropertiesServiceAdapterFactory();
    protected EObjectContainmentEList target;
    protected Map descriptors;
    protected ILabelProvider labelProvider;

    private static ILabelProvider getDefaultLabelProvider() {
        return new LabelProvider(){

            public String getText(Object anObject) {
                return "";
            }

            public Image getImage(Object anObject) {
                return null;
            }
        };
    }

    public EObjectContainmentListPropertyValue(EObjectContainmentEList target, ILabelProvider labelProvider) {
        this.target = target;
        this.descriptors = new HashMap(target.size());
        this.labelProvider = labelProvider;
        for (EObject object : target) {
            this.createDescriptor(object);
        }
    }

    public EObjectContainmentListPropertyValue(EObjectContainmentEList target) {
        this(target, EObjectContainmentListPropertyValue.getDefaultLabelProvider());
    }

    protected void createDescriptor(EObject object) {
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)object, object.eClass().getName());
        descriptor.setLabelProvider(this.labelProvider);
        this.descriptors.put(object, descriptor);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList list = new ArrayList(this.descriptors.values());
        IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[list.size()];
        System.arraycopy(list.toArray(), 0, propertyDescriptors, 0, list.size());
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        return propertiesProvider.getPropertySource(id);
    }

    public boolean isPropertySet(Object id) {
        return this.descriptors.containsKey(id);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public EObjectContainmentEList getTarget() {
        return this.target;
    }
}

