/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandStatement
extends Statement {
    private final boolean foreach;
    private final Expression[] parameters;
    private final Expression separator;
    private final Expression target;
    private final Identifier definition;

    public ExpandStatement(int start, int end, int line, Identifier definition, Expression target, Expression separator, Expression[] parameters, boolean foreach) {
        super(start, end, line);
        this.definition = definition;
        this.target = target;
        this.separator = separator;
        this.parameters = parameters != null ? parameters : new Expression[]{};
        this.foreach = foreach;
    }

    public Identifier getDefinition() {
        return this.definition;
    }

    public boolean isForeach() {
        return this.foreach;
    }

    public Expression[] getParameters() {
        return this.parameters;
    }

    public Expression getSeparator() {
        return this.separator;
    }

    public Expression getTarget() {
        return this.target;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        void var4_12;
        void var4_5;
        EClassifier[] paramTypes = new EClassifier[this.getParameters().length];
        boolean bl = false;
        while (var4_5 < this.getParameters().length) {
            paramTypes[var4_5] = this.getParameters()[var4_5].analyze(ctx, issues);
            ++var4_5;
        }
        Object var4_6 = null;
        if (this.isForeach()) {
            EClassifier eClassifier = this.target.analyze(ctx, issues);
            if (!BuiltinMetaModel.isCollectionType(eClassifier)) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Collection type expected!", this.target));
                return;
            }
            System.err.println("Just curious (is it ever == false): " + BuiltinMetaModel.isParameterizedType(eClassifier));
            if (BuiltinMetaModel.isParameterizedType(eClassifier)) {
                EClassifier eClassifier2 = BuiltinMetaModel.getInnerType(eClassifier);
            } else {
                EDataType eDataType = EcorePackage.eINSTANCE.getEJavaObject();
            }
        } else {
            Variable var = ctx.getVariable("this");
            if (var == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "No implicite variable 'this' could be found!", this.target));
                return;
            }
            EClassifier eClassifier = (EClassifier)var.getValue();
            if (this.target != null) {
                EClassifier eClassifier3 = this.target.analyze(ctx, issues);
            }
        }
        if (var4_12 == null || Arrays.asList(paramTypes).contains(null)) {
            return;
        }
        XpandDefinition def = ctx.findDefinition(this.getDefinition().getValue(), (EClassifier)var4_12, paramTypes);
        if (def == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.DEFINITION_NOT_FOUND, "Couldn't find definition " + this.getDefinition().getValue() + this.getParamTypeString(paramTypes) + " for type " + var4_12.getName(), this));
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        Object[] params = new Object[this.getParameters().length];
        int i = 0;
        while (i < this.getParameters().length) {
            params[i] = this.getParameters()[i].evaluate(ctx);
            ++i;
        }
        EClassifier[] paramTypes = new EClassifier[params.length];
        int i2 = 0;
        while (i2 < params.length) {
            paramTypes[i2] = BuiltinMetaModel.getType(params[i2]);
            ++i2;
        }
        String defName = this.getDefinition().getValue();
        String sep = (String)(this.separator != null ? this.separator.evaluate(ctx) : null);
        Object targetObject = null;
        if (this.isForeach()) {
            targetObject = this.target.evaluate(ctx);
            if (!(targetObject instanceof Collection)) {
                throw new EvaluationException("Collection expected!", (SyntaxElement)this.target);
            }
            Collection col = (Collection)targetObject;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                Object targetObj = iter.next();
                this.invokeDefinition(defName, targetObj, params, paramTypes, ctx);
                if (sep == null || !iter.hasNext()) continue;
                ctx.getOutput().write(sep);
            }
        } else {
            if (this.target != null) {
                targetObject = this.target.evaluate(ctx);
            } else {
                Variable var = ctx.getVariable("this");
                targetObject = var.getValue();
            }
            if (targetObject != null) {
                this.invokeDefinition(defName, targetObject, params, paramTypes, ctx);
            }
        }
    }

    private void invokeDefinition(String defName, Object targetObj, Object[] params, EClassifier[] paramTypes, XpandExecutionContext ctx) {
        EClassifier t = BuiltinMetaModel.getType(targetObj);
        XpandDefinition def = ctx.findDefinition(defName, t, paramTypes);
        if (def == null) {
            throw new EvaluationException("No Definition '" + defName + this.getParamTypeString(paramTypes) + " for " + t.getName() + "' found!", (SyntaxElement)this);
        }
        ctx = (XpandExecutionContext)ctx.cloneWithoutVariables();
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("this", targetObj));
        int i = 0;
        while (i < def.getParams().length) {
            String name = def.getParams()[i].getName().getValue();
            Object val = params[i];
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(name, val));
            ++i;
        }
        if (def.getOwner() != null) {
            ctx = (XpandExecutionContext)ctx.cloneWithResource(def.getOwner());
        }
        def.evaluate(ctx);
    }

    private String getParamTypeString(EClassifier[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            EClassifier type = paramTypes[i];
            buff.append(type.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(", ");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    private String getParamString(Expression[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            Expression type = paramTypes[i];
            buff.append(type);
            if (i + 1 < paramTypes.length) {
                buff.append(", ");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    public String toString() {
        return "EXPAND " + this.definition + this.getParamString(this.getParameters()) + (this.target != null ? String.valueOf(this.isForeach() ? " FOREACH " : " FOR ") + this.target : "") + (this.separator != null ? " SEPARATOR " + this.separator : "");
    }
}

