/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.internal.l10n.CommonCoreMessages;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;

public class CompositeCommand
extends AbstractCommand
implements ICompositeCommand {
    private final List children;
    private boolean executed;
    static /* synthetic */ Class class$0;

    public CompositeCommand(String label) {
        this(label, null);
    }

    public CompositeCommand(String label, List children) {
        super(label, null);
        this.children = children != null ? new ArrayList(children) : new ArrayList(4);
    }

    public final boolean isEmpty() {
        return this.size() < 1;
    }

    protected List getChildren() {
        return this.children;
    }

    public int size() {
        return this.getChildren().size();
    }

    public void add(IUndoableOperation operation) {
        this.assertNotExecuted();
        if (!this.getChildren().contains(operation)) {
            this.getChildren().add(operation);
            this.didAdd(operation);
        }
    }

    private void didAdd(IUndoableOperation operation) {
        IUndoContext[] childContexts = operation.getContexts();
        int i = 0;
        while (i < childContexts.length) {
            if (!this.hasContext(childContexts[i])) {
                this.addContext(childContexts[i]);
            }
            ++i;
        }
    }

    public void remove(IUndoableOperation operation) {
        this.assertNotExecuted();
        if (this.getChildren().remove(operation)) {
            this.didRemove(operation);
        }
    }

    private void didRemove(IUndoableOperation operation) {
        IUndoContext[] childContexts = operation.getContexts();
        int i = 0;
        while (i < childContexts.length) {
            if (!this.anyChildHasContext(childContexts[i])) {
                this.removeContext(childContexts[i]);
            }
            ++i;
        }
    }

    private boolean anyChildHasContext(IUndoContext ctx) {
        boolean result = false;
        Iterator iter = this.iterator();
        while (!result && iter.hasNext()) {
            result = ((IUndoableOperation)iter.next()).hasContext(ctx);
        }
        return result;
    }

    public boolean canExecute() {
        boolean result = !this.isEmpty() && super.canExecute();
        Iterator iter = this.iterator();
        while (result && iter.hasNext()) {
            result = ((IUndoableOperation)iter.next()).canExecute();
        }
        return result;
    }

    public boolean canRedo() {
        boolean result = !this.isEmpty() && super.canRedo();
        Iterator iter = this.iterator();
        while (result && iter.hasNext()) {
            result = ((IUndoableOperation)iter.next()).canRedo();
        }
        return result;
    }

    public boolean canUndo() {
        boolean result = !this.isEmpty() && super.canUndo();
        Iterator iter = this.iterator();
        while (result && iter.hasNext()) {
            result = ((IUndoableOperation)iter.next()).canUndo();
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            IUndoableOperation nextOperation = (IUndoableOperation)iter.next();
            nextOperation.dispose();
        }
    }

    public final ICommand compose(IUndoableOperation operation) {
        if (operation != null) {
            this.add(operation);
        }
        return this;
    }

    public static ICommand compose(ICommand command, ICommand next) {
        if (command == null) {
            return next;
        }
        if (next != null) {
            return command.compose(next);
        }
        return command;
    }

    public ICommand reduce() {
        switch (this.size()) {
            case 1: {
                IUndoableOperation child = (IUndoableOperation)this.iterator().next();
                if (!(child instanceof ICommand)) break;
                ICommand cmd = ((ICommand)child).reduce();
                if ((cmd.getLabel() == null || cmd.getLabel().length() == 0) && this.getLabel() != null && this.getLabel().length() > 0) {
                    this.children.clear();
                    this.add(cmd);
                    break;
                }
                return cmd;
            }
        }
        return this;
    }

    protected List getReturnValues() {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object returnValue;
            ICommand command;
            CommandResult result;
            IUndoableOperation operation = (IUndoableOperation)i.next();
            if (!(operation instanceof ICommand) || (result = (command = (ICommand)operation).getCommandResult()) == null || (returnValue = result.getReturnValue()) == null) continue;
            if (this.getClass().isInstance(command)) {
                if (returnValue != null && returnValue instanceof Collection) {
                    returnValues.addAll((Collection)returnValue);
                    continue;
                }
                returnValues.add(returnValue);
                continue;
            }
            returnValues.add(returnValue);
        }
        return returnValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.size());
        progressMonitor.beginTask(this.getLabel(), this.size());
        try {
            ListIterator iter = this.listIterator();
            while (iter.hasNext()) {
                IUndoableOperation next = (IUndoableOperation)iter.next();
                try {
                    IStatus status = next.execute((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), info);
                    result.add(status);
                    int severity = status.getSeverity();
                    if (severity == 8 || severity == 4) {
                        Trace.trace(CommonCorePlugin.getDefault(), "Composite operation execution recovery: child command status is CANCEL or ERROR.");
                        iter.previous();
                        this.unwindFailedExecute(iter, info);
                        break;
                    }
                    if (progressMonitor.isCanceled()) {
                        Trace.trace(CommonCorePlugin.getDefault(), "Composite operation redo recovery: child command monitor is cancelled.");
                        CommandResult cancelResult = CommandResult.newCancelledCommandResult();
                        result.add(cancelResult.getStatus());
                        this.unwindFailedExecute(iter, info);
                        break;
                    }
                    progressMonitor.worked(1);
                    this.executed = true;
                }
                catch (ExecutionException e) {
                    iter.previous();
                    this.unwindFailedExecute(iter, info);
                    CommonCorePlugin commonCorePlugin = CommonCorePlugin.getDefault();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.core.command.CompositeCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Trace.throwing(commonCorePlugin, CommonCoreDebugOptions.EXCEPTIONS_THROWING, clazz, "execute", e);
                    throw e;
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
    }

    private void unwindFailedExecute(ListIterator iter, IAdaptable info) {
        while (iter.hasPrevious()) {
            IUndoableOperation prev = (IUndoableOperation)iter.previous();
            if (!prev.canUndo()) {
                Log.error(CommonCorePlugin.getDefault(), 20, CommonCoreMessages.bind((String)CommonCoreMessages.executeRecoveryFailed, (Object)CommonCoreMessages.cannotUndoExecuted));
                break;
            }
            try {
                prev.undo((IProgressMonitor)new NullProgressMonitor(), info);
            }
            catch (ExecutionException inner) {
                Log.error(CommonCorePlugin.getDefault(), 20, CommonCoreMessages.bind((String)CommonCoreMessages.executeRecoveryFailed, (Object)inner.getLocalizedMessage()));
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.size());
        progressMonitor.beginTask(this.getLabel(), this.size());
        try {
            ListIterator iter = this.listIterator();
            while (iter.hasNext()) {
                IUndoableOperation next = (IUndoableOperation)iter.next();
                try {
                    IStatus status = next.redo((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), info);
                    result.add(status);
                    int severity = status.getSeverity();
                    if (severity == 8 || severity == 4) {
                        Trace.trace(CommonCorePlugin.getDefault(), "Composite operation redo recovery: child command status is CANCEL or ERROR.");
                        iter.previous();
                        this.unwindFailedRedo(iter, info);
                        break;
                    }
                    if (progressMonitor.isCanceled()) {
                        Trace.trace(CommonCorePlugin.getDefault(), "Composite operation redo recovery: child command monitor is cancelled.");
                        CommandResult cancelResult = CommandResult.newCancelledCommandResult();
                        result.add(cancelResult.getStatus());
                        this.unwindFailedRedo(iter, info);
                        break;
                    }
                    progressMonitor.worked(1);
                    this.executed = true;
                }
                catch (ExecutionException e) {
                    iter.previous();
                    this.unwindFailedRedo(iter, info);
                    CommonCorePlugin commonCorePlugin = CommonCorePlugin.getDefault();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.core.command.CompositeCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Trace.throwing(commonCorePlugin, CommonCoreDebugOptions.EXCEPTIONS_THROWING, clazz, "redo", e);
                    throw e;
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
    }

    private void unwindFailedRedo(ListIterator iter, IAdaptable info) {
        while (iter.hasPrevious()) {
            IUndoableOperation prev = (IUndoableOperation)iter.previous();
            if (!prev.canUndo()) {
                Log.error(CommonCorePlugin.getDefault(), 22, CommonCoreMessages.bind((String)CommonCoreMessages.redoRecoveryFailed, (Object)CommonCoreMessages.cannotUndo));
                break;
            }
            try {
                prev.undo((IProgressMonitor)new NullProgressMonitor(), info);
            }
            catch (ExecutionException inner) {
                Log.error(CommonCorePlugin.getDefault(), 22, CommonCoreMessages.bind((String)CommonCoreMessages.redoRecoveryFailed, (Object)inner.getLocalizedMessage()));
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ArrayList<IStatus> result = new ArrayList<IStatus>(this.size());
        progressMonitor.beginTask(this.getLabel(), this.size());
        try {
            ListIterator iter = this.listIterator(this.size());
            while (iter.hasPrevious()) {
                IUndoableOperation prev = (IUndoableOperation)iter.previous();
                try {
                    IStatus status = prev.undo((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), info);
                    result.add(status);
                    int severity = status.getSeverity();
                    if (severity == 8 || severity == 4) {
                        Trace.trace(CommonCorePlugin.getDefault(), "Composite operation undo recovery: child command status is CANCEL or ERROR.");
                        iter.next();
                        this.unwindFailedUndo(iter, info);
                        break;
                    }
                    if (progressMonitor.isCanceled()) {
                        Trace.trace(CommonCorePlugin.getDefault(), "Composite operation undo recovery: child command monitor is cancelled.");
                        CommandResult cancelResult = CommandResult.newCancelledCommandResult();
                        result.add(cancelResult.getStatus());
                        this.unwindFailedUndo(iter, info);
                        break;
                    }
                    progressMonitor.worked(1);
                    this.executed = true;
                }
                catch (ExecutionException e) {
                    iter.next();
                    this.unwindFailedUndo(iter, info);
                    CommonCorePlugin commonCorePlugin = CommonCorePlugin.getDefault();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.core.command.CompositeCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Trace.throwing(commonCorePlugin, CommonCoreDebugOptions.EXCEPTIONS_THROWING, clazz, "undo", e);
                    throw e;
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return new CommandResult(this.aggregateStatuses(result), this.getReturnValues());
    }

    private void unwindFailedUndo(ListIterator iter, IAdaptable info) {
        while (iter.hasNext()) {
            IUndoableOperation next = (IUndoableOperation)iter.next();
            if (!next.canRedo()) {
                Log.error(CommonCorePlugin.getDefault(), 21, CommonCoreMessages.bind((String)CommonCoreMessages.undoRecoveryFailed, (Object)CommonCoreMessages.cannotRedo));
                break;
            }
            try {
                next.redo((IProgressMonitor)new NullProgressMonitor(), info);
            }
            catch (ExecutionException inner) {
                Log.error(CommonCorePlugin.getDefault(), 21, CommonCoreMessages.bind((String)CommonCoreMessages.undoRecoveryFailed, (Object)inner.getLocalizedMessage()));
                break;
            }
        }
    }

    protected IStatus aggregateStatuses(List statuses) {
        IStatus result;
        if (statuses.isEmpty()) {
            result = Status.OK_STATUS;
        } else if (statuses.size() == 1) {
            result = (IStatus)statuses.get(0);
        } else {
            IStatus[] statusArray = statuses.toArray(new IStatus[statuses.size()]);
            IStatus worst = statusArray[0];
            int i = 1;
            while (i < statusArray.length) {
                if (statusArray[i].getSeverity() > worst.getSeverity()) {
                    worst = statusArray[i];
                }
                ++i;
            }
            result = new MultiStatus(worst.getPlugin(), worst.getCode(), statusArray, worst.getMessage(), null);
        }
        return result;
    }

    protected final boolean isExecuted() {
        return this.executed;
    }

    protected final void assertNotExecuted() {
        if (this.isExecuted()) {
            IllegalStateException exc = new IllegalStateException("Operation already executed");
            CommonCorePlugin commonCorePlugin = CommonCorePlugin.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.core.command.CompositeCommand");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing(commonCorePlugin, CommonCoreDebugOptions.EXCEPTIONS_THROWING, clazz, "assertNotExecuted", exc);
            throw exc;
        }
    }

    public List getAffectedFiles() {
        HashSet result = new HashSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            List nextAffected;
            IUndoableOperation nextOperation = (IUndoableOperation)i.next();
            if (!(nextOperation instanceof ICommand) || (nextAffected = ((ICommand)nextOperation).getAffectedFiles()) == null) continue;
            result.addAll(nextAffected);
        }
        return new ArrayList(result);
    }

    public Iterator iterator() {
        return new ChildIterator();
    }

    public ListIterator listIterator() {
        return new ChildListIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new ChildListIterator(index);
    }

    private class ChildIterator
    implements Iterator {
        protected Object last;
        protected final ListIterator iter;

        ChildIterator() {
            this(0);
        }

        ChildIterator(int index) {
            this.iter = CompositeCommand.this.getChildren().listIterator(index);
        }

        public void remove() {
            CompositeCommand.this.assertNotExecuted();
            this.iter.remove();
            CompositeCommand.this.didRemove((IUndoableOperation)this.last);
            this.last = null;
        }

        public Object next() {
            this.last = this.iter.next();
            return this.last;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }
    }

    private class ChildListIterator
    extends ChildIterator
    implements ListIterator {
        ChildListIterator(int index) {
            super(index);
        }

        public void add(Object o) {
            CompositeCommand.this.assertNotExecuted();
            if (!CompositeCommand.this.getChildren().contains(o)) {
                this.iter.add(o);
                CompositeCommand.this.didAdd((IUndoableOperation)o);
            }
        }

        public void set(Object o) {
            CompositeCommand.this.assertNotExecuted();
            if (!CompositeCommand.this.getChildren().contains(o)) {
                CompositeCommand.this.didRemove((IUndoableOperation)this.last);
                this.iter.set(o);
                this.last = o;
                CompositeCommand.this.didAdd((IUndoableOperation)o);
            }
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            this.last = this.iter.previous();
            return this.last;
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }
    }
}

