/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.internal.dialogs;

import org.eclipse.gmf.runtime.common.ui.dialogs.SelectableElement;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectedType;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public abstract class SelectableElementTreeSelectionChangedAndMouseAndKeyListener
implements ISelectionChangedListener,
MouseListener,
KeyListener {
    private TreeViewer viewer;
    private static final char KEYBOARD_SPACE_ASCII_CODE = ' ';
    protected boolean mouseOrKeyPressed = false;
    protected SelectionChangedEvent selectionChangedEvent = null;
    protected boolean isLinux = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.internal.dialogs.SelectableElementTreeSelectionChangedAndMouseAndKeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SelectableElementTreeSelectionChangedAndMouseAndKeyListener(TreeViewer aViewer) {
        this.viewer = aViewer;
        if (System.getProperty("os.name").toUpperCase().startsWith("LIN")) {
            this.isLinux = true;
        }
    }

    private void setSelectedTypeForParent(SelectableElement element) {
        SelectableElement parent = element.getParent();
        if (parent != null) {
            if (SelectableElement.doAllChildrenHaveSelectedType(parent, SelectedType.UNSELECTED)) {
                parent.setSelectedType(SelectedType.UNSELECTED);
            } else if (SelectableElement.doAllChildrenHaveSelectedType(parent, SelectedType.SELECTED)) {
                parent.setSelectedType(SelectedType.SELECTED);
            } else {
                parent.setSelectedType(SelectedType.LEAVE);
            }
            this.setSelectedTypeForParent(parent);
        }
    }

    private void setSelectedTypeForChildren(SelectableElement parent) {
        int i = 0;
        while (i < parent.getNumberOfChildren()) {
            parent.getChild(i).setSelectedType(parent.getSelectedType());
            this.setSelectedTypeForChildren(parent.getChild(i));
            ++i;
        }
    }

    protected abstract void switchCheckType(SelectableElement var1);

    public void handleSelectionChanged() {
        if (this.selectionChangedEvent != null && this.mouseOrKeyPressed) {
            StructuredSelection s = (StructuredSelection)this.selectionChangedEvent.getSelection();
            s.getFirstElement();
            if (!$assertionsDisabled && !(s.getFirstElement() instanceof SelectableElement)) {
                throw new AssertionError();
            }
            SelectableElement element = (SelectableElement)s.getFirstElement();
            this.switchCheckType(element);
            this.setSelectedTypeForChildren(element);
            this.setSelectedTypeForParent(element);
            this.viewer.refresh();
            this.selectionChangedEvent = null;
            this.mouseOrKeyPressed = false;
        }
    }

    public void mouseDoubleClick(MouseEvent arg) {
    }

    public void mouseDown(MouseEvent arg) {
        this.mouseOrKeyPressed = true;
        this.handleSelectionChanged();
    }

    public void mouseUp(MouseEvent arg) {
    }

    public void keyPressed(KeyEvent arg) {
        if (arg.character == ' ') {
            this.mouseOrKeyPressed = true;
            this.handleSelectionChanged();
        }
    }

    public void keyReleased(KeyEvent arg) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isLinux && !this.mouseOrKeyPressed) {
            return;
        }
        if (event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).getFirstElement() instanceof SelectableElement) {
            this.selectionChangedEvent = event;
            this.handleSelectionChanged();
        } else {
            this.selectionChangedEvent = null;
        }
    }
}

