/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class DiagramDropTargetListener
extends AbstractTransferDropTargetListener {
    static /* synthetic */ Class class$0;

    public DiagramDropTargetListener(EditPartViewer viewer) {
        super(viewer);
    }

    public DiagramDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    protected Request createTargetRequest() {
        DropObjectsRequest request = new DropObjectsRequest();
        request.setObjects(this.getObjectsBeingDropped());
        request.setAllowedDetail(this.getCurrentEvent().operations);
        return request;
    }

    protected final DropObjectsRequest getDropObjectsRequest() {
        return (DropObjectsRequest)this.getTargetRequest();
    }

    protected abstract List getObjectsBeingDropped();

    public void dragEnter(DropTargetEvent event) {
        super.dragEnter(event);
        this.handleDragEnter();
    }

    protected void handleDragEnter() {
        this.handleDragOver();
    }

    protected void handleDragOperationChanged() {
        super.handleDragOperationChanged();
        this.getCurrentEvent().detail = this.getDropObjectsRequest().getRequiredDetail();
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().detail = this.getDropObjectsRequest().getRequiredDetail();
        this.getCurrentEvent().feedback = 24;
    }

    protected void handleDrop() {
        this.getViewer().setCursor(Cursors.WAIT);
        super.handleDrop();
        this.getViewer().setCursor(null);
        this.selectAddedViews();
    }

    private void selectAddedViews() {
        Object result = this.getDropObjectsRequest().getResult();
        if (result == null || !(result instanceof Collection)) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        Iterator views = ((Collection)result).iterator();
        while (views.hasNext()) {
            EditPart editPart;
            Object view = views.next();
            if (!(view instanceof IAdaptable)) continue;
            Map map = viewer.getEditPartRegistry();
            IAdaptable iAdaptable = (IAdaptable)view;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.gmf.runtime.notation.View");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((editPart = (EditPart)map.get(iAdaptable.getAdapter((Class)clazz))) == null) continue;
            editParts.add(editPart);
        }
        if (!editParts.isEmpty()) {
            viewer.getControl().forceFocus();
            this.getViewer().flush();
            viewer.setSelection((ISelection)new StructuredSelection(editParts));
        }
    }

    protected void updateTargetRequest() {
        DropObjectsRequest request = this.getDropObjectsRequest();
        request.setLocation(this.getDropLocation());
    }

    public boolean isEnabled(DropTargetEvent event) {
        if (super.isEnabled(event)) {
            boolean result = this.calculateTargetEditPart() != null;
            return result;
        }
        return false;
    }

    protected void updateTargetEditPart() {
        this.setTargetEditPart(this.calculateTargetEditPart());
    }

    private EditPart calculateTargetEditPart() {
        this.updateTargetRequest();
        EditPart ep = this.getViewer().findObjectAtExcluding(this.getDropLocation(), this.getExclusionSet(), new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                Command command = editpart.getCommand(DiagramDropTargetListener.this.getTargetRequest());
                return command != null && command.canExecute();
            }
        });
        if (ep != null) {
            Command command = ep.getCommand(this.getTargetRequest());
            return command != null && command.canExecute() ? ep : null;
        }
        return ep;
    }
}

