/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.AbstractImageEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.DiagramCreator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractImageEditPartTests
extends TestCase {
    private Node node;
    private TransactionalEditingDomain editingDomain;

    public Node getNode() {
        return this.node;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.editingDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
        final Diagram dgrm = DiagramCreator.createEmptyDiagram(this.getPreferenceHint(), this.editingDomain);
        AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Resource resource = AbstractImageEditPartTests.this.editingDomain.createResource("null:/org.eclipse.gmf.tests.runtime.diagram.ui");
                resource.getContents().add((Object)dgrm);
                return Status.OK_STATUS;
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractImageEditPartTests.assertFalse((boolean)false);
        }
        this.node = this.createNode(dgrm);
    }

    protected PreferencesHint getPreferenceHint() {
        return PreferencesHint.USE_DEFAULTS;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected Node createNode(final Diagram diagram) {
        final ArrayList list = new ArrayList(1);
        AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Node note1 = ViewService.createNode((View)diagram, (String)ViewType.NOTE, (PreferencesHint)AbstractImageEditPartTests.this.getPreferenceHint());
                AbstractImageEditPartTests.assertNotNull((String)"Note1 creation failed", (Object)note1);
                list.add(note1);
                return Status.OK_STATUS;
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractImageEditPartTests.assertFalse((boolean)false);
        }
        return (Node)list.get(0);
    }

    public abstract List getFixtures();

    public void test_regenerateImageFromSource() {
        List fixtures = this.getFixtures();
        ListIterator li = fixtures.listIterator();
        int testno = 1;
        while (li.hasNext()) {
            Object obj = li.next();
            if (!(obj instanceof AbstractImageEditPart)) continue;
            AbstractImageEditPart fixture = (AbstractImageEditPart)obj;
            RenderedImage renderedImage = fixture.regenerateImageFromSource();
            this.verifyRenderedImage(renderedImage, testno++);
        }
    }

    protected void verifyRenderedImage(RenderedImage renderedImage, int testno) {
        AbstractImageEditPartTests.assertTrue((String)("renderedImage is null in testno " + new Integer(testno).toString()), (renderedImage != null ? 1 : 0) != 0);
        Image swtImage = renderedImage.getSWTImage();
        AbstractImageEditPartTests.assertTrue((String)("swtImage is null in testno " + new Integer(testno).toString()), (swtImage != null ? 1 : 0) != 0);
        Rectangle rect = swtImage.getBounds();
        AbstractImageEditPartTests.assertTrue((String)("swtImage is not correct size in testno " + new Integer(testno).toString()), (rect.width > 10 && rect.height > 10 ? 1 : 0) != 0);
    }

    public void test_getRenderedImage() {
        List fixtures = this.getFixtures();
        ListIterator li = fixtures.listIterator();
        int testno = 1;
        while (li.hasNext()) {
            Object obj = li.next();
            if (!(obj instanceof AbstractImageEditPart)) continue;
            AbstractImageEditPart fixture = (AbstractImageEditPart)obj;
            RenderedImage renderedImage = fixture.getRenderedImage();
            this.verifyRenderedImage(renderedImage, testno++);
        }
    }
}

