/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LabeledContainer;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.CanvasProcessor;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryMirrorProcessor;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;
import org.eclipse.gmf.tests.gen.GenericFigureCheck;

public class StandalonePluginConverterTest
extends FigureCodegenTestBase {
    private static final String CUSTOM_FIGURES_PACKAGE = "custom.figures.pakkage";
    static /* synthetic */ Class class$0;

    public StandalonePluginConverterTest(String name) {
        super(name);
    }

    public void testEachGeneratedClassUsesItsOwnImportAssistant() {
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        gallery.setImplementationBundle("org.eclipse.draw2d");
        CustomFigure usesLayeredPane = GMFGraphFactory.eINSTANCE.createCustomFigure();
        usesLayeredPane.setName("RequiersImportForDraw2dLayeredPane");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.LayeredPane");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        usesLayeredPane.setQualifiedClassName(clazz.getName());
        Rectangle layeredPaneItself = GMFGraphFactory.eINSTANCE.createRectangle();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.draw2d.LayeredPane");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        layeredPaneItself.setName(CodeGenUtil.getSimpleClassName((String)clazz2.getName()));
        Figure[] originals = new Figure[]{usesLayeredPane, layeredPaneItself};
        gallery.getFigures().addAll(Arrays.asList(originals));
        String standalonePlugin = "org.eclipse.gmf.tests.generated.custom.figures.importsTest.t" + System.currentTimeMillis();
        StandaloneGenerator.ConfigImpl config = new StandaloneGenerator.ConfigImpl(standalonePlugin, CUSTOM_FIGURES_PACKAGE, false);
        FigureCodegenTestBase.GeneratedClassData[] genResults = this.generateAndCompile((StandaloneGenerator.Config)config, gallery);
        StandalonePluginConverterTest.assertEquals((int)gallery.getFigures().size(), (int)genResults.length);
        int i = 0;
        while (i < genResults.length) {
            FigureCodegenTestBase.GeneratedClassData next = genResults[i];
            StandalonePluginConverterTest.assertNotNull((Object)CHECK_CAN_CREATE_INSTANCE.instantiateFigure(next.getLoadedClass()));
            ++i;
        }
    }

    public void testStandaloneGalleryConverter() throws Exception {
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        Figure[] originals = new Figure[]{this.figure1(), this.figure2(), this.figure3()};
        gallery.getFigures().addAll(Arrays.asList(originals));
        String standalonePlugin = "org.eclipse.gmf.tests.generated.custom.figures.t" + System.currentTimeMillis();
        StandaloneGenerator.ConfigImpl config = new StandaloneGenerator.ConfigImpl(standalonePlugin, CUSTOM_FIGURES_PACKAGE, false);
        GalleryMirrorProcessor processor = new GalleryMirrorProcessor(new FigureGallery[]{gallery});
        this.generateStandalone((StandaloneGenerator.Processor)processor, (StandaloneGenerator.Config)config);
        GalleryMirrorProcessor.GenerationInfo info = processor.getGenerationInfo();
        int i = 0;
        while (i < originals.length) {
            StandalonePluginConverterTest.assertNotNull((Object)info.getGeneratedClassFQN(originals[i]));
            ++i;
        }
        FigureGallery mirroredGallery = processor.convertFigureGallery();
        StandalonePluginConverterTest.assertEquals((String)standalonePlugin, (String)mirroredGallery.getImplementationBundle());
        StandalonePluginConverterTest.assertEquals((int)3, (int)mirroredGallery.getFigures().size());
        Iterator mirroredFigures = mirroredGallery.getFigures().iterator();
        while (mirroredFigures.hasNext()) {
            Figure next = (Figure)mirroredFigures.next();
            StandalonePluginConverterTest.assertTrue((boolean)(next instanceof CustomFigure));
            CustomFigure nextCustom = (CustomFigure)next;
            StandalonePluginConverterTest.assertNotNull((Object)nextCustom.getName());
            StandalonePluginConverterTest.assertEquals((String)standalonePlugin, (String)nextCustom.getBundleName());
            StandalonePluginConverterTest.assertTrue((boolean)nextCustom.getQualifiedClassName().startsWith("custom.figures.pakkage."));
        }
        this.installPlugin(standalonePlugin);
        FigureCodegenTestBase.GeneratedClassData[] mirroredClasses = this.generateAndCompile(this.getGMFGraphGeneratorConfig(), mirroredGallery);
        int i2 = 0;
        while (i2 < originals.length) {
            Figure nextOriginal = originals[i2];
            Class nextClass = StandalonePluginConverterTest.searchForFigureName(mirroredClasses, nextOriginal.getName());
            StandalonePluginConverterTest.assertNotNull((String)("Missed class for : " + nextOriginal.getName()), (Object)nextClass);
            GenericFigureCheck nextCheck = new GenericFigureCheck(nextOriginal);
            ((FigureCodegenTestBase.FigureCheck)nextCheck).checkFigure(nextCheck.instantiateFigure(nextClass));
            ++i2;
        }
    }

    public void testMirroredDiagramElements() {
        Canvas canvas = GMFGraphFactory.eINSTANCE.createCanvas();
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        canvas.getFigures().add((Object)gallery);
        Label label = GMFGraphFactory.eINSTANCE.createLabel();
        label.setName("GraphLabel");
        PolylineConnection connection = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        connection.setName("GraphConnection");
        Rectangle rectangle = GMFGraphFactory.eINSTANCE.createRectangle();
        rectangle.setName("GraphRectangle");
        LabeledContainer labeledContainer = GMFGraphFactory.eINSTANCE.createLabeledContainer();
        labeledContainer.setName("GraphLabeledContainer");
        gallery.getFigures().addAll(Arrays.asList(label, connection, rectangle, labeledContainer));
        Node node = GMFGraphFactory.eINSTANCE.createNode();
        node.setName("DiagramNode");
        node.setFigure((FigureHandle)rectangle);
        DiagramLabel diagramLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        diagramLabel.setName("DiagramLabel");
        diagramLabel.setFigure((FigureHandle)label);
        Connection diagramConnection = GMFGraphFactory.eINSTANCE.createConnection();
        diagramConnection.setName("DiagramConnection");
        diagramConnection.setFigure((FigureHandle)connection);
        Compartment compartment = GMFGraphFactory.eINSTANCE.createCompartment();
        compartment.setName("DiagramCompartment");
        compartment.setNeedsTitle(!compartment.isNeedsTitle());
        compartment.setCollapsible(!compartment.isCollapsible());
        compartment.setFigure((FigureHandle)labeledContainer);
        canvas.getNodes().add((Object)node);
        canvas.getLabels().add((Object)diagramLabel);
        canvas.getConnections().add((Object)diagramConnection);
        canvas.getCompartments().add((Object)compartment);
        Canvas mirroredCanvas = this.mirror(canvas);
        Checker checker = new Checker();
        checker.check((List)canvas.getNodes(), (List)mirroredCanvas.getNodes());
        checker.check((List)canvas.getCompartments(), (List)mirroredCanvas.getCompartments());
        checker.check((List)canvas.getConnections(), (List)mirroredCanvas.getConnections());
        checker.check((List)canvas.getLabels(), (List)mirroredCanvas.getLabels());
    }

    public void testInnerFigureConversion() {
        Rectangle topFigure = GMFGraphFactory.eINSTANCE.createRectangle();
        topFigure.setName("TopRect");
        CustomFigure customLabel = GMFGraphFactory.eINSTANCE.createCustomFigure();
        customLabel.setQualifiedClassName("org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel");
        customLabel.setName("CustomLabel");
        Label ordinaryLabel = GMFGraphFactory.eINSTANCE.createLabel();
        ordinaryLabel.setText("ordinaryLabel value");
        ordinaryLabel.setName("OrdinaryLabel");
        topFigure.getChildren().add((Object)customLabel);
        topFigure.getChildren().add((Object)ordinaryLabel);
        FigureGallery fg = GMFGraphFactory.eINSTANCE.createFigureGallery();
        fg.setName("a1");
        fg.getFigures().add((Object)topFigure);
        Node node = GMFGraphFactory.eINSTANCE.createNode();
        node.setName("Node");
        node.setFigure((FigureHandle)topFigure);
        DiagramLabel l1 = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        l1.setName("l1");
        l1.setFigure((FigureHandle)customLabel);
        DiagramLabel l2 = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        l2.setName("l2");
        l2.setFigure((FigureHandle)ordinaryLabel);
        Canvas canvas = GMFGraphFactory.eINSTANCE.createCanvas();
        canvas.setName("canvas");
        canvas.getFigures().add((Object)fg);
        canvas.getNodes().add((Object)node);
        canvas.getLabels().add((Object)l1);
        canvas.getLabels().add((Object)l2);
        Canvas mirroredCanvas = this.mirror(canvas);
        Checker checker = new Checker();
        checker.check((List)canvas.getNodes(), (List)mirroredCanvas.getNodes());
        checker.check((List)canvas.getLabels(), (List)mirroredCanvas.getLabels());
    }

    private Canvas mirror(Canvas canvas) {
        String standalonePlugin = "org.eclipse.gmf.tests.generated.mirrored.diagram.elements.t" + System.currentTimeMillis();
        StandaloneGenerator.ConfigImpl config = new StandaloneGenerator.ConfigImpl(standalonePlugin, CUSTOM_FIGURES_PACKAGE, false);
        CanvasProcessor processor = new CanvasProcessor(canvas);
        this.generateStandalone((StandaloneGenerator.Processor)processor, (StandaloneGenerator.Config)config);
        return processor.getOutcome();
    }

    private void generateStandalone(StandaloneGenerator.Processor p, StandaloneGenerator.Config config) {
        StandaloneGenerator generator = new StandaloneGenerator(p, config, (FigureQualifiedNameSwitch)new RuntimeFQNSwitch());
        generator.run();
        StandalonePluginConverterTest.assertTrue((generator.getRunStatus().getSeverity() < 4 ? 1 : 0) != 0);
    }

    private static Class searchForFigureName(FigureCodegenTestBase.GeneratedClassData[] classes, String expectedName) {
        Class result = null;
        int i = 0;
        while (result == null && i < classes.length) {
            if (expectedName.equals(classes[i].getFigureDef().getName())) {
                result = classes[i].getLoadedClass();
            }
            ++i;
        }
        return result;
    }

    private static class Checker {
        public void check(List originalsByType, List mirroredByType) {
            StandalonePluginConverterTest.assertEquals((int)originalsByType.size(), (int)mirroredByType.size());
            Iterator allOriginals = originalsByType.iterator();
            Iterator allMirrored = mirroredByType.iterator();
            while (allOriginals.hasNext() || allMirrored.hasNext()) {
                DiagramElement nextOriginal = (DiagramElement)allOriginals.next();
                DiagramElement nextMirrored = (DiagramElement)allMirrored.next();
                this.check(nextOriginal, nextMirrored);
            }
            StandalonePluginConverterTest.assertFalse((boolean)allOriginals.hasNext());
            StandalonePluginConverterTest.assertFalse((boolean)allMirrored.hasNext());
        }

        public void check(DiagramElement original, DiagramElement mirrored) {
            StandalonePluginConverterTest.assertEquals((int)original.eClass().getClassifierID(), (int)mirrored.eClass().getClassifierID());
            StandalonePluginConverterTest.assertEquals((String)original.getName(), (String)mirrored.getName());
            StandalonePluginConverterTest.assertTrue((String)"we know only how to handle figures", (boolean)(original.getFigure() instanceof Figure));
            String expectedFQN = Checker.composeFQN((Figure)original.getFigure());
            FigureHandle actualFigure = mirrored.getFigure();
            StandalonePluginConverterTest.assertNotNull((Object)actualFigure);
            StandalonePluginConverterTest.assertTrue((String)actualFigure.getClass().getName(), (actualFigure instanceof CustomFigure || actualFigure instanceof FigureAccessor ? 1 : 0) != 0);
            if (actualFigure instanceof CustomFigure) {
                CustomFigure actual = (CustomFigure)actualFigure;
                StandalonePluginConverterTest.assertEquals((String)expectedFQN, (String)actual.getQualifiedClassName());
                if (original instanceof Compartment) {
                    Compartment originalCompartment = (Compartment)original;
                    Compartment mirroredCompartment = (Compartment)mirrored;
                    StandalonePluginConverterTest.assertEquals((boolean)originalCompartment.isCollapsible(), (boolean)mirroredCompartment.isCollapsible());
                    StandalonePluginConverterTest.assertEquals((boolean)originalCompartment.isNeedsTitle(), (boolean)mirroredCompartment.isNeedsTitle());
                }
            } else {
                FigureAccessor accessor = (FigureAccessor)actualFigure;
                StandalonePluginConverterTest.assertNotNull((Object)accessor.getAccessor());
            }
        }

        private static String composeFQN(Figure figure) {
            return "custom.figures.pakkage." + CodeGenUtil.validJavaIdentifier((String)figure.getName());
        }
    }
}

