/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.BorderItemContainerFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class BorderedNodeFigure
extends NodeFigure
implements IExpandableFigure {
    private BorderItemContainerFigure borderItemContainer;
    private IFigure mainFigure;
    private Rectangle extendedBounds = new Rectangle();

    public BorderedNodeFigure(IFigure mainFigure) {
        this.setOpaque(false);
        this.setBorder(null);
        this.setLayoutManager(null);
        this.mainFigure = mainFigure;
        this.add(this.getMainFigure());
        this.add(this.getBorderItemContainer());
        this.setBounds(this.getMainFigure().getBounds().getCopy());
        this.getBorderItemContainer().setBounds(new Rectangle(0, 0, 1, 1));
    }

    public IFigure getBorderItemContainer() {
        if (this.borderItemContainer == null) {
            this.borderItemContainer = new BorderItemContainerFigure();
            this.borderItemContainer.setLayoutManager((LayoutManager)new DelegatingLayout());
            this.borderItemContainer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
            this.borderItemContainer.setVisible(true);
        }
        return this.borderItemContainer;
    }

    public IFigure getMainFigure() {
        return this.mainFigure;
    }

    public Rectangle getClientArea(Rectangle rect) {
        if (this.getMainFigure() != null) {
            return this.getMainFigure().getClientArea(rect);
        }
        return super.getClientArea(rect);
    }

    public Rectangle getHandleBounds() {
        if (this.getMainFigure() instanceof NodeFigure) {
            return ((NodeFigure)this.getMainFigure()).getHandleBounds().getCopy();
        }
        return this.getMainFigure().getBounds().getCopy();
    }

    protected void layout() {
        if (!this.getBounds().equals((Object)this.getMainFigure().getBounds())) {
            this.getMainFigure().setBounds(this.getBounds().getCopy());
            this.getBorderItemContainer().invalidateTree();
            this.erase();
        }
    }

    public boolean containsPoint(int x, int y) {
        if (this.borderItemContainer.containsPoint(x, y)) {
            return true;
        }
        return super.containsPoint(x, y);
    }

    protected void primTranslate(int dx, int dy) {
        super.primTranslate(dx, dy);
        this.erase();
    }

    public void erase() {
        super.erase();
        if (this.borderItemContainer != null) {
            this.borderItemContainer.erase();
        }
    }

    public void repaint() {
        super.repaint();
        if (this.borderItemContainer != null) {
            this.borderItemContainer.repaint();
        }
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (search.prune((IFigure)this)) {
            return null;
        }
        IFigure result = this.borderItemContainer.findFigureAt(x, y, search);
        if (result != null) {
            return result;
        }
        return this.getMainFigure().findFigureAt(x, y, search);
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        IFigure borderItemFigure = this.borderItemContainer.findMouseEventTargetAt(x, y);
        if (borderItemFigure != null) {
            return borderItemFigure;
        }
        return super.findMouseEventTargetAt(x, y);
    }

    public boolean intersects(Rectangle rect) {
        if (this.getExtendedBounds().intersects(rect)) {
            return true;
        }
        return super.intersects(rect);
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        return this.getMainFigure().getMinimumSize(wHint, hHint);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.getMainFigure().getPreferredSize(wHint, hHint);
    }

    public IFigure getToolTip() {
        return this.getMainFigure().getToolTip();
    }

    public void setToolTip(IFigure f) {
        this.getMainFigure().setToolTip(f);
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        if (this.getMainFigure() instanceof NodeFigure) {
            return ((NodeFigure)this.getMainFigure()).getSourceConnectionAnchorAt(p);
        }
        return super.getSourceConnectionAnchorAt(p);
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        if (this.getMainFigure() instanceof NodeFigure) {
            return ((NodeFigure)this.getMainFigure()).getTargetConnectionAnchorAt(p);
        }
        return super.getTargetConnectionAnchorAt(p);
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        if (this.getMainFigure() instanceof NodeFigure) {
            return ((NodeFigure)this.getMainFigure()).getConnectionAnchor(terminal);
        }
        return super.getConnectionAnchor(terminal);
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        if (this.getMainFigure() instanceof NodeFigure) {
            return ((NodeFigure)this.getMainFigure()).getConnectionAnchorTerminal(c);
        }
        return super.getConnectionAnchorTerminal(c);
    }

    public static IFigure getParentFigure(IFigure target) {
        IFigure parent = target.getParent();
        if (parent instanceof BorderItemContainerFigure) {
            return ((BorderedNodeFigure)parent.getParent()).getMainFigure();
        }
        return parent;
    }

    public Rectangle getExtendedBounds() {
        if (this.extendedBounds == null) {
            Rectangle rect = this.getBounds().getCopy();
            if (this.borderItemContainer != null) {
                rect = rect.union(this.borderItemContainer.getExtendedBounds());
            }
            this.extendedBounds = rect;
        }
        return this.extendedBounds;
    }

    public void invalidate() {
        this.extendedBounds = null;
        super.invalidate();
    }

    public void validate() {
        this.extendedBounds = null;
        super.validate();
    }

    protected void fireFigureMoved() {
        super.fireFigureMoved();
        this.extendedBounds = null;
    }
}

