/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CanonicalEditPolicy
extends AbstractEditPolicy
implements NotificationListener {
    static Map<EObject, Set<CanonicalEditPolicy>> _registry = new WeakHashMap<EObject, Set<CanonicalEditPolicy>>();
    private static final String SEMANTIC_FILTER_ID = "SemanticFilterID";
    private boolean _enabled = true;
    private boolean _deferredRefresh = false;
    private Map<String, Object[]> _listenerFilters;

    private void RegisterEditPolicy() {
        EObject semanticHost = this.getSemanticHost();
        Set<CanonicalEditPolicy> set = _registry.get(semanticHost);
        if (set == null) {
            set = new HashSet<CanonicalEditPolicy>();
            _registry.put(semanticHost, set);
        }
        set.add(this);
    }

    private void UnregisterEditPolicy() {
        EObject semanticHost = null;
        Set<CanonicalEditPolicy> set = _registry.get(null);
        if (set != null) {
            set.remove((Object)this);
            if (set.isEmpty()) {
                _registry.remove(semanticHost);
            }
        }
        for (EObject key : _registry.keySet()) {
            if (!_registry.get(key).contains((Object)this)) continue;
            semanticHost = key;
            break;
        }
        set = _registry.get(semanticHost);
        if (set != null) {
            set.remove((Object)this);
            if (set.isEmpty()) {
                _registry.remove(semanticHost);
            }
        }
    }

    public static List<CanonicalEditPolicy> getRegisteredEditPolicies(EObject element) {
        Collection policiesWithNullSemanticElements;
        ArrayList policies = new ArrayList();
        Collection policiesWithSemanticElements = _registry.get(element);
        if (policiesWithSemanticElements != null) {
            policies.addAll(policiesWithSemanticElements);
        }
        if ((policiesWithNullSemanticElements = (Collection)_registry.get(null)) != null) {
            policies.addAll(policiesWithNullSemanticElements);
        }
        return Collections.unmodifiableList(policies);
    }

    public static List<CanonicalEditPolicy> getRegisteredEditPolicies(EObject element, Class clazz) {
        ArrayList<CanonicalEditPolicy> registeredPolicies = new ArrayList<CanonicalEditPolicy>();
        for (CanonicalEditPolicy cep : CanonicalEditPolicy.getRegisteredEditPolicies(element)) {
            if (!cep.isEnabled() || !clazz.isInstance((Object)cep)) continue;
            registeredPolicies.add(cep);
        }
        return Collections.unmodifiableList(registeredPolicies);
    }

    public void setHost(EditPart host) {
        if (!(host instanceof IGraphicalEditPart)) {
            throw new IllegalArgumentException();
        }
        super.setHost(host);
    }

    protected final IGraphicalEditPart host() {
        return (IGraphicalEditPart)this.getHost();
    }

    protected abstract List getSemanticChildrenList();

    protected String getDefaultFactoryHint() {
        return ((View)this.host().getModel()).getType();
    }

    protected String getFactoryHint(IAdaptable elementAdapter, String defaultHint) {
        String fh = this.getFactoryHint(elementAdapter);
        return fh == null ? defaultHint : fh;
    }

    protected String getFactoryHint(IAdaptable elementAdapter) {
        return null;
    }

    protected final boolean deleteViews(Iterator<View> views) {
        boolean doDelete;
        if (!this.isEnabled()) {
            return false;
        }
        CompoundCommand cc = new CompoundCommand(DiagramUIMessages.DeleteCommand_Label);
        while (views.hasNext()) {
            View view = views.next();
            if (!this.shouldDeleteView(view)) continue;
            cc.add(this.getDeleteViewCommand(view));
        }
        boolean bl = doDelete = !cc.isEmpty() && cc.canExecute();
        if (doDelete) {
            this.executeCommand((Command)cc);
        }
        return doDelete;
    }

    protected Command getDeleteViewCommand(View view) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new DeleteCommand(editingDomain, view));
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected List<View> getViewReferers(EObject element) {
        ArrayList<View> views = new ArrayList<View>();
        if (element != null) {
            EReference[] features = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
            views.addAll(EMFCoreUtil.getReferencers((EObject)element, (EReference[])features));
        }
        return views;
    }

    protected int getViewIndexFor(EObject semanticChild) {
        return -1;
    }

    protected final List<IAdaptable> createViews(List<EObject> eObjects) {
        CreateViewRequest request;
        Command cmd;
        ArrayList<CreateViewRequest.ViewDescriptor> descriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (EObject element : eObjects) {
            if (element == null) continue;
            descriptors.add(this.getViewDescriptor(element));
        }
        if (!descriptors.isEmpty() && (cmd = this.getCreateViewCommand(request = this.getCreateViewRequest(descriptors))) != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            this.executeCommand(cmd);
            List adapters = (List)request.getNewObject();
            return adapters;
        }
        return Collections.emptyList();
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)this.getHost(), false, false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"executeCommand", (Throwable)e);
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"executeCommand", (Throwable)e);
        }
    }

    protected Command getCreateViewCommand(CreateRequest request) {
        assert (request instanceof CreateViewRequest);
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        Command cmd = this.host().getCommand((Request)request);
        if (cmd == null) {
            for (CreateViewRequest.ViewDescriptor viewDescriptor : ((CreateViewRequest)request).getViewDescriptors()) {
                ICommand createCommand = this.getCreateViewCommand(viewDescriptor);
                cc.compose((IUndoableOperation)createCommand);
            }
        } else {
            cc.compose((IUndoableOperation)new CommandProxy(cmd));
            for (CreateViewRequest.ViewDescriptor viewDescriptor : ((CreateViewRequest)request).getViewDescriptors()) {
                cc.compose((IUndoableOperation)new CommandProxy(SetViewMutabilityCommand.makeMutable(viewDescriptor)));
            }
        }
        return new ICommandProxy(cc.reduce());
    }

    protected ICommand getCreateViewCommand(CreateViewRequest.ViewDescriptor descriptor) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CreateCommand createCommand = new CreateCommand(editingDomain, descriptor, (View)this.getHost().getModel());
        CompositeCommand cmd = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        cmd.compose((IUndoableOperation)createCommand);
        cmd.compose((IUndoableOperation)new CommandProxy(SetViewMutabilityCommand.makeMutable(descriptor)));
        return cmd;
    }

    protected CreateViewRequest getCreateViewRequest(List<CreateViewRequest.ViewDescriptor> descriptors) {
        return new CreateViewRequest(descriptors);
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(IAdaptable elementAdapter, Class viewKind, String hint, int index) {
        return new CreateViewRequest.ViewDescriptor(elementAdapter, viewKind, hint, index, false, this.host().getDiagramPreferencesHint());
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(EObject element) {
        String factoryHint = this.getDefaultFactoryHint();
        CanonicalElementAdapter elementAdapter = new CanonicalElementAdapter(element, factoryHint);
        int pos = this.getViewIndexFor(element);
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor((IAdaptable)elementAdapter, Node.class, this.getFactoryHint((IAdaptable)elementAdapter, factoryHint), pos);
        return descriptor;
    }

    public void activate() {
        EObject semanticHost = this.getSemanticHost();
        if (semanticHost != null && !this.isActive()) {
            this.addListenerFilter(SEMANTIC_FILTER_ID, this, semanticHost);
            this.addListenerFilter("NotationListener_Visibility", this, (EObject)((View)this.getHost().getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible());
            Style style = ((View)this.host().getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
            if (style != null) {
                this.addListenerFilter("NotationListener_DrawerStyle", this, (EObject)style);
            }
            if ((style = ((View)this.host().getModel()).getStyle(NotationPackage.eINSTANCE.getCanonicalStyle())) != null) {
                this.addListenerFilter("NotationListener_CanonicalStyle", this, (EObject)style);
            }
            this.refreshOnActivate();
        }
        this.RegisterEditPolicy();
    }

    protected void refreshOnActivate() {
        this.refresh();
    }

    public boolean isEnabled() {
        boolean enabled;
        boolean isCollapsed;
        if (TransactionUtil.getEditingDomain((EObject)((EObject)this.getHost().getModel())) == null) {
            return false;
        }
        DrawerStyle dstyle = (DrawerStyle)((View)this.host().getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        boolean bl = isCollapsed = dstyle == null ? false : dstyle.isCollapsed();
        if (isCollapsed) {
            return false;
        }
        CanonicalStyle style = this.getCanonicalStyle();
        boolean bl2 = enabled = this._enabled && ((View)this.host().getModel()).isVisible();
        return style == null ? enabled : style.isCanonical() && enabled;
    }

    public void enableRefresh(boolean enable) {
        this._enabled = enable;
        if (this._enabled && this._deferredRefresh) {
            this._deferredRefresh = false;
            this.refresh();
        }
    }

    public void setEnable(boolean enable) {
        EObject sHost = this.getSemanticHost();
        List<CanonicalEditPolicy> registeredPolicies = CanonicalEditPolicy.getRegisteredEditPolicies(sHost);
        CanonicalEditPolicy[] policies = new CanonicalEditPolicy[registeredPolicies.size()];
        registeredPolicies.toArray(policies);
        int i = 0;
        while (i < policies.length) {
            policies[i].enableRefresh(enable);
            ++i;
        }
    }

    public final boolean isActive() {
        return this._listenerFilters == null ? false : this._listenerFilters.containsKey(SEMANTIC_FILTER_ID);
    }

    public EObject getSemanticHost() {
        return ViewUtil.resolveSemanticElement((View)((View)this.host().getModel()));
    }

    public void deactivate() {
        if (this._listenerFilters != null) {
            HashMap<String, Object[]> listeners = new HashMap<String, Object[]>(this._listenerFilters);
            for (String id : listeners.keySet()) {
                this.removeListenerFilter(id);
            }
        }
        this.UnregisterEditPolicy();
    }

    protected boolean addListenerFilter(String filterId, NotificationListener listener, EObject element) {
        if (filterId == null || listener == null) {
            throw new NullPointerException();
        }
        if (element != null) {
            if (this._listenerFilters == null) {
                this._listenerFilters = new HashMap<String, Object[]>();
            }
            if (!this._listenerFilters.containsKey(filterId)) {
                this.getDiagramEventBroker().addNotificationListener(element, listener);
                this._listenerFilters.put(filterId, new Object[]{element, listener});
                return true;
            }
        }
        return false;
    }

    protected boolean addListenerFilter(String filterId, NotificationListener listener, EObject element, EStructuralFeature feature) {
        if (filterId == null || listener == null) {
            throw new NullPointerException();
        }
        if (element != null) {
            if (this._listenerFilters == null) {
                this._listenerFilters = new HashMap<String, Object[]>();
            }
            if (!this._listenerFilters.containsKey(filterId)) {
                this.getDiagramEventBroker().addNotificationListener(element, feature, listener);
                this._listenerFilters.put(filterId, new Object[]{element, feature, listener});
                return true;
            }
        }
        return false;
    }

    protected void removeListenerFilter(String filterId) {
        if (this._listenerFilters == null) {
            return;
        }
        Object[] objects = this._listenerFilters.remove(filterId);
        if (objects == null) {
            return;
        }
        if (objects.length > 2) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)objects[0], (Object)((EStructuralFeature)objects[1]), (NotificationListener)objects[2]);
        } else {
            this.getDiagramEventBroker().removeNotificationListener((EObject)objects[0], (NotificationListener)objects[1]);
        }
    }

    public final void notifyChanged(Notification notification) {
        if (this.isHostStillValid()) {
            Object element = notification.getNotifier();
            if (element == null) {
                return;
            }
            this.handleNotificationEvent(notification);
        }
    }

    protected final boolean isHostStillValid() {
        if (!this.host().isActive()) {
            return false;
        }
        EObject eObject = (EObject)this.host().getModel();
        return eObject == null || eObject.eResource() != null || eObject.eIsProxy();
    }

    protected void handleNotificationEvent(Notification event) {
        boolean shouldRefresh = false;
        if (this.shouldHandleNotificationEvent(event)) {
            CanonicalStyle style;
            if (NotationPackage.eINSTANCE.getCanonicalStyle_Canonical() == event.getFeature() && (style = (CanonicalStyle)((View)this.host().getModel()).getStyle(NotationPackage.eINSTANCE.getCanonicalStyle())) != null) {
                this.setEnable(style.isCanonical());
            }
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.refresh();
        }
    }

    protected boolean shouldHandleNotificationEvent(Notification event) {
        if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed() == event.getFeature() || NotationPackage.eINSTANCE.getCanonicalStyle_Canonical() == event.getFeature() || NotationPackage.eINSTANCE.getView_Visible() == event.getFeature() || NotationPackage.eINSTANCE.getView_PersistedChildren() == event.getFeature()) {
            return true;
        }
        Object element = event.getNotifier();
        if (element instanceof EObject && !(element instanceof View)) {
            boolean addOrDelete = NotificationUtil.isElementAddedToSlot((Notification)event) || NotificationUtil.isElementRemovedFromSlot((Notification)event);
            EStructuralFeature feature = this.getFeatureToSynchronize();
            if (feature != null) {
                return feature.equals(event.getFeature()) && (addOrDelete || NotificationUtil.isSlotModified((Notification)event));
            }
            Set<EStructuralFeature> features = this.getFeaturesToSynchronize();
            if (features != null && !features.isEmpty()) {
                return features.contains(event.getFeature()) && (addOrDelete || NotificationUtil.isSlotModified((Notification)event));
            }
            if (addOrDelete) {
                return true;
            }
        }
        return false;
    }

    protected List<View> getViewChildren() {
        return this.getViewChildren((View)this.host().getModel());
    }

    private List<View> getViewChildren(View view) {
        ArrayList<View> list = new ArrayList<View>();
        for (View child : view.getChildren()) {
            if (child instanceof Node && ViewType.GROUP.equals(((Node)child).getType())) {
                list.addAll(this.getViewChildren(child));
                continue;
            }
            list.add(child);
        }
        return list;
    }

    public final void refresh() {
        try {
            if (this.isEnabled()) {
                boolean defRefresh = this._deferredRefresh;
                this._deferredRefresh = false;
                this.refreshSemantic();
                this._deferredRefresh = defRefresh;
            } else {
                this._deferredRefresh = true;
            }
        }
        catch (Throwable t) {
            String eMsg = DiagramUIMessages.CanonicalEditPolicy_refresh_failed_ERROR_;
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)2, (String)eMsg, (Throwable)t);
        }
    }

    protected void refreshSemantic() {
        List<IAdaptable> createdViews = this.refreshSemanticChildren();
        this.makeViewsImmutable(createdViews);
    }

    protected final void makeViewsMutable(List<IAdaptable> createdViews) {
        if (createdViews != null && !createdViews.isEmpty()) {
            List<IAdaptable> viewAdapters = this.prepareAdapterList(createdViews);
            this.executeCommand(SetViewMutabilityCommand.makeMutable(viewAdapters));
        }
    }

    protected final void makeViewsImmutable(List<IAdaptable> createdViews) {
        if (createdViews != null && !createdViews.isEmpty()) {
            this.addListenersToContainers(createdViews);
            List<IAdaptable> viewAdapters = this.prepareAdapterList(createdViews);
            SetViewMutabilityCommand immutable = SetViewMutabilityCommand.makeImmutable(viewAdapters);
            AsyncCommand ac = new AsyncCommand(immutable);
            ac.execute();
        }
    }

    private void addListenersToContainers(List<IAdaptable> createdViews) {
        UniqueEList list = new UniqueEList();
        for (IAdaptable obj : createdViews) {
            View view = (View)obj.getAdapter(View.class);
            if (view == null) continue;
            list.add((Object)((View)view.eContainer()));
        }
        for (View containerView : list) {
            this.addListenerFilter("NotationListener_Container_" + containerView.getClass().getName() + '@' + Integer.toHexString(containerView.hashCode()), this, (EObject)containerView, (EStructuralFeature)NotationPackage.eINSTANCE.getView_PersistedChildren());
        }
    }

    private List<IAdaptable> prepareAdapterList(List<IAdaptable> createdViews) {
        ArrayList<IAdaptable> viewAdapters = new ArrayList<IAdaptable>();
        viewAdapters.add((IAdaptable)this.host());
        ListIterator<IAdaptable> li = createdViews.listIterator();
        while (li.hasNext()) {
            IAdaptable adapter = li.next();
            if (adapter == null) continue;
            if (!(adapter instanceof IAdaptable) && adapter instanceof EObject) {
                viewAdapters.add((IAdaptable)new EObjectAdapter((EObject)adapter));
                continue;
            }
            viewAdapters.add(adapter);
        }
        return viewAdapters;
    }

    protected final List<IAdaptable> refreshSemanticChildren() {
        if (this.resolveSemanticElement() == null) {
            return Collections.emptyList();
        }
        List<View> viewChildren = this.getViewChildren();
        ArrayList<EObject> semanticChildren = new ArrayList<EObject>(this.getSemanticChildrenList());
        List<View> orphaned = this.cleanCanonicalSemanticChildren(viewChildren, semanticChildren);
        boolean changed = false;
        if (!orphaned.isEmpty()) {
            changed = this.deleteViews(orphaned.iterator());
        }
        List<IAdaptable> createdViews = Collections.emptyList();
        if (!semanticChildren.isEmpty()) {
            createdViews = this.createViews(semanticChildren);
            int i = 0;
            while (i < createdViews.size()) {
                View createdView = (View)createdViews.get(i).getAdapter(View.class);
                if (createdView == null) {
                    String eMsg = NLS.bind((String)DiagramUIMessages.CanonicalEditPolicy_create_view_failed_ERROR_, semanticChildren.get(i));
                    IllegalStateException ise = new IllegalStateException(eMsg);
                    Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)eMsg, (Throwable)ise);
                    throw ise;
                }
                ++i;
            }
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        return createdViews;
    }

    protected final List<View> cleanCanonicalSemanticChildren(Collection<? extends View> viewChildren, Collection<EObject> semanticChildren) {
        ArrayList<View> orphaned = new ArrayList<View>();
        HashMap<EObject, View> viewToSemanticMap = new HashMap<EObject, View>();
        for (View view : viewChildren) {
            EObject semanticChild = view.getElement();
            if (!this.isOrphaned(semanticChildren, view)) {
                semanticChildren.remove(semanticChild);
                viewToSemanticMap.put(semanticChild, view);
            } else {
                orphaned.add(view);
            }
            View viewInMap = (View)viewToSemanticMap.get(semanticChild);
            if (viewInMap == null || view.equals(viewInMap) || !viewInMap.isMutable()) continue;
            orphaned.remove(view);
            orphaned.add(viewInMap);
            viewToSemanticMap.put(semanticChild, view);
        }
        return orphaned;
    }

    protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
        return !semanticChildren.contains(view.getElement());
    }

    protected void postProcessRefreshSemantic(List<IAdaptable> viewDescriptors) {
        this.getHost().refresh();
    }

    protected final EObject resolveSemanticElement() {
        return ViewUtil.resolveSemanticElement((View)((View)this.host().getModel()));
    }

    protected CanonicalStyle getCanonicalStyle() {
        return (CanonicalStyle)((View)this.host().getModel()).getStyle(NotationPackage.eINSTANCE.getCanonicalStyle());
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public final EditPartViewer getViewer() {
        return this.getHost().getViewer();
    }

    protected Set<EStructuralFeature> getFeaturesToSynchronize() {
        return Collections.emptySet();
    }

    protected EStructuralFeature getFeatureToSynchronize() {
        return null;
    }

    public boolean canCreate(EObject eObject) {
        return eObject == null ? false : this.getSemanticChildrenList().contains(eObject);
    }

    private static class AsyncCommand
    extends Command {
        private final CompoundCommand _cc;

        public AsyncCommand(String label) {
            super(label);
            this._cc = new CompoundCommand(label);
        }

        public AsyncCommand(Command cmd) {
            this(cmd.getLabel());
            this.add(cmd);
        }

        public AsyncCommand(ICommand cmd) {
            this(cmd.getLabel());
            this.add(cmd);
        }

        public final void execute() {
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AsyncCommand.this.doExecute();
                }
            });
        }

        protected final CompoundCommand getCommand() {
            return this._cc;
        }

        protected void doExecute() {
            this.getCommand().execute();
        }

        public void add(ICommand cmd) {
            this._cc.add((Command)new ICommandProxy(cmd));
        }

        public void add(Command cmd) {
            this._cc.add(cmd);
        }
    }

    protected static final class CanonicalElementAdapter
    extends EObjectAdapter {
        private String _hint;

        public CanonicalElementAdapter(EObject element, String hint) {
            super(element);
            this._hint = hint;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(String.class)) {
                return this._hint;
            }
            return super.getAdapter(adapter);
        }
    }
}

