/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.commands;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.commands.RemoveNotationalEdgeCommand;
import org.eclipse.gmf.runtime.lite.commands.RemoveNotationalElementCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class ReplaceNotationalElementCommand
extends AbstractCommand {
    private final CreateNotationalElementCommand createCommand;
    private final RemoveNotationalElementCommand removeCommand;
    private final View obsoleteView;

    public ReplaceNotationalElementCommand(View parentView, CreateNotationalElementCommand createCommand, View obsoleteView) {
        this.createCommand = createCommand;
        this.obsoleteView = obsoleteView;
        this.removeCommand = obsoleteView instanceof Edge ? new RemoveNotationalEdgeCommand(parentView, obsoleteView) : new RemoveNotationalElementCommand(parentView, obsoleteView);
    }

    public boolean canExecute() {
        return this.createCommand != null && this.createCommand.canExecute() && this.removeCommand != null && this.removeCommand.canExecute();
    }

    public boolean canUndo() {
        return this.createCommand != null && this.createCommand.canUndo() && this.removeCommand != null && this.removeCommand.canUndo();
    }

    public void execute() {
        this.createCommand.execute();
        this.removeCommand.execute();
        View createdView = this.createCommand.getCreatedView();
        if (createdView != null && this.obsoleteView != null && createdView.eClass().equals(this.obsoleteView.eClass())) {
            if (NotationPackage.eINSTANCE.getNode().equals(createdView.eClass())) {
                this.copy((EObject)this.obsoleteView, (EObject)createdView, (EStructuralFeature)NotationPackage.eINSTANCE.getNode_LayoutConstraint());
            } else if (NotationPackage.eINSTANCE.getEdge().equals(createdView.eClass())) {
                this.copy((EObject)this.obsoleteView, (EObject)createdView, (EStructuralFeature)NotationPackage.eINSTANCE.getEdge_Bendpoints());
            }
        }
    }

    private void copy(EObject source, EObject target, EStructuralFeature feature) {
        EObject oldValue = (EObject)source.eGet(feature);
        if (oldValue == null) {
            return;
        }
        EObject newValue = (EObject)target.eGet(feature);
        if (newValue != null && !newValue.eClass().equals(oldValue.eClass())) {
            return;
        }
        target.eSet(feature, (Object)oldValue);
    }

    public void undo() {
        View createdView = this.createCommand.getCreatedView();
        if (createdView != null && this.obsoleteView != null && createdView.eClass().equals(this.obsoleteView.eClass())) {
            if (NotationPackage.eINSTANCE.getNode().equals(createdView.eClass())) {
                this.copy((EObject)createdView, (EObject)this.obsoleteView, (EStructuralFeature)NotationPackage.eINSTANCE.getNode_LayoutConstraint());
            } else if (NotationPackage.eINSTANCE.getEdge().equals(createdView.eClass())) {
                this.copy((EObject)createdView, (EObject)this.obsoleteView, (EStructuralFeature)NotationPackage.eINSTANCE.getEdge_Bendpoints());
            }
        }
        this.removeCommand.undo();
        this.createCommand.undo();
    }

    public void redo() {
        this.execute();
    }
}

