/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.parts;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gmf.runtime.lite.parts.DiagramContentOutlinePage;
import org.eclipse.gmf.runtime.lite.parts.DiagramDisplayer;
import org.eclipse.gmf.runtime.lite.parts.DiagramEditorInput;
import org.eclipse.gmf.runtime.lite.parts.IDiagramManager;
import org.eclipse.gmf.runtime.lite.services.DefaultDiagramLayouter;
import org.eclipse.gmf.runtime.lite.services.IDiagramLayouter;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagramEditor
extends EditorPart
implements IDiagramManager {
    private DiagramDisplayer myDiagramDisplayer;
    private boolean myIsDirty = false;
    private CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            DiagramEditor.this.setDirty(((CommandStack)event.getSource()).isDirty());
        }
    };
    private CommandStackEventListener mySaveListener = new CommandStackEventListener(){

        public void stackChanged(CommandStackEvent event) {
            if (event.isPostChangeEvent() && this.isSaved()) {
                DiagramEditor.this.getCommandStack().markSaveLocation();
            }
        }

        private boolean isSaved() {
            for (Resource next : DiagramEditor.this.getEditingDomain().getResourceSet().getResources()) {
                if (!next.isLoaded() || next.isTrackingModification() && !next.isModified()) continue;
                return false;
            }
            return true;
        }
    };

    protected void save(IProgressMonitor monitor) throws CoreException {
        this.myDiagramDisplayer.save(this.getSaveOptions(), monitor);
    }

    protected Map<?, ?> getSaveOptions() {
        return Collections.emptyMap();
    }

    public final TransactionalEditingDomain getEditingDomain() {
        return this.myDiagramDisplayer.getEditingDomain();
    }

    protected final EditDomain getEditDomain() {
        return this.myDiagramDisplayer.getEditDomain();
    }

    protected final CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected final ZoomManager getZoomManager() {
        return this.myDiagramDisplayer.getZoomManager();
    }

    protected final ActionRegistry getActionRegistry() {
        return this.myDiagramDisplayer.getActionRegistry();
    }

    protected final GraphicalViewer getGraphicalViewer() {
        return this.myDiagramDisplayer.getGraphicalViewer();
    }

    protected IPropertySheetPage getPropertySheetPage() {
        return this.myDiagramDisplayer.getPropertySheetPage();
    }

    protected IContentOutlinePage getOutlinePage() {
        return new DiagramContentOutlinePage(this.myDiagramDisplayer, this.getDefaultOutlineViewMode());
    }

    protected IDiagramLayouter getDiagramLayouter() {
        return new DefaultDiagramLayouter();
    }

    protected int getDefaultOutlineViewMode() {
        return 0;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        ForceTrackingModificationAdapter adapter;
        this.setSite((IWorkbenchPartSite)site);
        TransactionalEditingDomain editingDomain = this.getEditingDomain(input);
        if (editingDomain == null) {
            editingDomain = this.reuseEditingDomain(input);
        }
        if (editingDomain == null) {
            editingDomain = this.createEditingDomain();
        }
        if ((adapter = (ForceTrackingModificationAdapter)EcoreUtil.getExistingAdapter((Notifier)editingDomain.getResourceSet(), ForceTrackingModificationAdapter.class)) == null) {
            adapter = new ForceTrackingModificationAdapter();
            editingDomain.getResourceSet().eAdapters().add((Object)adapter);
        }
        adapter.acquire();
        this.myDiagramDisplayer = new DiagramDisplayer(this, this.createEditDomain(), editingDomain);
        this.getCommandStack().addCommandStackListener(this.commandStackListener);
        this.getCommandStack().addCommandStackEventListener(this.mySaveListener);
        this.setInput(input);
    }

    public void dispose() {
        if (this.myDiagramDisplayer != null) {
            this.getCommandStack().removeCommandStackEventListener(this.mySaveListener);
            this.getCommandStack().removeCommandStackListener(this.commandStackListener);
            ForceTrackingModificationAdapter adapter = (ForceTrackingModificationAdapter)EcoreUtil.getExistingAdapter((Notifier)this.getEditingDomain().getResourceSet(), ForceTrackingModificationAdapter.class);
            if (adapter != null) {
                adapter.release();
                if (adapter.isReleased()) {
                    this.getEditingDomain().getResourceSet().eAdapters().remove((Object)adapter);
                }
            }
            this.myDiagramDisplayer.dispose();
            this.myDiagramDisplayer = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (type == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (type == ZoomManager.class) {
            return this.getZoomManager();
        }
        if (type == IDiagramLayouter.class) {
            return this.getDiagramLayouter();
        }
        if (type == PalettePage.class) {
            return this.myDiagramDisplayer.getPalettePage();
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return super.getAdapter(type);
    }

    private void setDirty(boolean isDirty) {
        if (isDirty != this.myIsDirty) {
            this.myIsDirty = isDirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    protected void addAction(IAction action) {
        this.myDiagramDisplayer.addAction(action);
    }

    protected void addEditorAction(WorkbenchPartAction action) {
        this.myDiagramDisplayer.addEditorAction(action);
    }

    protected void addEditPartAction(SelectionAction action) {
        this.myDiagramDisplayer.addEditPartAction(action);
    }

    protected void addStackAction(StackAction action) {
        this.myDiagramDisplayer.addStackAction(action);
    }

    public void createPartControl(Composite parent) {
        this.myDiagramDisplayer.createViewer(parent);
        this.createActions();
    }

    public void setFocus() {
        this.myDiagramDisplayer.setFocus();
    }

    protected TransactionalEditingDomain getEditingDomain(IEditorInput input) {
        if (input instanceof DiagramEditorInput) {
            TransactionalEditingDomain result = TransactionUtil.getEditingDomain((EObject)((DiagramEditorInput)input).getDiagram());
            return result;
        }
        return null;
    }

    protected TransactionalEditingDomain reuseEditingDomain(IEditorInput input) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
        IEditorMatchingStrategy matchingStrategy = editorDesc.getEditorMatchingStrategy();
        IEditorReference[] editorRefs = this.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            DiagramEditor anotherEditor;
            if (this.matches(matchingStrategy, editorRefs[i], input) && (anotherEditor = (DiagramEditor)editorRefs[i].getEditor(false)) != null) {
                return anotherEditor.getEditingDomain();
            }
            ++i;
        }
        return null;
    }

    private boolean matches(IEditorMatchingStrategy strategy, IEditorReference editorRef, IEditorInput input) {
        if (strategy == null) {
            if (this.getSite().getId().equals(editorRef.getId())) {
                try {
                    return input.equals(editorRef.getEditorInput());
                }
                catch (PartInitException partInitException) {
                    return false;
                }
            }
            return false;
        }
        return strategy.matches(editorRef, input);
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        editingDomain.getResourceSet().eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)editingDomain));
        return editingDomain;
    }

    @Override
    public void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
    }

    protected double[] getZoomLevels() {
        double[] result = new double[]{0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 4.0};
        return result;
    }

    @Override
    public abstract void configurePalette(PaletteRoot var1);

    protected EditDomain createEditDomain() {
        DefaultEditDomain domain = new DefaultEditDomain((IEditorPart)this);
        return domain;
    }

    @Override
    public abstract void initializeGraphicalViewer();

    @Override
    public abstract AdapterFactory getDomainAdapterFactory();

    @Override
    public abstract boolean isFlyoutPalette();

    protected abstract void createActions();

    private static class ForceTrackingModificationAdapter
    extends AdapterImpl {
        private int myRefCount;

        private ForceTrackingModificationAdapter() {
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            if (newTarget instanceof ResourceSet) {
                ResourceSet resourceSet = (ResourceSet)newTarget;
                for (Resource next : resourceSet.getResources()) {
                    next.setTrackingModification(true);
                }
            }
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() == this.getTarget() && msg.getFeatureID(ResourceSet.class) == 0) {
                switch (msg.getEventType()) {
                    case 3: {
                        Resource resource = (Resource)msg.getNewValue();
                        resource.setTrackingModification(true);
                        break;
                    }
                    case 5: {
                        Collection resources = (Collection)msg.getNewValue();
                        for (Resource next : resources) {
                            next.setTrackingModification(true);
                        }
                        break;
                    }
                }
            }
        }

        public boolean isAdapterForType(Object type) {
            return ForceTrackingModificationAdapter.class.equals(type);
        }

        public void acquire() {
            ++this.myRefCount;
        }

        public void release() {
            if (this.myRefCount == 0) {
                throw new IllegalStateException();
            }
            --this.myRefCount;
        }

        public boolean isReleased() {
            return this.myRefCount == 0;
        }
    }
}

