/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.util;

import java.util.List;
import java.util.ListIterator;
import junit.framework.Assert;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.util.IDEEditorUtil;
import org.eclipse.gmf.runtime.diagram.ui.tools.ConnectionCreationTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.AbstractPresentationTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.IPresentationTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.TestsPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractPresentationTestFixture
extends Assert
implements IPresentationTestFixture {
    private IProject project = null;
    private IDiagramWorkbenchPart diagramWorkbenchPart = null;
    private IFile diagramFile = null;
    private TransactionalEditingDomain editingDomain;
    private Resource resource;
    private Diagram diagram;
    private DiagramEditPart diagramEditPart;
    private Edge connectorView = null;
    private static boolean _verbose = Boolean.getBoolean("presentation.test.verbose");
    static /* synthetic */ Class class$0;

    public IFile getDiagramFile() {
        return this.diagramFile;
    }

    protected final void enableVerbose(boolean enabled) {
        _verbose = enabled;
    }

    public final boolean isVerbose() {
        return _verbose;
    }

    public static final void println(Object msg) {
        if (_verbose) {
            System.out.println(msg);
        }
    }

    public static final void print(Object msg) {
        if (_verbose) {
            System.out.print(msg);
        }
    }

    public IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        if (this.diagramWorkbenchPart == null) {
            AbstractPresentationTestFixture.assertTrue((String)"It appears that the diagram needs to be opened for this test.  Call openDiagram().", (boolean)false);
        }
        return this.diagramWorkbenchPart;
    }

    public IProject getProject() {
        return this.project;
    }

    protected void setDiagramFile(IFile diagramFile) {
        this.diagramFile = diagramFile;
    }

    public CommandStack getCommandStack() {
        return this.getDiagramEditPart().getDiagramEditDomain().getDiagramCommandStack();
    }

    public void setDiagramWorkbenchPart(IDiagramWorkbenchPart diagramWorkbenchPart) {
        this.diagramWorkbenchPart = diagramWorkbenchPart;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    public void setup() throws Exception {
        this.createProject();
        this.createDiagram();
        this.createResource();
        this.createDiagramEditPart();
        this.flushEventQueue();
        this.createShapesAndConnectors();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void tearDown() throws Exception {
        Throwable pde;
        Throwable cde;
        boolean diagramClosed;
        block11: {
            diagramClosed = false;
            cde = null;
            pde = null;
            try {
                try {
                    diagramClosed = this.closeDiagram();
                }
                catch (Throwable cdt) {
                    cde = cdt;
                }
                try {
                    if (this.project != null) {
                        this.project.delete(true, true, null);
                    }
                }
                catch (Throwable pdt) {
                    pde = pdt;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.setDiagramWorkbenchPart(null);
                if (this.getResource() != null) {
                    this.getResource().unload();
                    this.setResource(null);
                }
                this.setDiagramFile(null);
                this.setProject(null);
                this.setConnectorView(null);
                this.flushEventQueue();
                if (!diagramClosed) {
                    Log.error((Plugin)TestsPlugin.getDefault(), (int)4, (String)"FAILED TO CLOSE DIAGRAM", (Throwable)cde);
                }
                if (pde == null) throw throwable;
                Log.error((Plugin)TestsPlugin.getDefault(), (int)4, (String)"FAILED TO DELETE PROJECT", (Throwable)pde);
                throw throwable;
            }
            {
                Object var5_8 = null;
                this.setDiagramWorkbenchPart(null);
                if (this.getResource() == null) break block11;
            }
            this.getResource().unload();
            this.setResource(null);
        }
        this.setDiagramFile(null);
        this.setProject(null);
        this.setConnectorView(null);
        this.flushEventQueue();
        if (!diagramClosed) {
            Log.error((Plugin)TestsPlugin.getDefault(), (int)4, (String)"FAILED TO CLOSE DIAGRAM", (Throwable)cde);
        }
        if (pde == null) return;
        Log.error((Plugin)TestsPlugin.getDefault(), (int)4, (String)"FAILED TO DELETE PROJECT", (Throwable)pde);
    }

    public Edge getConnectorView() {
        return this.connectorView;
    }

    protected void setConnectorView(Edge connectorView) {
        this.connectorView = connectorView;
    }

    public void flushEventQueue() {
        Display display = Display.getCurrent();
        while (display.readAndDispatch()) {
        }
    }

    public void openDiagram() throws Exception {
        if (this.getDiagramFile() == null) {
            this.createDiagram();
        }
        AbstractPresentationTestFixture.assertTrue((String)"creation of diagram failed", (this.getDiagramFile() != null ? 1 : 0) != 0);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDEEditorUtil.openDiagram((IFile)this.getDiagramFile(), (IWorkbenchWindow)page.getWorkbenchWindow(), (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        this.setDiagramWorkbenchPart((IDiagramWorkbenchPart)IDE.openEditor((IWorkbenchPage)page, (IFile)this.getDiagramFile(), (boolean)true));
        this.setDiagramEditPart(this.getDiagramWorkbenchPart().getDiagramEditPart());
        this.setDiagram(this.getDiagramEditPart().getDiagramView());
        this.setResource(this.getDiagram().eResource());
    }

    public boolean closeDiagram() {
        boolean closed = true;
        if (this.diagramWorkbenchPart != null && this.diagramWorkbenchPart instanceof IEditorPart) {
            IWorkbenchPage page = this.getDiagramWorkbenchPart().getSite().getPage();
            closed = page.closeEditor((IEditorPart)this.getDiagramWorkbenchPart(), false);
            this.setDiagramWorkbenchPart(null);
        }
        return closed;
    }

    protected boolean isDirty() {
        return ((EditorPart)this.getDiagramWorkbenchPart()).isDirty();
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public void setDiagramEditPart(DiagramEditPart diagramEditPart) {
        this.diagramEditPart = diagramEditPart;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public DiagramEditPart getDiagramEditPart() {
        return this.diagramEditPart;
    }

    protected abstract void createProject() throws Exception;

    protected abstract void createDiagram() throws Exception;

    protected void createResource() {
        if (this.getResource() == null) {
            IFile file = this.getDiagramFile();
            if (file != null) {
                String filePath = file.getLocation().toOSString();
                this.setResource(this.getEditingDomain().loadResource(filePath));
            } else {
                this.setResource(this.getEditingDomain().createResource("null:/org.eclipse.gmf.tests.runtime.diagram.ui"));
            }
            if (this.getDiagram() != null) {
                AbstractEMFOperation operation = new AbstractEMFOperation(this.getEditingDomain(), "AbstractPresentationTestFixture setup"){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        AbstractPresentationTestFixture.this.getResource().getContents().add((Object)AbstractPresentationTestFixture.this.getDiagram());
                        return Status.OK_STATUS;
                    }
                };
                try {
                    operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException ie) {
                    AbstractPresentationTestFixture.fail((String)("createResource failed: " + ie.getLocalizedMessage()));
                }
            }
        }
    }

    protected void createDiagramEditPart() throws Exception {
        if (this.getDiagramEditPart() == null) {
            this.setDiagramEditPart(OffscreenEditPartFactory.getInstance().createDiagramEditPart(this.getDiagram()));
        }
    }

    public ShapeEditPart createShapeUsingTool(IElementType elementType, Point location, IGraphicalEditPart containerEP) {
        CreateRequest request = this.getCreationRequest(elementType);
        request.setLocation(location);
        Command cmd = containerEP.getCommand((Request)request);
        int previousNumChildren = containerEP.getChildren().size();
        this.getCommandStack().execute(cmd);
        AbstractPresentationTestFixture.assertEquals((int)(previousNumChildren + 1), (int)containerEP.getChildren().size());
        IAdaptable iAdaptable = (IAdaptable)((List)request.getNewObject()).get(0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object newView = iAdaptable.getAdapter((Class)clazz);
        AbstractPresentationTestFixture.assertNotNull((Object)newView);
        AbstractPresentationTestFixture.assertTrue((!ViewUtil.isTransient((EObject)((View)newView)) ? 1 : 0) != 0);
        EObject element = ((View)newView).getElement();
        this.getCommandStack().undo();
        AbstractPresentationTestFixture.assertEquals((int)previousNumChildren, (int)containerEP.getChildren().size());
        this.getCommandStack().redo();
        AbstractPresentationTestFixture.assertEquals((int)(previousNumChildren + 1), (int)containerEP.getChildren().size());
        ShapeEditPart newShape = null;
        if (element != null) {
            List children = containerEP.getChildren();
            ListIterator li = children.listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
                if (!gep.getNotationView().getElement().equals(element)) continue;
                newShape = gep;
            }
        } else {
            newShape = (ShapeEditPart)this.getDiagramEditPart().getViewer().getEditPartRegistry().get(newView);
            AbstractPresentationTestFixture.assertNotNull((Object)newShape);
        }
        AbstractPresentationTestFixture.assertTrue((newShape != null && newShape instanceof ShapeEditPart ? 1 : 0) != 0);
        return newShape;
    }

    public CreateRequest getCreationRequest(IElementType elementType) {
        class CreationTool
        extends org.eclipse.gmf.runtime.diagram.ui.tools.CreationTool {
            final /* synthetic */ AbstractPresentationTestFixture this$0;

            public CreationTool(AbstractPresentationTestFixture abstractPresentationTestFixture, IElementType theElementType) {
                this.this$0 = abstractPresentationTestFixture;
                super(theElementType);
            }

            public Request createTargetRequest() {
                return super.createTargetRequest();
            }

            protected PreferencesHint getPreferencesHint() {
                return PreferencesHint.USE_DEFAULTS;
            }
        }
        CreationTool tool = new CreationTool(this, elementType);
        CreateRequest request = (CreateRequest)tool.createTargetRequest();
        return request;
    }

    public ShapeEditPart createShapeUsingTool(IElementType elementType, Point location) {
        return this.createShapeUsingTool(elementType, location, (IGraphicalEditPart)this.getDiagramEditPart());
    }

    public ConnectionEditPart createConnectorUsingTool(IGraphicalEditPart sourceEditPart, IGraphicalEditPart targetEditPart, IElementType elementType) {
        class ConnectorCreationTool
        extends ConnectionCreationTool {
            final /* synthetic */ AbstractPresentationTestFixture this$0;

            public ConnectorCreationTool(AbstractPresentationTestFixture abstractPresentationTestFixture, IElementType theElementType) {
                this.this$0 = abstractPresentationTestFixture;
                super(theElementType);
            }

            public Request createTargetRequest() {
                return super.createTargetRequest();
            }

            protected PreferencesHint getPreferencesHint() {
                return PreferencesHint.USE_DEFAULTS;
            }
        }
        ConnectorCreationTool tool = new ConnectorCreationTool(this, elementType);
        CreateConnectionRequest request = (CreateConnectionRequest)tool.createTargetRequest();
        request.setTargetEditPart((EditPart)sourceEditPart);
        request.setType((Object)"connection start");
        sourceEditPart.getCommand((Request)request);
        request.setSourceEditPart((EditPart)sourceEditPart);
        request.setTargetEditPart((EditPart)targetEditPart);
        request.setType((Object)"connection end");
        Command cmd = targetEditPart.getCommand((Request)request);
        int previousNumConnectors = this.getDiagramEditPart().getConnections().size();
        this.getCommandStack().execute(cmd);
        AbstractPresentationTestFixture.assertEquals((int)(previousNumConnectors + 1), (int)this.getDiagramEditPart().getConnections().size());
        this.getCommandStack().undo();
        AbstractPresentationTestFixture.assertEquals((int)previousNumConnectors, (int)this.getDiagramEditPart().getConnections().size());
        this.getCommandStack().redo();
        AbstractPresentationTestFixture.assertEquals((int)(previousNumConnectors + 1), (int)this.getDiagramEditPart().getConnections().size());
        IAdaptable iAdaptable = (IAdaptable)request.getNewObject();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.notation.View");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object newView = iAdaptable.getAdapter((Class)clazz);
        AbstractPresentationTestFixture.assertNotNull((Object)newView);
        ConnectionEditPart newConnector = (ConnectionEditPart)this.getDiagramEditPart().getViewer().getEditPartRegistry().get(newView);
        AbstractPresentationTestFixture.assertNotNull((Object)newConnector);
        return newConnector;
    }

    protected abstract void createShapesAndConnectors() throws Exception;

    public TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = this.getDiagram() != null ? TransactionUtil.getEditingDomain((EObject)this.getDiagram()) : DiagramEditingDomainFactory.getInstance().createEditingDomain();
        }
        return this.editingDomain;
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
    }
}

