/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

public class RuntimeWorkspaceSetup {
    private static final String PLUGIN_CONTAINER_ID = "org.eclipse.pde.core.requiredPlugins";
    private boolean isDevLaunchMode = RuntimeWorkspaceSetup.isDevLaunchMode();

    private static boolean isDevLaunchMode() {
        String[] args = Platform.getApplicationArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-pdelaunch")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RuntimeWorkspaceSetup init() throws Exception {
        this.ensureJava14();
        if (this.isDevLaunchMode) {
            this.importDevPluginsIntoRunTimeWorkspace(new String[]{"org.eclipse.gmf.runtime.notation", "org.eclipse.gmf.runtime.notation.edit", "org.eclipse.gmf.runtime.common.core", "org.eclipse.gmf.runtime.common.ui", "org.eclipse.gmf.runtime.draw2d.ui", "org.eclipse.gmf.runtime.draw2d.ui.render", "org.eclipse.gmf.runtime.gef.ui", "org.eclipse.gmf.runtime.common.ui.services", "org.eclipse.gmf.runtime.emf.type.core", "org.eclipse.gmf.runtime.emf.clipboard.core", "org.eclipse.emf.validation", "org.eclipse.gmf.runtime.emf.core", "org.eclipse.gmf.runtime.common.ui.services.action", "org.eclipse.gmf.runtime.common.ui.action", "org.eclipse.gmf.runtime.common.ui.action.ide", "org.eclipse.gmf.runtime.emf.ui", "org.eclipse.gmf.runtime.emf.commands.core", "org.eclipse.gmf.runtime.diagram.core", "org.eclipse.gmf.runtime.diagram.ui", "org.eclipse.gmf.runtime.common.ui.services.properties", "org.eclipse.gmf.runtime.emf.ui.properties", "org.eclipse.gmf.runtime.diagram.ui.actions", "org.eclipse.gmf.runtime.diagram.ui.properties", "org.eclipse.gmf.runtime.diagram.ui.providers", "org.eclipse.gmf.runtime.diagram.ui.providers.ide", "org.eclipse.gmf.runtime.diagram.ui.render", "org.eclipse.gmf.runtime.diagram.ui.resources.editor", "org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide", "org.eclipse.gmf.runtime.notation.providers", "org.eclipse.emf.ocl", "org.eclipse.emf.query", "org.eclipse.emf.query.ocl", "org.eclipse.emf.edit", "org.eclipse.emf.transaction", "org.eclipse.emf.workspace"});
        }
        return this;
    }

    public static IProject getSOSProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(".SOSProject");
    }

    private void importDevPluginsIntoRunTimeWorkspace(String[] pluginIDs) throws CoreException {
        IProject p = RuntimeWorkspaceSetup.getSOSProject();
        Path srcPath = new Path(String.valueOf('/') + p.getName() + "/src");
        Generator.createEMFProject((IPath)srcPath, null, (List)Collections.EMPTY_LIST, (IProgressMonitor)new NullProgressMonitor(), (int)Generator.EMF_PLUGIN_PROJECT_STYLE, null);
        StringBuffer pluginXmlContent = new StringBuffer();
        pluginXmlContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.0\"?>\n<plugin ");
        pluginXmlContent.append(" version=\"1.0.0\" name='%providerName' id='");
        pluginXmlContent.append(p.getName());
        pluginXmlContent.append("'>\n<requires>\n");
        pluginXmlContent.append("<import plugin='org.eclipse.jface.text' export='true'/>\n");
        pluginXmlContent.append("<import plugin='org.eclipse.ui.views.properties.tabbed' export='true'/>\n");
        ClasspathEntry[] classpathEntries = this.getClasspathEntries(pluginIDs);
        int i = 0;
        while (i < classpathEntries.length) {
            classpathEntries[i].importTo(p, pluginXmlContent);
            ++i;
        }
        pluginXmlContent.append("</requires>\n</plugin>");
        p.getFile("plugin.xml").create((InputStream)new ByteArrayInputStream(pluginXmlContent.toString().getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
    }

    private ClasspathEntry[] getClasspathEntries(String[] pluginIDs) {
        ArrayList<ClasspathEntry> entries = new ArrayList<ClasspathEntry>(pluginIDs.length);
        int i = 0;
        while (i < pluginIDs.length) {
            ClasspathEntry nextEntry = new ClasspathEntry(pluginIDs[i]);
            if (nextEntry.isValid()) {
                entries.add(nextEntry);
            } else {
                System.out.println("Bundle " + pluginIDs[i] + " is missing, skipped.");
            }
            ++i;
        }
        return entries.toArray(new ClasspathEntry[entries.size()]);
    }

    private IJavaProject asJavaProject(IProject p) {
        return JavaCore.create((IProject)p);
    }

    public void updateClassPath(IProject diagramProj) throws CoreException {
        IResource[] members;
        if (!this.isDevLaunchMode) {
            return;
        }
        try {
            members = RuntimeWorkspaceSetup.getSOSProject().members();
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            members = new IResource[]{};
        }
        IJavaProject sosJavaPrj = this.asJavaProject(RuntimeWorkspaceSetup.getSOSProject());
        IClasspathEntry[] cpOrig = this.asJavaProject(diagramProj).getRawClasspath();
        ArrayList<IClasspathEntry> rv = new ArrayList<IClasspathEntry>(10 + cpOrig.length + members.length);
        IClasspathContainer c = JavaCore.getClasspathContainer((IPath)new Path(PLUGIN_CONTAINER_ID), (IJavaProject)sosJavaPrj);
        if (c != null) {
            IClasspathEntry[] cpAdd = c.getClasspathEntries();
            rv.addAll(Arrays.asList(cpAdd));
        }
        int i = 0;
        while (i < members.length) {
            if (members[i].isLinked()) {
                rv.add(JavaCore.newLibraryEntry((IPath)members[i].getFullPath(), null, null));
            }
            ++i;
        }
        HashSet<IPath> uniqueClassPathEntries = new HashSet<IPath>();
        IClasspathEntry[] cpOrigResolved = this.asJavaProject(diagramProj).getResolvedClasspath(true);
        int i2 = 0;
        while (i2 < cpOrigResolved.length) {
            uniqueClassPathEntries.add(cpOrigResolved[i2].getPath());
            ++i2;
        }
        Iterator it = rv.iterator();
        while (it.hasNext()) {
            IClasspathEntry next = (IClasspathEntry)it.next();
            if (uniqueClassPathEntries.contains(next.getPath())) {
                it.remove();
                continue;
            }
            uniqueClassPathEntries.add(next.getPath());
        }
        rv.addAll(Arrays.asList(cpOrig));
        IClasspathEntry[] cpNew = rv.toArray(new IClasspathEntry[rv.size()]);
        this.asJavaProject(diagramProj).setRawClasspath(cpNew, (IProgressMonitor)new NullProgressMonitor());
    }

    public void ensureJava14() {
        if (!"1.4".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"))) {
            Hashtable options = JavaCore.getOptions();
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            options.put("org.eclipse.jdt.core.compiler.source", "1.4");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
            JavaCore.setOptions((Hashtable)options);
        }
    }

    private class ClasspathEntry {
        private String myPluginID;
        private URL myBundleURL;
        private File myBundleFile;
        private File myClassesContainerFile;

        private ClasspathEntry(String pluginID) {
            this.myPluginID = pluginID;
        }

        public void importTo(IProject p, StringBuffer pluginXmlContent) {
            if (!this.getClassesContainerFile().exists()) {
                pluginXmlContent.append("<import plugin='");
                pluginXmlContent.append(this.myPluginID);
                pluginXmlContent.append("' export='true'/>\n");
            } else if (this.getClassesContainerFile().isDirectory()) {
                String entryName = this.getBundleFile().getName().replace('.', '_');
                IFolder folder = p.getFolder(entryName);
                try {
                    folder.createLink((IPath)new Path(this.getClassesContainerFile().getAbsolutePath()), 256, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else if (this.getClassesContainerFile().isFile()) {
                String entryName = this.getClassesContainerFile().getName();
                IFile file = p.getFile(entryName);
                try {
                    file.createLink((IPath)new Path(this.getClassesContainerFile().getAbsolutePath()), 256, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        private File getClassesContainerFile() {
            if (this.myClassesContainerFile == null) {
                this.myClassesContainerFile = new File(this.getBundleFile(), this.getRelativePath());
            }
            return this.myClassesContainerFile;
        }

        private File getBundleFile() {
            if (this.myBundleFile == null) {
                this.myBundleFile = new File(this.getBundleURL().getFile());
            }
            return this.myBundleFile;
        }

        private String getRelativePath() {
            return "/bin/";
        }

        private URL getBundleURL() {
            if (this.myBundleURL == null) {
                Bundle bundle = Platform.getBundle((String)this.myPluginID);
                if (bundle == null) {
                    throw new NullPointerException("No plugin '" + this.myPluginID + "' found in the platform");
                }
                try {
                    this.myBundleURL = FileLocator.resolve((URL)bundle.getEntry("/"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return this.myBundleURL;
        }

        public boolean isValid() {
            return this.getBundleURL() != null;
        }
    }
}

