/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class FigureUtilities
extends org.eclipse.draw2d.FigureUtilities {
    public static Integer colorToInteger(Color c) {
        return new Integer(c.getBlue() << 16 | c.getGreen() << 8 | c.getRed());
    }

    public static Color integerToColor(Integer i) {
        if (i == null) {
            return null;
        }
        int color = i;
        return new Color(null, color & 0xFF, (color & 0xFF00) >> 8, (color & 0xFF0000) >> 16);
    }

    public static Integer RGBToInteger(RGB rgb) {
        return new Integer(rgb.blue << 16 | rgb.green << 8 | rgb.red);
    }

    public static RGB integerToRGB(Integer color) {
        int n = color;
        return new RGB(n & 0xFF, (n & 0xFF00) >> 8, (n & 0xFF0000) >> 16);
    }

    public static Point getLocation(int pos, Rectangle topos, Rectangle constraint) {
        Rectangle b = constraint.getCopy();
        Point svb = new Point(b.x, b.y);
        switch (pos) {
            case 1: {
                svb.x += b.width / 2;
                break;
            }
            case 4: {
                svb.x += b.width / 2;
                svb.y += b.height;
                break;
            }
            case 8: {
                svb.y += b.height / 2 - topos.height / 2;
                break;
            }
            case 16: {
                svb.x += b.width;
                svb.y += b.height / 2 - topos.height / 2;
                break;
            }
            case 17: {
                svb.x += b.width - topos.width;
                break;
            }
            case 20: {
                svb.x += b.width - topos.width;
                svb.y += b.height - topos.height;
                break;
            }
            case 12: {
                svb.x += b.width;
                svb.y += topos.height;
                break;
            }
            case 5: 
            case 24: {
                svb.x += b.width / 2 - topos.width / 2;
                svb.y += b.height / 2 - topos.height / 2;
                break;
            }
        }
        return svb;
    }

    public static Point getLocation(int pos, Dimension dim, Rectangle constraint) {
        return FigureUtilities.getLocation(pos, new Rectangle(0, 0, dim.width, dim.height), constraint);
    }

    /*
     * Unable to fully structure code
     */
    public static void paintGridWithStyle(Graphics g, IFigure f, Point origin, int distanceX, int distanceY, int lineStyle, int[] dashes) {
        block10: {
            block11: {
                block8: {
                    block9: {
                        clip = g.getClip(Rectangle.SINGLETON);
                        origLineStyle = g.getLineStyle();
                        if (distanceX <= 0) break block8;
                        if (origin.x < clip.x) ** GOTO lbl10
                        while (origin.x - distanceX >= clip.x) {
                            origin.x -= distanceX;
                        }
                        break block9;
lbl-1000:
                        // 1 sources

                        {
                            origin.x += distanceX;
lbl10:
                            // 2 sources

                            ** while (origin.x < clip.x)
                        }
                    }
                    i = origin.x;
                    while (i < clip.x + clip.width) {
                        g.setLineStyle(lineStyle);
                        if (dashes != null && lineStyle == 6) {
                            g.setLineDash(dashes);
                        }
                        g.drawLine(i, clip.y, i, clip.y + clip.height);
                        g.setLineStyle(origLineStyle);
                        i += distanceX;
                    }
                }
                if (distanceY <= 0) break block10;
                if (origin.y < clip.y) ** GOTO lbl29
                while (origin.y - distanceY >= clip.y) {
                    origin.y -= distanceY;
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    origin.y += distanceY;
lbl29:
                    // 2 sources

                    ** while (origin.y < clip.y)
                }
            }
            i = origin.y;
            while (i < clip.y + clip.height) {
                g.setLineStyle(lineStyle);
                if (dashes != null && lineStyle == 6) {
                    g.setLineDash(dashes);
                }
                g.drawLine(clip.x, i, clip.x + clip.width, i);
                g.setLineStyle(origLineStyle);
                i += distanceY;
            }
        }
    }

    public static Rectangle getAnchorableFigureBounds(IFigure figure) {
        if (figure instanceof IOvalAnchorableFigure) {
            return ((IOvalAnchorableFigure)figure).getOvalBounds().getCopy();
        }
        if (figure instanceof IPolygonAnchorableFigure) {
            return ((IPolygonAnchorableFigure)figure).getPolygonPoints().getBounds();
        }
        if (figure instanceof IFigure) {
            return figure.getBounds().getCopy();
        }
        return null;
    }
}

