/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.gmf.runtime.emf.type.core.ClientContext;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IAdviceBindingDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.MultiClientContext;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.DefaultClientContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTypeUtil {
    public static final int NONE = 0;
    public static final int ADVICE_BINDINGS = 1;
    public static final int SPECIALIZATIONS = 2;
    public static final int CLIENT_CONTEXTS = 4;
    public static final int ALL_DEPENDENTS = 7;

    private ElementTypeUtil() {
    }

    public static boolean deregister(IElementType elementType, int flags) {
        ISpecializationType[] specializations;
        if ((flags & 2) != 0 && (specializations = ElementTypeRegistry.getInstance().getSpecializationsOf(elementType.getId())).length > 0) {
            int recursiveFlags = flags & 0xFFFFFFFD;
            for (ISpecializationType next : ElementTypeUtil.sortBySpecialization(Arrays.asList(specializations))) {
                ElementTypeUtil.deregister(next, recursiveFlags);
            }
        }
        if ((flags & 1) != 0) {
            ElementTypeUtil.removeAdviceBindings(elementType);
        }
        if ((flags & 4) != 0) {
            ElementTypeUtil.unbindIDFromAllContexts(elementType.getId());
        }
        return ElementTypeRegistry.getInstance().deregister(elementType);
    }

    private static void removeAdviceBindings(IElementType elementType) {
        String typeID = elementType.getId();
        HashSet<IEditHelperAdviceDescriptor> advicesToRemove = new HashSet<IEditHelperAdviceDescriptor>();
        ElementTypeRegistry reg = ElementTypeRegistry.getInstance();
        Iterator<IEditHelperAdviceDescriptor> advices = reg.getSpecializationTypeRegistry().getAdviceBindings(typeID);
        while (advices.hasNext()) {
            IAdviceBindingDescriptor next = advices.next();
            if (!typeID.equals(next.getTypeId())) continue;
            advicesToRemove.add((IEditHelperAdviceDescriptor)next);
        }
        for (IAdviceBindingDescriptor next : advicesToRemove) {
            reg.deregisterAdvice(next);
        }
    }

    public static <T extends IElementType> Set<T> deregisterElementTypes(Iterable<T> elementTypes, int flags) {
        HashSet<IElementType> result = new HashSet<IElementType>();
        for (IElementType next : ElementTypeUtil.sortBySpecialization(elementTypes)) {
            if (ElementTypeUtil.deregister(next, flags) || ElementTypeRegistry.getInstance().getType(next.getId()) == null) continue;
            result.add(next);
        }
        return result;
    }

    public static <T extends IElementType> List<T> sortBySpecialization(Iterable<T> elementTypes) {
        return ElementTypeUtil.toposort(elementTypes, ElementTypeUtil.bySpecialization());
    }

    private static Comparator<IElementType> bySpecialization() {
        return new Comparator<IElementType>(){

            @Override
            public int compare(IElementType o1, IElementType o2) {
                int result = 0;
                if (!o1.equals(o2)) {
                    ISpecializationType s2;
                    if (o1 instanceof ISpecializationType) {
                        ISpecializationType s1 = (ISpecializationType)o1;
                        if (s1.isSpecializationOf(o2)) {
                            result = -1;
                        } else if (o2 instanceof ISpecializationType && ((ISpecializationType)o2).isSpecializationOf(o1)) {
                            result = 1;
                        }
                    } else if (o2 instanceof ISpecializationType && (s2 = (ISpecializationType)o2).isSpecializationOf(o1)) {
                        result = 1;
                    }
                }
                return result;
            }
        };
    }

    private static <T> List<T> toposort(Iterable<T> items, Comparator<? super T> partOrder) {
        LinkedList<T> unsorted = new LinkedList<T>();
        for (T next : items) {
            unsorted.add(next);
        }
        ArrayList result = new ArrayList(unsorted.size());
        while (!unsorted.isEmpty()) {
            Object min = unsorted.remove(0);
            ListIterator iter = unsorted.listIterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (partOrder.compare(next, min) >= 0) continue;
                iter.set(min);
                min = next;
            }
            result.add(min);
        }
        return result;
    }

    public static void unbindIDFromAllContexts(String typeID) {
        ((ClientContext)DefaultClientContext.getInstance()).unbindId(typeID);
        for (Object next : ClientContextManager.getInstance().getClientContexts()) {
            if (next instanceof ClientContext) {
                ((ClientContext)next).unbindId(typeID);
                continue;
            }
            if (!(next instanceof MultiClientContext)) continue;
            ((MultiClientContext)next).unbindId(typeID);
        }
    }

    public static void unbindPatternFromAllContexts(Pattern pattern) {
        ((ClientContext)DefaultClientContext.getInstance()).unbindPattern(pattern);
        for (Object next : ClientContextManager.getInstance().getClientContexts()) {
            if (next instanceof ClientContext) {
                ((ClientContext)next).unbindPattern(pattern);
                continue;
            }
            if (!(next instanceof MultiClientContext)) continue;
            ((MultiClientContext)next).unbindPattern(pattern);
        }
    }
}

