/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.ide.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.marker.GotoMarkerOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.ui.providers.marker.AbstractModelMarkerNavigationProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractDiagramMarkerNavigationProvider
extends AbstractModelMarkerNavigationProvider {
    protected final IDiagramWorkbenchPart getDiagramEditor() {
        if (this.getEditor() instanceof IDiagramWorkbenchPart) {
            return (IDiagramWorkbenchPart)this.getEditor();
        }
        return null;
    }

    protected final List convertIdsToViews(List elementIds) {
        ArrayList<View> result = new ArrayList<View>();
        Iterator iter = elementIds.iterator();
        Diagram diagramView = this.getDiagramEditor().getDiagram();
        while (iter.hasNext()) {
            Object elementId = iter.next();
            if (!(elementId instanceof String) || diagramView == null) continue;
            ArrayList<Diagram> viewList = new ArrayList<Diagram>();
            viewList.add(diagramView);
            View view = this.recursiveConvertIdToView((String)elementId, viewList);
            if (view == null) continue;
            result.add(view);
        }
        return result;
    }

    private View recursiveConvertIdToView(String elementId, List viewList) {
        View view = null;
        ArrayList tmpList = new ArrayList();
        for (View tmpView : viewList) {
            view = ViewUtil.getChildByIdStr((View)tmpView, (String)elementId);
            if (view != null) {
                return view;
            }
            view = this.getViewByIdStr(elementId, ViewUtil.getSourceConnections((View)tmpView));
            if (view != null) {
                return view;
            }
            view = this.getViewByIdStr(elementId, ViewUtil.getTargetConnections((View)tmpView));
            if (view != null) {
                return view;
            }
            tmpList.addAll(tmpView.getChildren());
            if (view == null) continue;
            return view;
        }
        if (tmpList.size() == 0) {
            return null;
        }
        return this.recursiveConvertIdToView(elementId, tmpList);
    }

    private View getViewByIdStr(String elementId, List edges) {
        for (Edge connection : edges) {
            String id = ((XMLResource)connection.eResource()).getID((EObject)connection);
            if (!elementId.equals(id)) continue;
            return connection;
        }
        return null;
    }

    protected final List findEditParts(List views) {
        Map editPartRegistry = this.getDiagramEditor().getDiagramGraphicalViewer().getEditPartRegistry();
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        ListIterator iterator = views.listIterator();
        while (iterator.hasNext()) {
            EditPart part = (EditPart)editPartRegistry.get(iterator.next());
            if (part == null) continue;
            result.add(part);
        }
        return result;
    }

    public boolean provides(IOperation operation) {
        return operation instanceof GotoMarkerOperation && ((GotoMarkerOperation)operation).getEditor() instanceof IDiagramWorkbenchPart;
    }
}

