/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.command;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.internal.l10n.CommonCoreMessages;

public final class CommandResult {
    private final Object returnValue;
    private final IStatus status;

    public static final CommandResult newOKCommandResult() {
        return new CommandResult((IStatus)new Status(0, CommonCorePlugin.getPluginId(), 0, "", null), null);
    }

    public static final CommandResult newOKCommandResult(Object result) {
        return new CommandResult((IStatus)new Status(0, CommonCorePlugin.getPluginId(), 0, "", null), result);
    }

    public static final CommandResult newCancelledCommandResult() {
        return new CommandResult((IStatus)new Status(8, CommonCorePlugin.getPluginId(), 6, CommonCoreMessages.AbstractCommand__INFO__cancelOperation, null), null);
    }

    public static final CommandResult newErrorCommandResult(String errorMessage) {
        return new CommandResult((IStatus)new Status(4, CommonCorePlugin.getPluginId(), 4, errorMessage, null), null);
    }

    public static final CommandResult newErrorCommandResult(Throwable throwable) {
        return new CommandResult((IStatus)new Status(4, CommonCorePlugin.getPluginId(), 4, throwable.getLocalizedMessage(), throwable), null);
    }

    public static final CommandResult newWarningCommandResult(String warningMessage, Object result) {
        return new CommandResult((IStatus)new Status(2, CommonCorePlugin.getPluginId(), 0, warningMessage, null), result);
    }

    public CommandResult(IStatus status) {
        this(status, null);
    }

    public CommandResult(IStatus status, Object returnValue) {
        assert (status != null) : "null status";
        this.status = status;
        this.returnValue = returnValue;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }
}

