/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.common.ui.contentassist.ContentAssistantHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.tools.DirectEditManagerBase;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.WrapTextCellEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class TextDirectEditManager
extends DirectEditManagerBase {
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;

    public TextDirectEditManager(ITextAwareEditPart source) {
        super(source);
    }

    public TextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        return TextDirectEditManager.getCellEditorLocator(source);
    }

    public static Class getTextCellEditorClass(GraphicalEditPart source) {
        IFigure figure = source.getFigure();
        if (figure instanceof WrapLabel && ((WrapLabel)figure).isTextWrapped()) {
            return WrapTextCellEditor.class;
        }
        return TextCellEditorEx.class;
    }

    @Override
    protected CellEditor doCreateCellEditorOn(Composite composite) {
        ILabelDelegate label = (ILabelDelegate)this.getEditPart().getAdapter(ILabelDelegate.class);
        if (label != null && label.isTextWrapOn()) {
            int style = 66;
            switch (label.getTextJustification()) {
                case 1: {
                    style |= 0x4000;
                    break;
                }
                case 4: {
                    style |= 0x20000;
                    break;
                }
                case 2: {
                    style |= 0x1000000;
                    break;
                }
            }
            return new WrapTextCellEditor(composite, style);
        }
        return new TextCellEditorEx(composite);
    }

    @Override
    public void setEditText(String toEdit) {
        super.setEditText(toEdit);
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        Text textControl = (Text)cellEditor.getControl();
        textControl.setSelection(toEdit.length());
    }

    @Override
    protected void createContentAssistant(Control control, Color proposalPopupForegroundColor, Color proposalPopupBackgroundColor, IContentAssistProcessor processor) {
        ContentAssistantHelper.createTextContentAssistant((Text)((Text)control), (Color)proposalPopupForegroundColor, (Color)proposalPopupBackgroundColor, (IContentAssistProcessor)processor);
    }

    @Override
    protected void initCellEditor() {
        super.initCellEditor();
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    @Override
    protected void bringDown() {
        super.bringDown();
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
    }

    private void saveCurrentActions(IActionBars _actionBars) {
        this.copy = _actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = _actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = _actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = _actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = _actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = _actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = _actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = _actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void restoreSavedActions(IActionBars _actionBars) {
        _actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        _actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        _actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        _actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        _actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        _actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        _actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        _actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }
}

