/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.List;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;

public class GraphDefLookup {
    private final Canvas myCanvas;

    public GraphDefLookup(Canvas canvas) {
        this.myCanvas = canvas;
    }

    public Node findSuitableNode(NodeMapping nm) {
        String name = nm.getDomainMetaElement() == null ? null : nm.getDomainMetaElement().getName();
        return (Node)this.doSearch((List)this.myCanvas.getNodes(), name);
    }

    public Connection findSuitableLink(LinkMapping lm) {
        String name = null;
        if (lm.getDomainMetaElement() != null) {
            name = lm.getDomainMetaElement().getName();
        } else if (lm.getLinkMetaFeature() != null) {
            name = lm.getLinkMetaFeature().getEContainingClass().getName();
        }
        return (Connection)this.doSearch((List)this.myCanvas.getConnections(), name);
    }

    private DiagramElement doSearch(List elements, String namePart) {
        DiagramElement c;
        if (elements.isEmpty()) {
            return null;
        }
        if (namePart != null && (c = this.matchName(elements, namePart)) != null) {
            return c;
        }
        return (DiagramElement)elements.get(0);
    }

    private DiagramElement matchName(List elements, String namePart) {
        for (DiagramElement next : elements) {
            if (next.getName() == null || next.getName().indexOf(namePart) < 0) continue;
            return next;
        }
        return null;
    }
}

