/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gmf.internal.bridge.ui.Plugin;

public class TransformOptions
extends AbstractPreferenceInitializer {
    public static final String PREF_GENERATE_RCP = "generate_rcp";
    public static final String PREF_USE_MAP_MODE = "use_map_mode";
    public static final String PREF_USE_RUNTIME_FIGURES = "use_runtime_figures";
    private static String[] PROP_NAMES = new String[]{"generate_rcp", "use_map_mode", "use_runtime_figures"};
    private Preferences myPreferences;

    public TransformOptions() {
        this.reset();
    }

    private Preferences getPreferences() {
        if (this.myPreferences == null) {
            this.myPreferences = new Preferences();
        }
        return this.myPreferences;
    }

    public void reset() {
        Preferences pluginPrefs = Plugin.getDefault().getPluginPreferences();
        this.copyPreferences(pluginPrefs, this.getPreferences());
    }

    public void flush() {
        Preferences pluginPrefs = Plugin.getDefault().getPluginPreferences();
        this.copyPreferences(this.getPreferences(), pluginPrefs);
        Plugin.getDefault().savePluginPreferences();
    }

    private void copyPreferences(Preferences source, Preferences target) {
        int i = 0;
        while (i < PROP_NAMES.length) {
            String name = PROP_NAMES[i];
            String value = source.getString(name);
            target.setValue(name, value);
            ++i;
        }
    }

    public boolean getGenerateRCP() {
        return this.getPreferences().getBoolean(PREF_GENERATE_RCP);
    }

    public boolean getUseMapMode() {
        return this.getPreferences().getBoolean(PREF_USE_MAP_MODE);
    }

    public boolean getUseRuntimeFigures() {
        return this.getPreferences().getBoolean(PREF_USE_RUNTIME_FIGURES);
    }

    public void setGenerateRCP(boolean value) {
        this.getPreferences().setValue(PREF_GENERATE_RCP, value);
    }

    public void setUseMapMode(boolean value) {
        this.getPreferences().setValue(PREF_USE_MAP_MODE, value);
    }

    public void setUseRuntimeFigures(boolean value) {
        this.getPreferences().setValue(PREF_USE_RUNTIME_FIGURES, value);
    }

    public void initializeDefaultPreferences() {
        DefaultScope scope = new DefaultScope();
        IEclipsePreferences node = scope.getNode(Plugin.getPluginID());
        node.putBoolean(PREF_GENERATE_RCP, false);
        node.putBoolean(PREF_USE_MAP_MODE, true);
        node.putBoolean(PREF_USE_RUNTIME_FIGURES, true);
    }

    static boolean checkLiteOptionPresent() {
        return Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") != null;
    }
}

