/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.transform.GMFGenNewFileCreationPage;
import org.eclipse.gmf.internal.bridge.transform.GenModelConfigurationPage;
import org.eclipse.gmf.internal.bridge.transform.MapModelConfigurationPage;
import org.eclipse.gmf.internal.bridge.transform.MapModelDiagnosticPage;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.ViewmapProducerWizardPage;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.common.URIUtil;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class TransformToGenModelWizard
extends Wizard
implements IWorkbenchWizard {
    private static final String PAGE_ID_GMFGEN = "gmfgen";
    private static final String PAGE_ID_GENMODEL = "genmodel";
    private static final String PAGE_ID_GMFMAP = "gmfmap";
    private static final String PAGE_ID_GMFMAP_DIAGNOSTIC = "gmfmap_diagnostic";
    private static final String PAGE_ID_TRANSFORM = "transform";
    private IStructuredSelection mySelection;
    private GMFGenNewFileCreationPage newFileCreationPage;
    private MapModelConfigurationPage mapModelPage;
    private MapModelDiagnosticPage mapDiagnosticPage;
    private GenModelConfigurationPage genModelPage;
    private ViewmapProducerWizardPage transformOptionPage;
    private WizardPage myErrorContainer;
    private TransformToGenModelOperation myOperation;
    ResourceSet resourceSet;

    public void addPages() {
        super.addPages();
        this.newFileCreationPage = new GMFGenNewFileCreationPage(PAGE_ID_GMFGEN, this.mySelection);
        this.newFileCreationPage.setTitle(Messages.TransformToGenModelWizard_title_gmfgen);
        this.newFileCreationPage.setDescription(Messages.TransformToGenModelWizard_descr_gmfgen);
        IFile file = WizardUtil.findExistingFile(this.mySelection, PAGE_ID_GMFGEN);
        if (file != null) {
            this.newFileCreationPage.setFileName(file.getName());
        } else {
            this.newFileCreationPage.setFileName(WizardUtil.getDefaultFileName(this.mySelection, "My", PAGE_ID_GMFGEN));
        }
        this.addPage((IWizardPage)this.newFileCreationPage);
        this.resourceSet = new ResourceSetImpl();
        ResourceLocationProvider rlp = new ResourceLocationProvider((ISelection)this.mySelection);
        this.mapModelPage = new MapModelConfigurationPage(PAGE_ID_GMFMAP, rlp, this.resourceSet);
        this.mapModelPage.setTitle(Messages.TransformToGenModelWizard_title_mapmodel);
        this.mapModelPage.setDescription(Messages.TransformToGenModelWizard_descr_mapmodel);
        this.mapModelPage.setPageComplete(false);
        this.mapModelPage.setModelRequired(true);
        this.addPage((IWizardPage)this.mapModelPage);
        this.mapDiagnosticPage = new MapModelDiagnosticPage(PAGE_ID_GMFMAP_DIAGNOSTIC);
        this.mapDiagnosticPage.setTitle(Messages.TransformToGenModelWizard_title_mapdiagnostic);
        this.mapDiagnosticPage.setDescription(Messages.TransformToGenModelWizard_descr_mapdiagnostic);
        this.addPage((IWizardPage)this.mapDiagnosticPage);
        this.genModelPage = new GenModelConfigurationPage(PAGE_ID_GENMODEL, rlp, this.resourceSet);
        this.genModelPage.setTitle(Messages.TransformToGenModelWizard_title_genmodel);
        this.genModelPage.setDescription(Messages.TransformToGenModelWizard_descr_genmodel);
        this.genModelPage.setPageComplete(false);
        this.genModelPage.setModelRequired(false);
        this.addPage((IWizardPage)this.genModelPage);
        this.transformOptionPage = new ViewmapProducerWizardPage(PAGE_ID_TRANSFORM);
        this.transformOptionPage.setTitle(Messages.TransformToGenModelWizard_title_options);
        this.transformOptionPage.setDescription(Messages.TransformToGenModelWizard_descr_options);
        this.transformOptionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.transformOptionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.myErrorContainer != null) {
            this.myErrorContainer.setErrorMessage(null);
            this.myErrorContainer = null;
        }
        if (page == this.mapModelPage) {
            Diagnostic diagnostic = this.getTransformOperation().getMapmodelValidationResult();
            if (4 == diagnostic.getSeverity()) {
                this.findNextPageAfterMapping();
                return this.mapDiagnosticPage;
            }
            return this.findNextPageAfterMapping();
        }
        if (page == this.mapDiagnosticPage) {
            return this.findNextPageAfterMapping();
        }
        return super.getNextPage(page);
    }

    private IWizardPage findNextPageAfterMapping() {
        try {
            GenModel genmmodel = this.getTransformOperation().findGenmodel(this.resourceSet);
            if (genmmodel == null) {
                this.genModelPage.setPageComplete(true);
                return this.transformOptionPage;
            }
        }
        catch (CoreException e) {
            this.genModelPage.setStatusMessage(e.getStatus());
        }
        return this.genModelPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mySelection = selection;
        this.setWindowTitle(Messages.TransformToGenModelWizard_title_wizard);
        this.setNeedsProgressMonitor(true);
        this.myOperation = new TransformToGenModelOperation();
    }

    public boolean performFinish() {
        IStatus[] s;
        block5: {
            s = new IStatus[1];
            IRunnableWithProgress iwr = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    TransformToGenModelOperation op = TransformToGenModelWizard.this.getTransformOperation();
                    IFile target = TransformToGenModelWizard.this.getTargetFile();
                    op.setGenURI(URI.createPlatformResourceURI((String)target.getFullPath().toString(), (boolean)true));
                    s[0] = op.executeTransformation(TransformToGenModelWizard.this.resourceSet, monitor);
                }
            };
            this.getContainer().run(false, false, iwr);
            if (!s[0].isOK()) break block5;
            this.setErrorMessage(null);
            this.saveTransformOptions();
            return true;
        }
        try {
            this.setErrorMessage(s[0].getMessage());
            return false;
        }
        catch (InvocationTargetException ex) {
            String message = Messages.TransformToGenModelOperation_e_generator_creation;
            Throwable targetException = ex.getTargetException();
            if (targetException != null && targetException.getMessage() != null) {
                message = targetException.getMessage();
            }
            this.setErrorMessage(message);
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.setErrorMessage(Messages.TransformToGenModelWizard_e_operation_cancelled);
            return false;
        }
    }

    private void saveTransformOptions() {
        if (this.getTransformOperation() != null) {
            this.getTransformOperation().getOptions().flush();
        }
    }

    public boolean performCancel() {
        if (this.getTransformOperation() != null) {
            this.getTransformOperation().getOptions().reset();
        }
        return super.performCancel();
    }

    TransformToGenModelOperation getTransformOperation() {
        return this.myOperation;
    }

    IFile getTargetFile() {
        return this.newFileCreationPage.getModelFile();
    }

    IFile getMapFile() {
        URI mapURI = this.mapModelPage.getURI();
        if (mapURI != null) {
            return URIUtil.getFile((URI)mapURI);
        }
        return (IFile)this.mySelection.getFirstElement();
    }

    private void setErrorMessage(String message) {
        WizardDialog wd = (WizardDialog)this.getContainer();
        WizardPage wp = (WizardPage)wd.getCurrentPage();
        if (wp != null) {
            this.myErrorContainer = wp;
            this.myErrorContainer.setErrorMessage(message);
        }
    }
}

