/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.gmf.ecore.navigator.EcoreAbstractNavigatorItem;
import org.eclipse.gmf.ecore.navigator.EcoreNavigatorGroup;
import org.eclipse.gmf.ecore.navigator.EcoreNavigatorItem;
import org.eclipse.gmf.ecore.part.EcoreVisualIDRegistry;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class EcoreNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        View view;
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)GMFEditingDomainFactory.INSTANCE.createEditingDomain();
            editingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

                public Object get(Object key) {
                    if (!this.containsKey(key)) {
                        this.put(key, Boolean.TRUE);
                    }
                    return super.get(key);
                }
            });
            ResourceSet resourceSet = editingDomain.getResourceSet();
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = resourceSet.getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "Ecore"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof EcoreNavigatorGroup) {
            EcoreNavigatorGroup group = (EcoreNavigatorGroup)parentElement;
            return group.getChildren();
        }
        if (parentElement instanceof EcoreNavigatorItem) {
            EcoreNavigatorItem navigatorItem = (EcoreNavigatorItem)parentElement;
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        if (parentElement instanceof IAdaptable && (view = (View)((IAdaptable)parentElement).getAdapter(View.class)) != null) {
            return this.getViewChildren(view, parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (EcoreVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                result.addAll(this.getForeignShortcuts((Diagram)view, parentElement));
                EcoreNavigatorGroup links = new EcoreNavigatorGroup("links", "icons/linksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                links.addChildren(this.createNavigatorItems(connectedViews, links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                links.addChildren(this.createNavigatorItems(connectedViews, links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                links.addChildren(this.createNavigatorItems(connectedViews, links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4004));
                links.addChildren(this.createNavigatorItems(connectedViews, links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 2001: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup outgoinglinks = new EcoreNavigatorGroup("outgoing links", "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7001));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4004));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4004));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2002: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7006));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7007));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7008));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2003: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup outgoinglinks = new EcoreNavigatorGroup("outgoing links", "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7009));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2004: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7010));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2005: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7011));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(7012));
                connectedViews = this.getChildrenByType(connectedViews, EcoreVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3001: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3002: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3003: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup outgoinglinks = new EcoreNavigatorGroup("outgoing links", "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3004: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup outgoinglinks = new EcoreNavigatorGroup("outgoing links", "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4004));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4004));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3005: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3006: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3007: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3009: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup incominglinks = new EcoreNavigatorGroup("incoming links", "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 4001: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup target = new EcoreNavigatorGroup("target", "icons/linkTargetNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup source = new EcoreNavigatorGroup("source", "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2004));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3001));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3002));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3003));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3004));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3005));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3006));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3009));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2003));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3003));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4002: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup target = new EcoreNavigatorGroup("target", "icons/linkTargetNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup source = new EcoreNavigatorGroup("source", "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2004));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3004));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3006));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3004));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4003: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup target = new EcoreNavigatorGroup("target", "icons/linkTargetNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup source = new EcoreNavigatorGroup("source", "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2004));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2005));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3004));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3006));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3004));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4004: {
                ArrayList<EcoreNavigatorGroup> result = new ArrayList<EcoreNavigatorGroup>();
                EcoreNavigatorGroup target = new EcoreNavigatorGroup("target", "icons/linkTargetNavigatorGroup.gif", parentElement);
                EcoreNavigatorGroup source = new EcoreNavigatorGroup("source", "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3004));
                target.addChildren(this.createNavigatorItems(connectedViews, target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), EcoreVisualIDRegistry.getType(3004));
                source.addChildren(this.createNavigatorItems(connectedViews, source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Ecore".equals(EcoreVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<EcoreNavigatorItem> result = new ArrayList<EcoreNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new EcoreNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    private Collection getForeignShortcuts(Diagram diagram, Object parent) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : diagram.getChildren()) {
            if (this.isOwnView(nextView) || nextView.getEAnnotation("Shortcut") == null) continue;
            result.add(nextView);
        }
        return this.createNavigatorItems(result, parent, false);
    }

    public Object getParent(Object element) {
        if (element instanceof EcoreAbstractNavigatorItem) {
            EcoreAbstractNavigatorItem abstractNavigatorItem = (EcoreAbstractNavigatorItem)element;
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

