/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.elementselection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.AbstractMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.ElementSelectionServiceJob;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionInput;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionListener;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IElementSelectionProvider;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObject;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.IMatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEvent;
import org.eclipse.gmf.runtime.common.ui.services.elementselection.MatchingObjectEventType;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesPlugin;
import org.eclipse.gmf.runtime.common.ui.services.internal.elementselection.ElementSelectionList;
import org.eclipse.gmf.runtime.common.ui.services.internal.elementselection.MatchingObjectsOperation;
import org.eclipse.gmf.runtime.common.ui.services.internal.l10n.CommonUIServicesMessages;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class ElementSelectionService
extends Service
implements IElementSelectionProvider,
IElementSelectionListener {
    private Map jobs2Data = new HashMap();
    private static final ElementSelectionService instance = new ElementSelectionService();
    public static final IJobManager jobManager;

    static {
        instance.configureProviders();
        jobManager = Platform.getJobManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobData getJobData() {
        Job currentJob = jobManager.currentJob();
        assert (currentJob != null);
        if (currentJob == null) {
            return null;
        }
        JobData data = null;
        Map map = this.jobs2Data;
        synchronized (map) {
            data = (JobData)this.jobs2Data.get(currentJob);
        }
        return data;
    }

    protected ElementSelectionService() {
        super(true);
    }

    public static ElementSelectionService getInstance() {
        return instance;
    }

    public List getMatchingObjects(IElementSelectionInput input) {
        return new ElementSelectionList().getMatchingObjects(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementSelectionServiceJob getMatchingObjects(IElementSelectionInput input, IElementSelectionListener listener) {
        ElementSelectionServiceJob job = this.createSelectionJob();
        JobData data = new JobData();
        data.elementSelectionInput = input;
        data.elementSelectionListener = listener;
        job.setName(this.getJobName(data));
        Map map = this.jobs2Data;
        synchronized (map) {
            this.jobs2Data.put(job, data);
        }
        job.schedule();
        return job;
    }

    protected String getJobName() {
        return "";
    }

    protected ElementSelectionServiceJob createSelectionJob() {
        ElementSelectionServiceJob job = new ElementSelectionServiceJob(this.getJobName(), this);
        job.setPriority(20);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) {
        block15: {
            JobData jobData;
            HashMap jobsClone;
            Object provider2;
            JobData data = this.getJobData();
            if (data == null) {
                return;
            }
            ArrayList results = new ArrayList();
            MatchingObjectsOperation operation = new MatchingObjectsOperation(data.elementSelectionInput);
            int i = 0;
            while (i < ExecutionStrategy.PRIORITIES.length) {
                List providers = ExecutionStrategy.FORWARD.getUncachedProviders((Service)this, ExecutionStrategy.PRIORITIES[i], (IOperation)operation);
                results.addAll(providers);
                ++i;
            }
            for (Object provider2 : results) {
                this.addJob(data, (IElementSelectionProvider)provider2);
            }
            provider2 = data;
            synchronized (provider2) {
                jobsClone = (HashMap)data.jobs.clone();
            }
            for (Map.Entry entry : jobsClone.entrySet()) {
                IElementSelectionProvider provider3 = (IElementSelectionProvider)entry.getKey();
                ElementSelectionServiceJob job = (ElementSelectionServiceJob)((Object)entry.getValue());
                this.schedule(provider3, job);
            }
            monitor.beginTask(this.getJobName(data), 1000);
            do {
                jobData = data;
                synchronized (jobData) {
                    if (data.jobs.size() == 0) {
                        break block15;
                    }
                }
                monitor.worked(1);
            } while (!monitor.isCanceled());
            jobData = data;
            synchronized (jobData) {
                data.elementSelectionListener = null;
                this.cancelAllJobs();
            }
        }
        monitor.done();
    }

    protected void schedule(IElementSelectionProvider provider, ElementSelectionServiceJob job) {
        job.schedule();
    }

    public Object resolve(IMatchingObject object) {
        return null;
    }

    protected String getJobName(JobData data) {
        if (this.getJobName() != null && this.getJobName().equals("") && data != null) {
            String providerName = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
            String filter = data.elementSelectionInput.getInput();
            return NLS.bind((String)CommonUIServicesMessages.ElementSelectionService_JobName, (Object[])new String[]{providerName, filter});
        }
        return this.getJobName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(JobData data, IElementSelectionProvider provider) {
        ElementSelectionServiceJob job = provider.getMatchingObjects(data.elementSelectionInput, this);
        Object object = data;
        synchronized (object) {
            data.jobs.put(provider, job);
        }
        object = this.jobs2Data;
        synchronized (object) {
            this.jobs2Data.put(job, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJob(JobData data, IElementSelectionProvider provider) {
        boolean end_of_matches = false;
        Object job = null;
        Object object = data;
        synchronized (object) {
            job = data.jobs.remove(provider);
            if (data.jobs.size() == 0) {
                end_of_matches = true;
            }
        }
        if (end_of_matches) {
            this.fireEndOfMatchesEvent();
        }
        object = this.jobs2Data;
        synchronized (object) {
            this.jobs2Data.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMatchingObjectEvent(final IMatchingObjectEvent matchingObjectEvent) {
        Job currentJob = jobManager.currentJob();
        if (currentJob == null) {
            return;
        }
        JobData data = null;
        Map map = this.jobs2Data;
        synchronized (map) {
            data = (JobData)this.jobs2Data.get(currentJob);
        }
        if (data == null) {
            return;
        }
        final JobData finalData = data;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JobData jobData = finalData;
                synchronized (jobData) {
                    if (finalData.elementSelectionListener != null) {
                        finalData.elementSelectionListener.matchingObjectEvent(matchingObjectEvent);
                    }
                }
            }
        });
    }

    protected void fireEndOfMatchesEvent() {
        AbstractMatchingObject matchingObject = new AbstractMatchingObject(null, null, null, this);
        MatchingObjectEvent matchingObjectEvent = new MatchingObjectEvent(MatchingObjectEventType.END_OF_MATCHES, matchingObject);
        this.fireMatchingObjectEvent(matchingObjectEvent);
    }

    public void matchingObjectEvent(IMatchingObjectEvent matchingObjectEvent) {
        JobData data = this.getJobData();
        if (data == null) {
            return;
        }
        if (matchingObjectEvent.getEventType() == MatchingObjectEventType.END_OF_MATCHES) {
            this.removeJob(data, matchingObjectEvent.getMatchingObject().getProvider());
        } else {
            this.fireMatchingObjectEvent(matchingObjectEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllJobs() {
        HashMap jobsClone;
        JobData data;
        JobData jobData = data = this.getJobData();
        synchronized (jobData) {
            jobsClone = (HashMap)data.jobs.clone();
        }
        for (Map.Entry entry : jobsClone.entrySet()) {
            IElementSelectionProvider provider = (IElementSelectionProvider)entry.getKey();
            ElementSelectionServiceJob job = (ElementSelectionServiceJob)((Object)entry.getValue());
            job.cancel();
            this.removeJob(data, provider);
        }
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected void configureProviders() {
        this.configureProviders(CommonUIServicesPlugin.getPluginId(), "elementSelectionProviders");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJob(ElementSelectionServiceJob job) {
        JobData data = null;
        Object object = this.jobs2Data;
        synchronized (object) {
            data = (JobData)this.jobs2Data.get((Object)job);
        }
        object = data;
        synchronized (object) {
            data.elementSelectionListener = null;
        }
        job.cancel();
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private ActivityFilterProviderDescriptor activityFilter;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.activityFilter = new ActivityFilterProviderDescriptor(element);
        }

        public boolean provides(IOperation operation) {
            return this.activityFilter.provides(operation) && super.provides(operation);
        }
    }

    protected class JobData {
        public IElementSelectionInput elementSelectionInput;
        public IElementSelectionListener elementSelectionListener;
        public HashMap jobs = new HashMap();

        protected JobData() {
        }
    }
}

