/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.listener;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFOperationCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.PersistViewsCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramEventBroker
extends ResourceSetListenerImpl {
    private static String LISTEN_TO_ALL_FEATURES = "*";
    private final NotifierToKeyToListenersSetMap preListeners = new NotifierToKeyToListenersSetMap();
    private final NotifierToKeyToListenersSetMap postListeners = new NotifierToKeyToListenersSetMap();
    private static final Map instanceMap = new WeakHashMap();
    private WeakReference editingDomainRef;
    private static DiagramEventBrokerFactory debFactory = new DiagramEventBrokerFactoryImpl();

    protected DiagramEventBroker() {
        super(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    public static DiagramEventBroker getInstance(TransactionalEditingDomain editingDomain) {
        return DiagramEventBroker.initializeDiagramEventBroker(editingDomain);
    }

    public static void startListening(TransactionalEditingDomain editingDomain) {
        DiagramEventBroker.initializeDiagramEventBroker(editingDomain);
    }

    private static DiagramEventBroker initializeDiagramEventBroker(TransactionalEditingDomain editingDomain) {
        WeakReference<DiagramEventBroker> reference = (WeakReference<DiagramEventBroker>)instanceMap.get(editingDomain);
        if (reference == null) {
            DiagramEventBroker diagramEventBroker = debFactory.createDiagramEventBroker(editingDomain);
            if (diagramEventBroker.editingDomainRef == null) {
                diagramEventBroker.editingDomainRef = new WeakReference<TransactionalEditingDomain>(editingDomain);
            }
            editingDomain.addResourceSetListener((ResourceSetListener)diagramEventBroker);
            reference = new WeakReference<DiagramEventBroker>(diagramEventBroker);
            instanceMap.put(editingDomain, reference);
        }
        return (DiagramEventBroker)((Object)reference.get());
    }

    public static void registerDiagramEventBrokerFactory(DiagramEventBrokerFactory newDebFactory) {
        debFactory = newDebFactory;
    }

    public static void stopListening(TransactionalEditingDomain editingDomain) {
        DiagramEventBroker diagramEventBroker = DiagramEventBroker.getInstance(editingDomain);
        if (diagramEventBroker != null) {
            editingDomain.removeResourceSetListener((ResourceSetListener)diagramEventBroker);
            instanceMap.remove(editingDomain);
        }
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) {
        Set deletedObjects = NotificationUtil.getDeletedObjects(event);
        HashSet<Object> existingObjects = new HashSet<Object>();
        LinkedHashSet elementsInPersistQueue = new LinkedHashSet();
        CompoundCommand cc = new CompoundCommand();
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)this.editingDomainRef.get();
        boolean hasPreListeners = !this.preListeners.isEmpty();
        ArrayList<View> viewsToPersistList = new ArrayList<View>();
        boolean deleteElementCheckRequired = !deletedObjects.isEmpty();
        for (Notification notification : event.getNotifications()) {
            Command cmd;
            View viewToPersist;
            Object notifier;
            if (this.shouldIgnoreNotification(notification) || !((notifier = notification.getNotifier()) instanceof EObject)) continue;
            boolean deleted = false;
            if (deleteElementCheckRequired) {
                boolean bl = deleted = !existingObjects.contains(notifier);
                if (deleted && !(deleted = this.isDeleted(deletedObjects, (EObject)notifier))) {
                    existingObjects.add(notifier);
                }
            }
            if (deleted) continue;
            if (editingDomain != null && (viewToPersist = this.getViewToPersist(notification, elementsInPersistQueue)) != null) {
                viewsToPersistList.add(viewToPersist);
            }
            if (!hasPreListeners || (cmd = this.fireTransactionAboutToCommit(notification)) == null) continue;
            cc.append(cmd);
        }
        if (!viewsToPersistList.isEmpty()) {
            PersistViewsCommand persistCmd = new PersistViewsCommand(editingDomain, viewsToPersistList);
            cc.append((Command)new EMFOperationCommand(editingDomain, (IUndoableOperation)persistCmd));
        }
        return cc.isEmpty() ? null : cc;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (this.postListeners.isEmpty()) {
            return;
        }
        Set deletedObjects = NotificationUtil.getDeletedObjects(event);
        HashSet<Object> existingObjects = new HashSet<Object>();
        boolean deleteElementCheckRequired = !deletedObjects.isEmpty();
        for (Notification notification : event.getNotifications()) {
            Object notifier;
            boolean customNotification = NotificationUtil.isCustomNotification(notification);
            if (!customNotification && this.shouldIgnoreNotification(notification) || !((notifier = notification.getNotifier()) instanceof EObject)) continue;
            boolean deleted = false;
            if (deleteElementCheckRequired && !customNotification) {
                boolean bl = deleted = !existingObjects.contains(notifier);
                if (deleted && !(deleted = this.isDeleted(deletedObjects, (EObject)notifier))) {
                    existingObjects.add(notifier);
                }
            }
            if (!customNotification && deleted) continue;
            this.fireNotification(notification);
        }
    }

    private boolean isDeleted(Set deletedObjects, EObject notifier) {
        EObject object = notifier;
        while (object != null) {
            if (deletedObjects.contains(object)) {
                if (object != notifier) {
                    this.addDeletedBranch(deletedObjects, notifier);
                }
                return true;
            }
            object = object.eContainer();
        }
        return false;
    }

    private void addDeletedBranch(Set deletedObjects, EObject notifier) {
        EObject object = notifier;
        while (object != null) {
            if (!deletedObjects.add(object)) break;
            object = object.eContainer();
        }
    }

    protected boolean shouldIgnoreNotification(Notification notification) {
        return notification.isTouch() && notification.getEventType() != 9 || NotationPackage.eINSTANCE.getView_Mutable().equals(notification.getFeature());
    }

    private void fireNotification(Notification event) {
        Set listenerList = this.getInterestedNotificationListeners(event, this.postListeners);
        if (!listenerList.isEmpty()) {
            for (NotificationListener listener : listenerList) {
                listener.notifyChanged(event);
            }
        }
    }

    private Command fireTransactionAboutToCommit(Notification event) {
        Set listenerList = this.getInterestedNotificationListeners(event, this.preListeners);
        if (!listenerList.isEmpty()) {
            CompoundCommand cc = new CompoundCommand();
            for (NotificationPreCommitListener listener : listenerList) {
                Command cmd = listener.transactionAboutToCommit(event);
                if (cmd == null) continue;
                cc.append(cmd);
            }
            return cc.isEmpty() ? null : cc;
        }
        return null;
    }

    private View getViewToPersist(Notification event, Set elementsInPersistQueue) {
        if (!event.isTouch()) {
            EObject elementToPersist = (EObject)event.getNotifier();
            while (elementToPersist != null && !(elementToPersist instanceof View)) {
                elementToPersist = elementToPersist.eContainer();
            }
            if (elementToPersist != null && !elementsInPersistQueue.contains(elementToPersist) && ViewUtil.isTransient(elementToPersist) && !NotificationFilter.READ.matches(event)) {
                View viewToPersist;
                elementsInPersistQueue.add(elementToPersist);
                View view = (View)elementToPersist;
                if (!view.isMutable() && (viewToPersist = ViewUtil.getTopViewToPersist(view)) != null) {
                    elementsInPersistQueue.add(viewToPersist);
                    return viewToPersist;
                }
            }
        }
        return null;
    }

    public final void addNotificationListener(EObject target, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.addListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void addNotificationListener(EObject target, NotificationListener listener) {
        if (target != null) {
            this.postListeners.addListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void addNotificationListener(EObject target, EStructuralFeature key, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.addListener(target, key, listener);
        }
    }

    public final void addNotificationListener(EObject target, EStructuralFeature key, NotificationListener listener) {
        if (target != null) {
            this.postListeners.addListener(target, key, listener);
        }
    }

    public final void removeNotificationListener(EObject target, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.removeListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void removeNotificationListener(EObject target, NotificationListener listener) {
        if (target != null) {
            this.postListeners.removeListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void removeNotificationListener(EObject target, Object key, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.removeListener(target, key, listener);
        }
    }

    public final void removeNotificationListener(EObject target, Object key, NotificationListener listener) {
        if (target != null) {
            this.postListeners.removeListener(target, key, listener);
        }
    }

    private Set getNotificationListeners(Object notifier, NotifierToKeyToListenersSetMap listeners) {
        return listeners.getListeners(notifier, LISTEN_TO_ALL_FEATURES);
    }

    private Set getNotificationListeners(Object notifier, Object key, NotifierToKeyToListenersSetMap listeners) {
        if (key != null) {
            if (!key.equals(LISTEN_TO_ALL_FEATURES)) {
                LinkedHashSet listenersSet = new LinkedHashSet();
                Set c = listeners.getListeners(notifier, key);
                if (c != null && !c.isEmpty()) {
                    listenersSet.addAll(c);
                }
                if ((c = listeners.getListeners(notifier, LISTEN_TO_ALL_FEATURES)) != null && !c.isEmpty()) {
                    listenersSet.addAll(c);
                }
                return listenersSet;
            }
            if (key.equals(LISTEN_TO_ALL_FEATURES)) {
                return listeners.getAllListeners(notifier);
            }
        }
        return listeners.getAllListeners(notifier);
    }

    protected final Set getInterestedNotificationListeners(Notification event, NotifierToKeyToListenersSetMap listeners) {
        LinkedHashSet listenerSet = new LinkedHashSet();
        Set c = this.getNotificationListeners(event.getNotifier(), event.getFeature(), listeners);
        if (c != null) {
            listenerSet.addAll(c);
        }
        EObject notifier = (EObject)event.getNotifier();
        if (NotationPackage.eINSTANCE.getView_Visible().equals(event.getFeature()) && notifier.eContainer() != null) {
            listenerSet.addAll(this.getNotificationListeners(notifier.eContainer(), listeners));
        } else if (notifier instanceof EAnnotation) {
            this.addListenersOfNotifier(listenerSet, notifier.eContainer(), event, listeners);
        } else if (!(notifier instanceof View)) {
            while (notifier != null && !(notifier instanceof View)) {
                notifier = notifier.eContainer();
            }
            this.addListenersOfNotifier(listenerSet, notifier, event, listeners);
        }
        return listenerSet;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    private void addListenersOfNotifier(Set listenerSet, EObject notifier, Notification event, NotifierToKeyToListenersSetMap listeners) {
        Set c;
        if (notifier != null && (c = this.getNotificationListeners(notifier, event.getFeature(), listeners)) != null) {
            if (listenerSet.isEmpty()) {
                listenerSet.addAll(c);
            } else {
                for (Object o : c) {
                    listenerSet.add(o);
                }
            }
        }
    }

    private final class NotifierToKeyToListenersSetMap {
        private final Map listenersMap = new WeakHashMap();

        private NotifierToKeyToListenersSetMap() {
        }

        public void addListener(EObject notifier, Object key, Object listener) {
            LinkedHashMap<Object, Object> listenersSet;
            HashMap<Object, LinkedHashMap<Object, Object>> keys = (HashMap<Object, LinkedHashMap<Object, Object>>)this.listenersMap.get(notifier);
            if (keys == null) {
                keys = new HashMap<Object, LinkedHashMap<Object, Object>>(4);
                this.listenersMap.put(notifier, keys);
            }
            if ((listenersSet = (LinkedHashMap<Object, Object>)keys.get(key)) == null) {
                listenersSet = new LinkedHashMap<Object, Object>(4);
                keys.put(key, listenersSet);
            }
            listenersSet.put(listener, null);
        }

        public void addListener(EObject notifier, Object listener) {
            this.addListener(notifier, LISTEN_TO_ALL_FEATURES, listener);
        }

        public void removeListener(EObject notifier, Object key, Object listener) {
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys != null) {
                Map listenersSet = (Map)keys.get(key);
                if (listenersSet != null) {
                    listenersSet.remove(listener);
                    if (listenersSet.isEmpty()) {
                        keys.remove(key);
                    }
                }
                if (keys.isEmpty()) {
                    this.listenersMap.remove(notifier);
                }
            }
        }

        public Set getListeners(Object notifier, Object key) {
            Map listenersSet;
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys != null && (listenersSet = (Map)keys.get(key)) != null) {
                return listenersSet.keySet();
            }
            return Collections.EMPTY_SET;
        }

        public Set getAllListeners(Object notifier) {
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys == null || keys.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            LinkedHashSet listenersCollection = new LinkedHashSet();
            Set enteries = keys.entrySet();
            for (Map.Entry entry : enteries) {
                Map listenersSet = (Map)entry.getValue();
                if (listenersSet == null || listenersSet.isEmpty()) continue;
                listenersCollection.addAll(listenersSet.keySet());
            }
            return listenersCollection;
        }

        public boolean isEmpty() {
            return this.listenersMap.isEmpty();
        }
    }

    public static interface DiagramEventBrokerFactory {
        public DiagramEventBroker createDiagramEventBroker(TransactionalEditingDomain var1);
    }

    private static class DiagramEventBrokerFactoryImpl
    implements DiagramEventBrokerFactory {
        private DiagramEventBrokerFactoryImpl() {
        }

        public DiagramEventBroker createDiagramEventBroker(TransactionalEditingDomain editingDomain) {
            DiagramEventBroker diagramEventBroker = new DiagramEventBroker();
            diagramEventBroker.editingDomainRef = new WeakReference<TransactionalEditingDomain>(editingDomain);
            return diagramEventBroker;
        }
    }
}

