/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.internal.common.migrate.MigrationDelegateImpl;

class MigrationDelegate
extends MigrationDelegateImpl {
    private EReference myFigure_RefElements;
    private EAttribute myDiagramElement_RefFigure;
    private Map<String, EObject> myId2EObject;
    private Collection<EObject> myProxiesToResolve;
    private Map<DiagramElement, String> myDiagramElementReferencedFigure;
    private Map<DiagramElement, EObject> myDiagramElementReferencedProxyFigure;
    private Collection<EReference> myRemainedFigureReferences;
    private Map<FigureAccessor, ChildAccess> myAccessNeedsToBeSpecifiedLater;

    MigrationDelegate() {
    }

    void init() {
        GMFGraphPackage graphDefPkg = GMFGraphPackage.eINSTANCE;
        this.registerNarrowedAbstractType("RealFigure", graphDefPkg.getCustomFigure());
        this.registerDeletedAttributes((EClassifier)graphDefPkg.getCustomClass(), new String[]{"bundleName"});
        this.myFigure_RefElements = MigrationDelegate.createNewReference((String)"referencingElementsFake", (EClass)graphDefPkg.getDiagramElement(), (boolean)false);
        this.registerTracedFeatureForHierarchy(graphDefPkg.getFigure(), "referencingElements", (EStructuralFeature)this.myFigure_RefElements);
        this.registerTracedFeatureForHierarchy(graphDefPkg.getFigureAccessor(), "referencingElements", (EStructuralFeature)this.myFigure_RefElements);
        this.myDiagramElement_RefFigure = MigrationDelegate.createNewAttribute((String)"figure", (EDataType)EcorePackage.eINSTANCE.getEString(), (boolean)false);
        this.registerTracedAttributeForHierarchy(graphDefPkg.getDiagramElement(), "figure", (EStructuralFeature)this.myDiagramElement_RefFigure);
        this.myRemainedFigureReferences = Arrays.asList(graphDefPkg.getFigureAccessor_TypedFigure(), graphDefPkg.getPolylineConnection_SourceDecoration(), graphDefPkg.getPolylineConnection_TargetDecoration());
        this.myId2EObject = null;
        this.myProxiesToResolve = null;
        this.myDiagramElementReferencedFigure = null;
    }

    private boolean isOneOfRemainedFigureReferences(EStructuralFeature feature) {
        return this.myRemainedFigureReferences.contains(feature);
    }

    public boolean setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        String figureRef;
        DiagramElement diagramElement;
        if (object instanceof Figure && "name".equals(feature.getName())) {
            String name = (String)value;
            this.saveEObjectIdLocally(object, name);
        }
        if (GMFGraphPackage.eINSTANCE.getFigureAccessor_TypedFigure().equals(feature) && value instanceof RealFigure) {
            RealFigure figure = (RealFigure)value;
            if (figure.eIsProxy()) {
                this.saveReferenceToGetContainmentLater(figure);
                return false;
            }
            if (value instanceof CustomFigure && figure.eContainer() != null) {
                CustomFigure custom = (CustomFigure)value;
                FigureAccessor accessor = (FigureAccessor)object;
                EObject container = custom.eContainer();
                if (!custom.eIsProxy() && container != null) {
                    CustomFigure copy = (CustomFigure)EcoreUtil.copy((EObject)custom);
                    accessor.setTypedFigure(copy);
                    this.fireMigrationApplied(true);
                    return true;
                }
            }
        }
        if (this.myDiagramElement_RefFigure.equals(feature)) {
            diagramElement = (DiagramElement)object;
            figureRef = (String)value;
            this.saveDiagramElementReferencedFigure(diagramElement, figureRef);
            return true;
        }
        if (GMFGraphPackage.eINSTANCE.getDiagramElement_Figure().equals(feature)) {
            diagramElement = (DiagramElement)object;
            figureRef = (EObject)value;
            if (figureRef.eIsProxy()) {
                this.saveDiagramElementReferencedProxy(diagramElement, (EObject)figureRef);
                return true;
            }
        }
        if (this.isOneOfRemainedFigureReferences(feature) && value instanceof FigureDescriptor) {
            FigureDescriptor descriptor = (FigureDescriptor)value;
            Figure figure = descriptor.getActualFigure();
            this.fireMigrationApplied(true);
            if (!this.setValue(object, feature, figure, position)) {
                object.eSet(feature, (Object)figure);
                return true;
            }
        }
        if (!this.myFigure_RefElements.equals(feature)) {
            return super.setValue(object, feature, value, position);
        }
        this.migrateFigureStructureToDescriptor((EObject)value, object);
        return true;
    }

    private void migrateFigureStructureToDescriptor(EObject value, EObject object) {
        if (value.eIsProxy()) {
            value = EcoreUtil.resolve((EObject)value, (EObject)object);
        }
        DiagramElement node = (DiagramElement)value;
        if (object instanceof Figure) {
            Figure figure = (Figure)object;
            RealFigure topLevel = this.findTopLevelFigure(figure);
            this.setFigureToDiagramElement(node, figure, topLevel);
            this.fireMigrationApplied(true);
        } else if (object instanceof FigureAccessor) {
            FigureAccessor accessor = (FigureAccessor)object;
            RealFigure figure = accessor.getTypedFigure();
            RealFigure topLevel = this.findTopLevelFigure((Figure)accessor.eContainer());
            ChildAccess access = this.setFigureToDiagramElement(node, figure, topLevel);
            if (figure == null) {
                this.saveAccessNeedsToBeSpecifiedLater(accessor, access);
            }
            this.fireMigrationApplied(true);
        }
    }

    private void saveAccessNeedsToBeSpecifiedLater(FigureAccessor accessor, ChildAccess access) {
        if (this.myAccessNeedsToBeSpecifiedLater == null) {
            this.myAccessNeedsToBeSpecifiedLater = new HashMap<FigureAccessor, ChildAccess>();
        }
        this.myAccessNeedsToBeSpecifiedLater.put(accessor, access);
    }

    private ChildAccess setFigureToDiagramElement(DiagramElement node, Figure figure, RealFigure topLevel) {
        FigureDescriptor figureDescriptor = topLevel.getDescriptor();
        if (figureDescriptor == null) {
            figureDescriptor = this.getOrCreateFigureDescriptorFor(topLevel);
        }
        node.setFigure(figureDescriptor);
        if (!topLevel.equals(figure)) {
            ChildAccess access = this.getOrCreateChildAccessForNested(figure, figureDescriptor);
            this.setNestedFigureAccessFor(node, access);
            return access;
        }
        return null;
    }

    private void saveDiagramElementReferencedFigure(DiagramElement diagramElement, String figureRef) {
        if (this.myDiagramElementReferencedFigure == null) {
            this.myDiagramElementReferencedFigure = new HashMap<DiagramElement, String>();
        }
        if (figureRef != null && figureRef.length() != 0) {
            this.myDiagramElementReferencedFigure.put(diagramElement, figureRef);
        }
    }

    private void saveDiagramElementReferencedProxy(DiagramElement diagramElement, EObject figureRef) {
        if (this.myDiagramElementReferencedProxyFigure == null) {
            this.myDiagramElementReferencedProxyFigure = new HashMap<DiagramElement, EObject>();
        }
        if (figureRef != null && figureRef.eIsProxy()) {
            this.myDiagramElementReferencedProxyFigure.put(diagramElement, figureRef);
        }
    }

    public boolean setManyReference(EObject object, EStructuralFeature feature, Object[] values) {
        return this.myFigure_RefElements.equals(feature);
    }

    public void preResolve() {
        super.preResolve();
        Resource resource = this.getResource();
        if (this.myId2EObject != null && resource instanceof ResourceImpl) {
            HashMap<String, EObject> idMappings = ((ResourceImpl)resource).getIntrinsicIDToEObjectMap();
            if (idMappings == null) {
                idMappings = new HashMap<String, EObject>();
                ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(idMappings);
            }
            Iterator<Map.Entry<String, EObject>> it = this.myId2EObject.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, EObject> next = it.next();
                String id = next.getKey();
                EObject found = resource.getEObject(id);
                if (found == null) {
                    idMappings.put(id, next.getValue());
                    continue;
                }
                it.remove();
            }
        }
        if (this.myProxiesToResolve != null) {
            for (EObject proxy : this.myProxiesToResolve) {
                String last = EcoreUtil.getURI((EObject)proxy).lastSegment();
                EObject saved = resource.getEObject(last);
                if (!(proxy.eContainer() instanceof FigureAccessor)) continue;
                FigureAccessor accessor = (FigureAccessor)proxy.eContainer();
                if (saved instanceof RealFigure) {
                    RealFigure copyOfResolved = (RealFigure)EcoreUtil.copy((EObject)saved);
                    accessor.setTypedFigure(copyOfResolved);
                    continue;
                }
                if (!(saved instanceof FigureDescriptor)) continue;
                FigureDescriptor descriptor = (FigureDescriptor)saved;
                RealFigure copyOfResolved = (RealFigure)EcoreUtil.copy((EObject)descriptor.getActualFigure());
                accessor.setTypedFigure(copyOfResolved);
            }
            this.myProxiesToResolve.clear();
        }
    }

    public void postLoad() {
        super.postLoad();
        Resource resource = this.getResource();
        if (this.myAccessNeedsToBeSpecifiedLater != null) {
            for (FigureAccessor accessor : this.myAccessNeedsToBeSpecifiedLater.keySet()) {
                ChildAccess access = this.myAccessNeedsToBeSpecifiedLater.get(accessor);
                if (access == null || access.getFigure() != null) continue;
                RealFigure figure = this.getOrCreateTypedFigure(accessor);
                access.setFigure(figure);
            }
            this.myAccessNeedsToBeSpecifiedLater.clear();
        }
        if (this.myDiagramElementReferencedFigure != null) {
            for (DiagramElement diagramElement : this.myDiagramElementReferencedFigure.keySet()) {
                if (diagramElement.getFigure() != null) continue;
                String figureRef = this.myDiagramElementReferencedFigure.get(diagramElement);
                EObject referencedEObject = resource.getEObject(figureRef);
                this.setFigureDescriptorForDiagramElement(referencedEObject, diagramElement);
            }
            this.myDiagramElementReferencedFigure.clear();
        }
        if (this.myDiagramElementReferencedProxyFigure != null) {
            for (DiagramElement diagramElement : this.myDiagramElementReferencedProxyFigure.keySet()) {
                if (diagramElement.getFigure() != null && !diagramElement.getFigure().eIsProxy()) continue;
                EObject proxyFigure = this.myDiagramElementReferencedProxyFigure.get(diagramElement);
                URI proxyURI = EcoreUtil.getURI((EObject)proxyFigure);
                Resource referencedResource = resource.getResourceSet().getResource(proxyURI.trimFragment(), false);
                if (referencedResource == null) {
                    referencedResource = resource.getResourceSet().createResource(proxyURI.trimFragment());
                }
                if (((ResourceImpl)referencedResource).isLoading()) continue;
                EObject referencedEObject = resource.getResourceSet().getEObject(proxyURI, true);
                if (diagramElement.getFigure() != null && !diagramElement.getFigure().eIsProxy()) {
                    this.fireMigrationApplied(true);
                    continue;
                }
                this.setFigureDescriptorForDiagramElement(referencedEObject, diagramElement);
            }
            this.myDiagramElementReferencedProxyFigure.clear();
        }
        if (this.myId2EObject != null) {
            this.myId2EObject.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setFigureDescriptorForDiagramElement(EObject referencedEObject, DiagramElement diagramElement) {
        if (referencedEObject instanceof FigureDescriptor) {
            diagramElement.setFigure((FigureDescriptor)referencedEObject);
            return;
        } else {
            FigureDescriptor descriptor;
            if (!(referencedEObject instanceof Figure)) throw new IllegalArgumentException(MessageFormat.format("Figure reference to {0} could not be resolved for {1}", referencedEObject, diagramElement));
            Figure figure = (Figure)referencedEObject;
            if (figure.getDescriptor() == null) {
                this.setValue(figure, (EStructuralFeature)this.myFigure_RefElements, diagramElement, 0);
                this.fireMigrationApplied(true);
            }
            if ((descriptor = figure.getDescriptor()) == null) throw new IllegalArgumentException(MessageFormat.format("Reference to the figure {0} could not be resolved to its descriptor for diagram element {1}", figure, diagramElement));
            diagramElement.setFigure(descriptor);
        }
    }

    private void saveEObjectIdLocally(EObject object, String id) {
        if (this.myId2EObject == null) {
            this.myId2EObject = new HashMap<String, EObject>();
        }
        if (this.myId2EObject.get(id) == null) {
            this.myId2EObject.put(id, object);
        }
    }

    private void saveReferenceToGetContainmentLater(EObject proxy) {
        if (this.myProxiesToResolve == null) {
            this.myProxiesToResolve = new ArrayList<EObject>();
        }
        this.myProxiesToResolve.add(proxy);
    }

    private RealFigure getOrCreateTypedFigure(FigureAccessor accessor) {
        RealFigure result = accessor.getTypedFigure();
        if (result == null) {
            CustomFigure custom = GMFGraphFactory.eINSTANCE.createCustomFigure();
            custom.setQualifiedClassName("org.eclipse.draw2d.IFigure");
            accessor.setTypedFigure(custom);
            result = custom;
        }
        return result;
    }

    private CustomFigure findParentCustomFigure(FigureAccessor accessor) {
        CustomFigure result = null;
        if (accessor.eContainer() instanceof CustomFigure) {
            result = (CustomFigure)accessor.eContainer();
        }
        return result;
    }

    private void setNestedFigureAccessFor(DiagramElement dElem, ChildAccess access) {
        if (dElem instanceof DiagramLabel) {
            DiagramLabel label = (DiagramLabel)dElem;
            label.setAccessor(access);
        } else if (dElem instanceof Compartment) {
            Compartment bag = (Compartment)dElem;
            bag.setAccessor(access);
        }
    }

    private RealFigure findTopLevelFigure(Figure figure) {
        RealFigure result = figure instanceof RealFigure ? (RealFigure)figure : null;
        EObject container = result.eContainer();
        while (container instanceof RealFigure || container instanceof FigureAccessor) {
            result = container instanceof FigureAccessor ? this.findParentCustomFigure((FigureAccessor)container) : (RealFigure)result.eContainer();
            container = result.eContainer();
        }
        return result;
    }

    private ChildAccess getOrCreateChildAccessForNested(Figure nestedFigure, FigureDescriptor toplevelDescriptor) {
        for (ChildAccess haveAccess : toplevelDescriptor.getAccessors()) {
            if (nestedFigure == null || !nestedFigure.equals(haveAccess.getFigure())) continue;
            return haveAccess;
        }
        ChildAccess result = GMFGraphFactory.eINSTANCE.createChildAccess();
        result.setFigure(nestedFigure);
        toplevelDescriptor.getAccessors().add((Object)result);
        return result;
    }

    private FigureDescriptor getOrCreateFigureDescriptorFor(RealFigure toplevelFigure) {
        FigureDescriptor descriptor = toplevelFigure.getDescriptor();
        if (descriptor == null) {
            EObject container;
            descriptor = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
            if (toplevelFigure.getName() != null) {
                descriptor.setName(toplevelFigure.getName());
            }
            if ((container = toplevelFigure.eContainer()) instanceof FigureGallery) {
                FigureGallery gallery = (FigureGallery)container;
                gallery.getDescriptors().add((Object)descriptor);
            }
            descriptor.setActualFigure(toplevelFigure);
        }
        return descriptor;
    }
}

