/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DocumentEvent;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentListener;

public abstract class AbstractDocument
implements IDocument {
    protected Object content;
    private long fModificationStamp = -1L;
    private List fDocumentListeners;
    private List fPrenotifiedDocumentListeners;
    private int fStoppedListenerNotification = 0;
    private DocumentEvent fDeferredDocumentEvent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public long getModificationStamp() {
        return this.fModificationStamp;
    }

    protected void completeInitialization() {
        this.fDocumentListeners = new ArrayList();
        this.fPrenotifiedDocumentListeners = new ArrayList();
    }

    public void addDocumentListener(IDocumentListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        if (!this.fDocumentListeners.contains(listener)) {
            this.fDocumentListeners.add(listener);
        }
    }

    public void removeDocumentListener(IDocumentListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        this.fDocumentListeners.remove(listener);
    }

    public void addPrenotifiedDocumentListener(IDocumentListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        if (!this.fPrenotifiedDocumentListeners.contains(listener)) {
            this.fPrenotifiedDocumentListeners.add(listener);
        }
    }

    public void removePrenotifiedDocumentListener(IDocumentListener listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        this.fPrenotifiedDocumentListeners.remove(listener);
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object documentContent) {
        this.setContent(documentContent, this.getNextModificationStamp());
    }

    public void setContent(Object documentContent, long modificationStamp) {
        DocumentEvent eventToBeFired = null;
        if (this.content != documentContent) {
            DocumentEvent changed = new DocumentEvent(this, 0, documentContent);
            DocumentEvent changing = new DocumentEvent(this, 0, this.content);
            this.fireDocumentAboutToBeChanged(changed);
            this.content = documentContent;
            changed.fModificationStamp = this.fModificationStamp = modificationStamp;
            changing.fModificationStamp = this.fModificationStamp;
            eventToBeFired = changing;
            this.fireDocumentChanged(changing);
        } else {
            eventToBeFired = new DocumentEvent(this, 1, documentContent);
            this.fireDocumentChanged(eventToBeFired);
        }
    }

    private long getNextModificationStamp() {
        if (this.fModificationStamp == Long.MAX_VALUE || this.fModificationStamp == -1L) {
            return 0L;
        }
        return this.fModificationStamp + 1L;
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
        IDocumentListener l;
        Iterator e;
        ArrayList list;
        if (this.fPrenotifiedDocumentListeners.size() > 0) {
            list = new ArrayList(this.fPrenotifiedDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentAboutToBeChanged(event);
            }
        }
        if (this.fDocumentListeners.size() > 0) {
            list = new ArrayList(this.fDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentAboutToBeChanged(event);
            }
        }
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        if (this.fStoppedListenerNotification == 0) {
            this.doFireDocumentChanged(event);
        } else {
            this.fDeferredDocumentEvent = event;
        }
    }

    protected void doFireDocumentChanged(DocumentEvent event) {
        IDocumentListener l;
        Iterator e;
        ArrayList list;
        if (this.fPrenotifiedDocumentListeners.size() > 0) {
            list = new ArrayList(this.fPrenotifiedDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentChanged(event);
            }
        }
        if (this.fDocumentListeners.size() > 0) {
            list = new ArrayList(this.fDocumentListeners);
            e = list.iterator();
            while (e.hasNext()) {
                l = (IDocumentListener)e.next();
                l.documentChanged(event);
            }
        }
    }

    public void resumeListenerNotification() {
        --this.fStoppedListenerNotification;
        if (this.fStoppedListenerNotification == 0) {
            this.resumeDocumentListenerNotification();
        }
    }

    public void stopListenerNotification() {
        ++this.fStoppedListenerNotification;
    }

    private void resumeDocumentListenerNotification() {
        if (this.fDeferredDocumentEvent != null) {
            DocumentEvent event = this.fDeferredDocumentEvent;
            this.fDeferredDocumentEvent = null;
            this.doFireDocumentChanged(event);
        }
    }
}

