/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.services.decorator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.jface.util.Assert;

public class DecoratorProviderConfiguration
extends AbstractProviderConfiguration {
    private static final String CONTEXT = "context";
    private static final String DECORATOR_TARGETS = "decoratorTargets";
    private List contextDescriptors = new ArrayList();

    public static DecoratorProviderConfiguration parse(IConfigurationElement configElement) {
        Assert.isNotNull((Object)configElement, (String)"null provider configuration element");
        return new DecoratorProviderConfiguration(configElement);
    }

    private DecoratorProviderConfiguration(IConfigurationElement configElement) {
        HashMap<String, AbstractProviderConfiguration.ObjectDescriptor> objects = new HashMap<String, AbstractProviderConfiguration.ObjectDescriptor>();
        IConfigurationElement[] configChildren = configElement.getChildren("object");
        int i = 0;
        while (i < configChildren.length) {
            String id = configChildren[i].getAttribute("id");
            if (id != null) {
                objects.put(id, new AbstractProviderConfiguration.ObjectDescriptor(configChildren[i]));
            }
            ++i;
        }
        configChildren = configElement.getChildren(CONTEXT);
        i = 0;
        while (i < configChildren.length) {
            List decoratorTargets = DecoratorProviderConfiguration.getObjectList((String)configChildren[i].getAttribute(DECORATOR_TARGETS), objects, (IConfigurationElement)configElement);
            if (decoratorTargets != null) {
                this.contextDescriptors.add(new ContextDescriptor(decoratorTargets));
            }
            ++i;
        }
    }

    public boolean supports(IDecoratorTarget decoratorTarget) {
        if (this.contextDescriptors.isEmpty()) {
            return true;
        }
        Iterator iter = this.contextDescriptors.iterator();
        while (iter.hasNext()) {
            ContextDescriptor descriptor = (ContextDescriptor)iter.next();
            if (!descriptor.matches(decoratorTarget)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$0(Object object, List list) {
        return AbstractProviderConfiguration.objectMatches((Object)object, (List)list);
    }

    private static class ContextDescriptor {
        private final List decoratorTargets;

        public ContextDescriptor(List decoratorTargets) {
            this.decoratorTargets = decoratorTargets;
        }

        public boolean matches(IDecoratorTarget decoratorTarget) {
            return this.decoratorTargets == null || DecoratorProviderConfiguration.access$0(decoratorTarget, this.decoratorTargets);
        }
    }
}

