/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LabeledContainer;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.CanvasProcessor;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryMirrorProcessor;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.figures.FigureCheck;
import org.eclipse.gmf.tests.setup.figures.FigureCodegenSetup;
import org.eclipse.gmf.tests.setup.figures.FigureGeneratorUtil;
import org.eclipse.gmf.tests.setup.figures.GenericFigureCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandalonePluginConverterTest
extends TestCase {
    private static final String CUSTOM_FIGURES_PACKAGE = "custom.figures.pakkage";

    public StandalonePluginConverterTest(String name) {
        super(name);
    }

    public void testEachGeneratedClassUsesItsOwnImportAssistant() {
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        gallery.setName("zz");
        gallery.setImplementationBundle("org.eclipse.draw2d");
        CustomFigure usesLayeredPane = GMFGraphFactory.eINSTANCE.createCustomFigure();
        usesLayeredPane.setName("RequiersImportForDraw2dLayeredPane");
        usesLayeredPane.setQualifiedClassName(LayeredPane.class.getName());
        Rectangle layeredPaneItself = GMFGraphFactory.eINSTANCE.createRectangle();
        layeredPaneItself.setName(LayeredPane.class.getSimpleName());
        gallery.getFigures().addAll((Collection)Arrays.asList(usesLayeredPane, layeredPaneItself));
        StandaloneGenerator.Config config = FigureGeneratorUtil.createStandaloneGeneratorConfig(CUSTOM_FIGURES_PACKAGE, false);
        FigureGeneratorUtil.GeneratedClassData[] genResults = FigureGeneratorUtil.generateAndCompile(gallery, config);
        StandalonePluginConverterTest.assertEquals((int)gallery.getFigures().size(), (int)genResults.length);
        int i = 0;
        while (i < genResults.length) {
            FigureGeneratorUtil.GeneratedClassData next = genResults[i];
            FigureCheck.CHECK_CAN_CREATE_INSTANCE.go(next.getLoadedClass());
            ++i;
        }
    }

    public void testStandaloneGalleryConverter() throws Exception {
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        FigureCodegenSetup sss = new FigureCodegenSetup();
        FigureDescriptor[] originals = new FigureDescriptor[]{DiaDefSetup.newDescriptor(sss.getCustomFigure()), DiaDefSetup.newDescriptor(sss.getSimpleShape()), DiaDefSetup.newDescriptor(sss.getComplexShape())};
        gallery.getDescriptors().addAll((Collection)Arrays.asList(originals));
        StandaloneGenerator.Config config = FigureGeneratorUtil.createStandaloneGeneratorConfig(CUSTOM_FIGURES_PACKAGE, false);
        GalleryMirrorProcessor processor = new GalleryMirrorProcessor(new FigureGallery[]{gallery});
        FigureGeneratorUtil.generate(config, (StandaloneGenerator.Processor)processor);
        Map info = processor.getGenerationInfo();
        int i = 0;
        while (i < originals.length) {
            StandalonePluginConverterTest.assertNotNull(info.get(originals[i]));
            ++i;
        }
        FigureGallery mirroredGallery = processor.convertFigureGallery();
        StandalonePluginConverterTest.assertEquals((String)config.getPluginID(), (String)mirroredGallery.getImplementationBundle());
        StandalonePluginConverterTest.assertEquals((int)3, (int)mirroredGallery.getFigures().size());
        for (Figure mirroredFigure : mirroredGallery.getFigures()) {
            StandalonePluginConverterTest.assertTrue((boolean)(mirroredFigure instanceof CustomFigure));
            CustomFigure nextCustom = (CustomFigure)mirroredFigure;
            StandalonePluginConverterTest.assertNotNull((Object)nextCustom.getName());
            StandalonePluginConverterTest.assertTrue((boolean)nextCustom.getQualifiedClassName().startsWith("custom.figures.pakkage."));
        }
        FigureGeneratorUtil.installPlugin(config.getPluginID());
        FigureGeneratorUtil.GeneratedClassData[] mirroredClasses = FigureGeneratorUtil.generateAndCompile(mirroredGallery);
        int i2 = 0;
        while (i2 < originals.length) {
            FigureDescriptor nextOriginal = originals[i2];
            Class<?> nextClass = StandalonePluginConverterTest.searchForFigureName(mirroredClasses, nextOriginal.getName());
            StandalonePluginConverterTest.assertNotNull((String)("Missed class for : " + nextOriginal.getName()), nextClass);
            new GenericFigureCheck(nextOriginal.getActualFigure()).go(nextClass);
            ++i2;
        }
    }

    public void testMirroredDiagramElements() {
        Canvas canvas = GMFGraphFactory.eINSTANCE.createCanvas();
        FigureGallery gallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        canvas.getFigures().add((Object)gallery);
        Label label = GMFGraphFactory.eINSTANCE.createLabel();
        label.setName("GraphLabel");
        PolylineConnection connection = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        connection.setName("GraphConnection");
        Rectangle rectangle = GMFGraphFactory.eINSTANCE.createRectangle();
        rectangle.setName("GraphRectangle");
        LabeledContainer labeledContainer = GMFGraphFactory.eINSTANCE.createLabeledContainer();
        labeledContainer.setName("GraphLabeledContainer");
        Node node = GMFGraphFactory.eINSTANCE.createNode();
        node.setName("DiagramNode");
        node.setFigure(DiaDefSetup.newDescriptor((RealFigure)rectangle));
        DiagramLabel diagramLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        diagramLabel.setName("DiagramLabel");
        diagramLabel.setFigure(DiaDefSetup.newDescriptor((RealFigure)label));
        Connection diagramConnection = GMFGraphFactory.eINSTANCE.createConnection();
        diagramConnection.setName("DiagramConnection");
        diagramConnection.setFigure(DiaDefSetup.newDescriptor((RealFigure)connection));
        Compartment compartment = GMFGraphFactory.eINSTANCE.createCompartment();
        compartment.setName("DiagramCompartment");
        compartment.setNeedsTitle(!compartment.isNeedsTitle());
        compartment.setCollapsible(!compartment.isCollapsible());
        compartment.setFigure(DiaDefSetup.newDescriptor((RealFigure)labeledContainer));
        gallery.getDescriptors().addAll((Collection)Arrays.asList(diagramLabel.getFigure(), diagramConnection.getFigure(), node.getFigure(), compartment.getFigure()));
        canvas.getNodes().add((Object)node);
        canvas.getLabels().add((Object)diagramLabel);
        canvas.getConnections().add((Object)diagramConnection);
        canvas.getCompartments().add((Object)compartment);
        Canvas mirroredCanvas = this.mirror(canvas);
        Checker checker = new Checker();
        checker.check((List<?>)canvas.getNodes(), (List<?>)mirroredCanvas.getNodes());
        checker.check((List<?>)canvas.getCompartments(), (List<?>)mirroredCanvas.getCompartments());
        checker.check((List<?>)canvas.getConnections(), (List<?>)mirroredCanvas.getConnections());
        checker.check((List<?>)canvas.getLabels(), (List<?>)mirroredCanvas.getLabels());
    }

    public void testInnerFigureConversion() {
        Rectangle topFigure = GMFGraphFactory.eINSTANCE.createRectangle();
        topFigure.setName("TopRect");
        CustomFigure customLabel = GMFGraphFactory.eINSTANCE.createCustomFigure();
        customLabel.setQualifiedClassName("org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel");
        customLabel.setName("CustomLabel");
        Label ordinaryLabel = GMFGraphFactory.eINSTANCE.createLabel();
        ordinaryLabel.setText("ordinaryLabel value");
        ordinaryLabel.setName("OrdinaryLabel");
        topFigure.getChildren().add((Object)customLabel);
        topFigure.getChildren().add((Object)ordinaryLabel);
        FigureGallery fg = GMFGraphFactory.eINSTANCE.createFigureGallery();
        fg.setName("a1");
        FigureDescriptor fd = DiaDefSetup.newDescriptor((RealFigure)topFigure);
        fg.getDescriptors().add((Object)fd);
        ChildAccess a1 = GMFGraphFactory.eINSTANCE.createChildAccess();
        fd.getAccessors().add((Object)a1);
        a1.setFigure((Figure)customLabel);
        ChildAccess a2 = GMFGraphFactory.eINSTANCE.createChildAccess();
        fd.getAccessors().add((Object)a2);
        a2.setFigure((Figure)ordinaryLabel);
        Node node = GMFGraphFactory.eINSTANCE.createNode();
        node.setName("Node");
        node.setFigure(fd);
        DiagramLabel l1 = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        l1.setName("l1");
        l1.setFigure(fd);
        l1.setAccessor(a1);
        DiagramLabel l2 = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        l2.setName("l2");
        l2.setFigure(fd);
        l2.setAccessor(a2);
        Canvas canvas = GMFGraphFactory.eINSTANCE.createCanvas();
        canvas.setName("canvas");
        canvas.getFigures().add((Object)fg);
        canvas.getNodes().add((Object)node);
        canvas.getLabels().add((Object)l1);
        canvas.getLabels().add((Object)l2);
        Canvas mirroredCanvas = this.mirror(canvas);
        Checker checker = new Checker();
        checker.check((List<?>)canvas.getNodes(), (List<?>)mirroredCanvas.getNodes());
        checker.check((List<?>)canvas.getLabels(), (List<?>)mirroredCanvas.getLabels());
    }

    private Canvas mirror(Canvas canvas) {
        StandaloneGenerator.Config config = FigureGeneratorUtil.createStandaloneGeneratorConfig(CUSTOM_FIGURES_PACKAGE, false);
        CanvasProcessor processor = new CanvasProcessor(canvas);
        FigureGeneratorUtil.generate(config, (StandaloneGenerator.Processor)processor);
        return processor.getOutcome();
    }

    private static Class<?> searchForFigureName(FigureGeneratorUtil.GeneratedClassData[] classes, String expectedName) {
        Class<?> result = null;
        int i = 0;
        while (result == null && i < classes.length) {
            if (expectedName.equals(classes[i].getFigureDef().getName())) {
                result = classes[i].getLoadedClass();
            }
            ++i;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Checker {
        public void check(List<?> originalsByType, List<?> mirroredByType) {
            StandalonePluginConverterTest.assertEquals((int)originalsByType.size(), (int)mirroredByType.size());
            Iterator<?> allOriginals = originalsByType.iterator();
            Iterator<?> allMirrored = mirroredByType.iterator();
            while (allOriginals.hasNext() || allMirrored.hasNext()) {
                DiagramElement nextOriginal = (DiagramElement)allOriginals.next();
                DiagramElement nextMirrored = (DiagramElement)allMirrored.next();
                this.check(nextOriginal, nextMirrored);
            }
            StandalonePluginConverterTest.assertFalse((boolean)allOriginals.hasNext());
            StandalonePluginConverterTest.assertFalse((boolean)allMirrored.hasNext());
        }

        public void check(DiagramElement original, DiagramElement mirrored) {
            StandalonePluginConverterTest.assertEquals((int)original.eClass().getClassifierID(), (int)mirrored.eClass().getClassifierID());
            StandalonePluginConverterTest.assertEquals((String)original.getName(), (String)mirrored.getName());
            String expectedFQN = Checker.composeFQN(original.getFigure());
            Figure actualFigure = mirrored.getFigure().getActualFigure();
            StandalonePluginConverterTest.assertNotNull((Object)actualFigure);
            StandalonePluginConverterTest.assertTrue((String)actualFigure.getClass().getName(), (boolean)(actualFigure instanceof CustomFigure));
            if (actualFigure instanceof CustomFigure) {
                CustomFigure actual = (CustomFigure)actualFigure;
                StandalonePluginConverterTest.assertEquals((String)expectedFQN, (String)actual.getQualifiedClassName());
                if (original instanceof Compartment) {
                    Compartment originalCompartment = (Compartment)original;
                    Compartment mirroredCompartment = (Compartment)mirrored;
                    StandalonePluginConverterTest.assertEquals((boolean)originalCompartment.isCollapsible(), (boolean)mirroredCompartment.isCollapsible());
                    StandalonePluginConverterTest.assertEquals((boolean)originalCompartment.isNeedsTitle(), (boolean)mirroredCompartment.isNeedsTitle());
                }
            } else {
                FigureAccessor accessor = (FigureAccessor)actualFigure;
                StandalonePluginConverterTest.assertNotNull((Object)accessor.getAccessor());
            }
        }

        private static String composeFQN(FigureDescriptor figure) {
            return "custom.figures.pakkage." + CodeGenUtil.validJavaIdentifier((String)figure.getName());
        }
    }
}

