/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.extended;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.IPropertyAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class MultiButtonCellEditor
extends CellEditor {
    private Composite editor;
    private Font font;
    private Control label;
    private ArrayList buttonList;
    private Object value = null;

    public MultiButtonCellEditor(Composite parent) {
        this(parent, 0);
    }

    public MultiButtonCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        this.buttonList = new ArrayList();
        this.font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setFont(this.font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new MultiButtonCellLayout());
        this.label = this.isModifiable() ? new Text(this.editor, 16384) : new Label(this.editor, 16384);
        this.label.setFont(this.font);
        this.label.setBackground(bg);
        this.updateLabel(this.value);
        this.initButtons();
        assert (this.buttonList.size() > 0) : "button list size must > 0";
        this.setValueValid(true);
        return this.editor;
    }

    protected boolean isModifiable() {
        return false;
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        ((Button)this.buttonList.get(this.buttonList.size() - 1)).setFocus();
    }

    protected void doSetValue(Object val) {
        this.value = val;
        this.updateLabel(val);
    }

    protected void addButton(String buttonLabel, final IPropertyAction buttonAction) {
        Button button = new Button(this.editor, 1024);
        button.setText(buttonLabel);
        button.setFont(this.font);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object newValue = buttonAction.execute((Control)MultiButtonCellEditor.this.editor);
                if (newValue != null) {
                    boolean newValidState = MultiButtonCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        MultiButtonCellEditor.this.markDirty();
                        MultiButtonCellEditor.this.doSetValue(newValue);
                    } else {
                        MultiButtonCellEditor.this.setErrorMessage(MessageFormat.format(MultiButtonCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    MultiButtonCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    MultiButtonCellEditor.this.fireCancelEditor();
                }
            }
        });
        button.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    e.doit = false;
                    MultiButtonCellEditor.this.getControl().traverse(8);
                }
                if (e.detail == 16) {
                    e.doit = false;
                    MultiButtonCellEditor.this.getControl().traverse(16);
                }
            }
        });
        this.buttonList.add(button);
    }

    protected void updateLabel(Object val) {
        if (this.label == null) {
            return;
        }
        String text = "";
        if (val != null) {
            text = val.toString();
        }
        if (this.label instanceof Label) {
            ((Label)this.label).setText(text);
        } else if (this.label instanceof Text) {
            ((Text)this.label).setText(text);
        }
    }

    protected abstract void initButtons();

    protected Label getLabel() {
        return this.label != null && this.label instanceof Label ? (Label)this.label : null;
    }

    protected Text getText() {
        return this.label != null && this.label instanceof Text ? (Text)this.label : null;
    }

    private class MultiButtonCellLayout
    extends Layout {
        private MultiButtonCellLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int height = 0;
            int sumWidth = 0;
            int count = MultiButtonCellEditor.this.buttonList.size();
            int i = 0;
            while (i < count) {
                Point size = ((Button)MultiButtonCellEditor.this.buttonList.get(i)).computeSize(-1, -1, flushCache);
                sumWidth += size.x;
                height = Math.max(height, size.y);
                ++i;
            }
            Point labelSize = MultiButtonCellEditor.this.label.computeSize(-1, -1, flushCache);
            return new Point(sumWidth, Math.max(labelSize.y, height));
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle bounds = MultiButtonCellEditor.this.editor.getClientArea();
            int count = MultiButtonCellEditor.this.buttonList.size();
            int sumWidth = 0;
            int[] widthArray = new int[count];
            int start = 0;
            int i = 0;
            while (i < count) {
                Point size = ((Button)MultiButtonCellEditor.this.buttonList.get(i)).computeSize(-1, -1, flushCache);
                sumWidth += size.x;
                widthArray[i] = size.x;
                ++i;
            }
            if (MultiButtonCellEditor.this.label != null) {
                MultiButtonCellEditor.this.label.setBounds(0, 0, bounds.width - sumWidth, bounds.height);
                start = bounds.width - sumWidth;
            }
            i = 0;
            while (i < count) {
                Button button = (Button)MultiButtonCellEditor.this.buttonList.get(i);
                button.setBounds(start, 0, widthArray[i], bounds.height);
                start += widthArray[i];
                ++i;
            }
        }
    }
}

