/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class GeoShapeCylinderFigure
extends GeoShapeFigure
implements IPolygonAnchorableFigure {
    private PointList anchorBorderPointList;

    public GeoShapeCylinderFigure(int width, int height, int spacing) {
        super(width, height, spacing);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        int height = (int)((double)r.height * 0.25);
        Rectangle ellipse = new Rectangle(r.x, r.y, r.width, height);
        Rectangle middle = new Rectangle(r.x, r.y + height / 2, r.width, r.height - height + 1);
        Rectangle lowerArc = new Rectangle(r.x, r.y + r.height - height - 1, r.width, height);
        g.fillOval(ellipse);
        g.fillRectangle(middle);
        g.fillArc(lowerArc, 180, 180);
        g.setLineStyle(this.getLineStyle());
        g.setLineWidth(this.getLineWidth());
        g.drawOval(ellipse.x, ellipse.y, ellipse.width - 1, ellipse.height - 1);
        g.drawLine(middle.x, middle.y, middle.x, middle.y + middle.height);
        g.drawLine(middle.x + middle.width - 1, middle.y, middle.x + middle.width - 1, middle.y + middle.height);
        g.drawArc(lowerArc, 180, 180);
    }

    protected PointList getAnchorBorderPointList() {
        Rectangle rBounds = this.getBounds();
        int height = (int)((double)rBounds.height * 0.25);
        Rectangle rUpperEllipse = new Rectangle(rBounds.x, rBounds.y, rBounds.width, height);
        Rectangle rMiddle = new Rectangle(rBounds.x, rBounds.y + height / 2, rBounds.width, rBounds.height - height + 1);
        Rectangle rLowerEllipse = new Rectangle(rBounds.x, rBounds.y + rBounds.height - height - 1, rBounds.width, height);
        PrecisionPoint keyPoint1 = new PrecisionPoint(rMiddle.getTopLeft().x, rMiddle.getTopLeft().y);
        PrecisionPoint keyPoint2 = new PrecisionPoint(rMiddle.getBottomLeft().x, rMiddle.getBottomLeft().y);
        PrecisionPoint keyPoint3 = new PrecisionPoint(rMiddle.getBottomRight().x, rMiddle.getBottomRight().y);
        PrecisionPoint keyPoint4 = new PrecisionPoint(rMiddle.getTopRight().x, rMiddle.getTopRight().y);
        PointList upperPointList = new PointList();
        upperPointList.addPoint((Point)keyPoint4);
        LineSeg lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getTopRight().x - rUpperEllipse.width / 32, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 32, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getTopRight().x - rUpperEllipse.width / 12, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 12, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getTopRight().x - rUpperEllipse.width / 8, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 8, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getTopRight().x - rUpperEllipse.width / 4, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 4, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        upperPointList.addPoint(rUpperEllipse.getCenter().x, rUpperEllipse.getCenter().y - rUpperEllipse.height / 2);
        lineSeg = new LineSeg(new Point(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 4, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 4, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 8, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 8, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 12, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 12, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 32, rUpperEllipse.getTopRight().y), (Point)new PrecisionPoint(rUpperEllipse.getTopLeft().x + rUpperEllipse.width / 32, rUpperEllipse.getCenter().y));
        upperPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rUpperEllipse).getLastPoint());
        upperPointList.addPoint((Point)keyPoint1);
        PointList lowerPointList = new PointList();
        lowerPointList.addPoint((Point)keyPoint2);
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 32, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 32, rLowerEllipse.getBottomLeft().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 12, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 12, rLowerEllipse.getBottomLeft().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 8, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 8, rLowerEllipse.getBottomLeft().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 4, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomLeft().x + rUpperEllipse.width / 4, rLowerEllipse.getBottomLeft().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lowerPointList.addPoint(rLowerEllipse.getCenter().x, rLowerEllipse.getCenter().y + rLowerEllipse.height / 2);
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 4, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 4, rLowerEllipse.getBottomRight().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 8, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 8, rLowerEllipse.getBottomRight().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 12, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 12, rLowerEllipse.getBottomRight().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lineSeg = new LineSeg((Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 32, rLowerEllipse.getCenter().y), (Point)new PrecisionPoint(rUpperEllipse.getBottomRight().x - rUpperEllipse.width / 32, rLowerEllipse.getBottomRight().y));
        lowerPointList.addPoint(lineSeg.getLineIntersectionsWithEllipse(rLowerEllipse).getFirstPoint());
        lowerPointList.addPoint((Point)keyPoint3);
        PointList combinedPointList = new PointList();
        combinedPointList.addPoint((Point)keyPoint1);
        combinedPointList.addPoint((Point)keyPoint2);
        combinedPointList.addAll(PointListUtilities.calcSmoothPolyline((PointList)lowerPointList, (int)64, (int)16));
        combinedPointList.addPoint((Point)keyPoint3);
        combinedPointList.addPoint((Point)keyPoint4);
        combinedPointList.addAll(PointListUtilities.calcSmoothPolyline((PointList)upperPointList, (int)64, (int)16));
        combinedPointList.addPoint((Point)keyPoint1);
        PointListUtilities.normalizeSegments((PointList)combinedPointList);
        return combinedPointList;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.anchorBorderPointList = null;
    }

    public PointList getPolygonPoints() {
        if (this.anchorBorderPointList == null) {
            this.anchorBorderPointList = this.getAnchorBorderPointList();
        }
        return this.anchorBorderPointList.getCopy();
    }
}

