/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.SessionSetup;

public class PaletteTest
extends GeneratedCanvasTest {
    public PaletteTest(String name) {
        super(name);
        this.myDefaultSetup = SessionSetup.newInstance();
    }

    public void testEntriesGetIdentity() throws Exception {
        PaletteRoot root = this.getPaletteRoot();
        PaletteTest.assertFalse((boolean)root.getChildren().isEmpty());
        boolean creationToolFound = false;
        HashMap<String, PaletteEntry> duplicateSearch = new HashMap<String, PaletteEntry>();
        LinkedList entries = new LinkedList();
        List children = root.getChildren();
        entries.addAll(children);
        while (!entries.isEmpty()) {
            PaletteEntry entry = (PaletteEntry)entries.removeFirst();
            if (entry instanceof ToolEntry && ((ToolEntry)entry).createTool() instanceof CreationTool) {
                creationToolFound = true;
                PaletteTest.assertFalse((String)("Tool " + entry.getLabel() + " has no identity"), (boolean)entry.getId().trim().equals(""));
                PaletteEntry dup = duplicateSearch.put(entry.getId(), entry);
                if (dup == null) continue;
                PaletteTest.fail((String)("Tool " + entry.getLabel() + "has same identity as tool " + dup.getLabel() + ":" + entry.getId()));
                continue;
            }
            if (!(entry instanceof PaletteContainer)) continue;
            List ch = ((PaletteContainer)entry).getChildren();
            entries.addAll(ch);
        }
        PaletteTest.assertTrue((String)"Palette has no elements to check", (boolean)creationToolFound);
    }

    private PaletteRoot getPaletteRoot() throws Exception {
        String paletteClassName = this.getSetup().getGenModel().getGenDiagram().getPalette().getFactoryQualifiedClassName();
        Class<?> paletteClass = this.getSetup().loadGeneratedClass(paletteClassName);
        Object paletteFactory = paletteClass.newInstance();
        PaletteRoot rv = new PaletteRoot();
        paletteClass.getMethod("fillPalette", PaletteRoot.class).invoke(paletteFactory, rv);
        return rv;
    }
}

