/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.editor.ColorProvider;
import org.eclipse.gmf.internal.xpand.editor.XpandContentOutlinePage;
import org.eclipse.gmf.internal.xpand.editor.XpandDocumentProvider;
import org.eclipse.gmf.internal.xpand.editor.XpandSourceViewerConfiguration;
import org.eclipse.gmf.internal.xpand.editor.ui.InsertTextAction;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class XpandEditor
extends TextEditor {
    private final ColorProvider colorProvider = new ColorProvider(org.eclipse.gmf.internal.xpand.editor.Activator.getDefault().getPreferenceStore());
    private final XpandContentOutlinePage ivOutlinePage = null;
    private XpandExecutionContext context;

    public XpandEditor() {
        this.colorProvider.initializeDefaults();
        this.setSourceViewerConfiguration(new XpandSourceViewerConfiguration(this));
        this.setDocumentProvider((IDocumentProvider)new XpandDocumentProvider());
    }

    XpandExecutionContext getContext() {
        if (this.context == null) {
            assert (this.getEditorInput().getAdapter(IFile.class) != null);
            IFile aFile = (IFile)this.getEditorInput().getAdapter(IFile.class);
            ResourceManager resourceManager = Activator.getResourceManager((IFile)aFile);
            this.context = ContextFactory.createXpandContext((ResourceManager)resourceManager);
        }
        return this.context;
    }

    public void dispose() {
        this.colorProvider.dispose();
        super.dispose();
    }

    ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public void editorContextMenuAboutToShow(IMenuManager aMenu) {
        super.editorContextMenuAboutToShow(aMenu);
        this.addAction(aMenu, "ContentAssistProposal");
        this.addAction(aMenu, "ContentAssistTip");
    }

    public Object getAdapter(Class aRequired) {
        if (IContentOutlinePage.class.equals((Object)aRequired)) {
            return this.ivOutlinePage;
        }
        return super.getAdapter(aRequired);
    }

    public void redraw() {
        IDocument document;
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null && (document = sourceViewer.getDocument()) != null) {
            document.set(document.get());
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle rb = new ResourceBundle(){

            @Override
            public Enumeration<String> getKeys() {
                List s = Collections.emptyList();
                return Collections.enumeration(s);
            }

            @Override
            protected Object handleGetObject(String key) {
                return null;
            }
        };
        Object a = new TextOperationAction(rb, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(rb, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new InsertTextAction(rb, (ITextEditor)this, (ITextViewer)this.getSourceViewer(), "\u00ab");
        a.setActionDefinitionId(String.valueOf(org.eclipse.gmf.internal.xpand.editor.Activator.getPluginID()) + ".insertLT");
        this.setAction("InsertLT", (IAction)a);
        a = new InsertTextAction(rb, (ITextEditor)this, (ITextViewer)this.getSourceViewer(), "\u00bb");
        a.setActionDefinitionId(String.valueOf(org.eclipse.gmf.internal.xpand.editor.Activator.getPluginID()) + ".insertRT");
        this.setAction("InsertRT", (IAction)a);
    }
}

