/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetStatement
extends Statement {
    private final Identifier varName;
    private final Expression varValue;
    private final Statement[] body;

    public LetStatement(int start, int end, int line, Identifier varName, Expression value, Statement[] body) {
        super(start, end, line);
        this.varName = varName;
        this.varValue = value;
        this.body = body;
    }

    public Statement[] getBody() {
        return this.body;
    }

    public Identifier getVarName() {
        return this.varName;
    }

    public Expression getVarValue() {
        return this.varValue;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier t = this.getVarValue().analyze(ctx, issues);
        if (t == null) {
            t = EcorePackage.eINSTANCE.getEObject();
        }
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVarName().getValue(), t));
        Statement[] statementArray = this.getBody();
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            statement.analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(this.getVarName().getValue(), this.getVarValue().evaluate(ctx)));
        Statement[] statementArray = this.getBody();
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            statement.evaluate(ctx);
            ++n2;
        }
    }
}

