/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.DiagramElement;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureHandle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.internal.bridge.resolver.Resolution;
import org.eclipse.gmf.internal.bridge.resolver.ResolvedItem;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.gmf.internal.common.IncrementalNamesDispenser;
import org.eclipse.gmf.internal.common.NamesDispenser;

public class GraphDefBuilder {
    protected GMFGraphPackage gmfGraphPackage = GMFGraphPackage.eINSTANCE;
    protected GMFGraphFactory gmfGraphFactory = this.gmfGraphPackage.getGMFGraphFactory();
    protected NamesDispenser namesDispenser = new IncrementalNamesDispenser();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.wizards.pages.GraphDefBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected String getUniqueName(String semanticPart, String suffixPart) {
        return this.namesDispenser.get(semanticPart, suffixPart);
    }

    public Canvas process(ResolvedItem item) {
        Canvas canvas = this.gmfGraphFactory.createCanvas();
        if (item != null) {
            EPackage ePackage = (EPackage)item.getDomainRef();
            canvas.setName(ePackage.getName());
            FigureGallery fGallery = this.gmfGraphFactory.createFigureGallery();
            fGallery.setName(Messages.GraphDefBuilder0);
            canvas.getFigures().add((Object)fGallery);
            Iterator it = item.getChildren().iterator();
            while (it.hasNext()) {
                this.process((ResolvedItem)it.next(), canvas, fGallery, null);
            }
        }
        return canvas;
    }

    protected void process(ResolvedItem item, Canvas canvas, FigureGallery fGallery, DiagramElement parent) {
        Node dElement;
        Rectangle figure;
        String baseName;
        boolean descend = false;
        Node newParent = null;
        if (item.getDomainRef() instanceof EClass) {
            EClass type = (EClass)item.getDomainRef();
            baseName = type.getName();
            if (item.getResolution() == Resolution.NODE) {
                figure = this.gmfGraphFactory.createRectangle();
                figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
                fGallery.getFigures().add((Object)figure);
                dElement = this.gmfGraphFactory.createNode();
                dElement.setFigure((FigureHandle)figure);
                dElement.setName(this.getUniqueName(baseName, null));
                canvas.getNodes().add((Object)dElement);
                descend = true;
                newParent = dElement;
            } else if (item.getResolution() == Resolution.LINK) {
                figure = this.gmfGraphFactory.createPolylineConnection();
                figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
                fGallery.getFigures().add((Object)figure);
                dElement = this.gmfGraphFactory.createConnection();
                dElement.setFigure((FigureHandle)figure);
                dElement.setName(this.getUniqueName(baseName, null));
                canvas.getConnections().add((Object)dElement);
                descend = true;
                newParent = dElement;
            }
        } else if (item.getDomainRef() instanceof EReference) {
            EReference ref = (EReference)item.getDomainRef();
            baseName = WizardUtil.getCapName((EStructuralFeature)ref);
            if (item.getResolution() == Resolution.LINK) {
                figure = this.gmfGraphFactory.createPolylineConnection();
                figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
                PolylineDecoration decoration = this.gmfGraphFactory.createPolylineDecoration();
                decoration.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder6));
                figure.setTargetDecoration((DecorationFigure)decoration);
                fGallery.getFigures().add((Object)figure);
                fGallery.getFigures().add((Object)decoration);
                Connection dElement2 = this.gmfGraphFactory.createConnection();
                dElement2.setFigure((FigureHandle)figure);
                dElement2.setName(this.getUniqueName(baseName, null));
                canvas.getConnections().add((Object)dElement2);
                descend = true;
                newParent = dElement2;
            }
        } else if (item.getDomainRef() instanceof EAttribute) {
            EAttribute attr = (EAttribute)item.getDomainRef();
            baseName = WizardUtil.getCapName((EStructuralFeature)attr);
            if (item.getResolution() == Resolution.LABEL) {
                figure = this.gmfGraphFactory.createLabel();
                figure.setName(this.getUniqueName(baseName, Messages.GraphDefBuilder1));
                figure.setText(Messages.GraphDefBuilder5);
                if (!$assertionsDisabled && !(parent.getFigure() instanceof Figure)) {
                    throw new AssertionError();
                }
                ((Figure)parent.getFigure()).getChildren().add((Object)figure);
                dElement = this.gmfGraphFactory.createDiagramLabel();
                dElement.setFigure((FigureHandle)figure);
                dElement.setName(this.getUniqueName(baseName, null));
                canvas.getLabels().add((Object)dElement);
                descend = true;
                newParent = dElement;
            }
        }
        if (descend) {
            Iterator it = item.getChildren().iterator();
            while (it.hasNext()) {
                this.process((ResolvedItem)it.next(), canvas, fGallery, (DiagramElement)newParent);
            }
        }
    }
}

