/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;

public interface Matcher {
    public static final Matcher FALSE = new Matcher(){

        public boolean match(EObject current, EObject old) {
            return false;
        }
    };

    public boolean match(EObject var1, EObject var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AND
    implements Matcher {
        private final Matcher[] myMatchers;

        public AND(Matcher[] matchers) {
            this.myMatchers = matchers;
        }

        public AND(Collection<Matcher> matchers) {
            this(matchers.toArray(new Matcher[matchers.size()]));
        }

        @Override
        public boolean match(EObject current, EObject old) {
            boolean result = true;
            int i = 0;
            while (result && i < this.myMatchers.length) {
                result = this.myMatchers[i].match(current, old);
                ++i;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OR
    implements Matcher {
        private final Matcher[] myMatchers;

        public OR(Matcher[] matchers) {
            this.myMatchers = matchers;
        }

        public OR(Collection<Matcher> matchers) {
            this(matchers.toArray(new Matcher[matchers.size()]));
        }

        @Override
        public boolean match(EObject current, EObject old) {
            boolean result = false;
            int i = 0;
            while (!result && i < this.myMatchers.length) {
                result = this.myMatchers[i].match(current, old);
                ++i;
            }
            return result;
        }
    }
}

