/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.services;

import java.lang.ref.WeakReference;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LogicDiagramEventBroker
extends DiagramEventBroker {
    private static boolean isCreated = false;
    private static boolean isMethodInvoked = false;
    WeakReference editingDomainRef;

    public LogicDiagramEventBroker() {
        isCreated = true;
    }

    public static boolean isCreated() {
        return isCreated;
    }

    public static boolean isMethodInvoked() {
        return isMethodInvoked;
    }

    public LogicDiagramEventBroker(TransactionalEditingDomain editingDomain) {
        isCreated = true;
        this.editingDomainRef = new WeakReference<TransactionalEditingDomain>(editingDomain);
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        isMethodInvoked = true;
        if (this.shouldSynchronizeWithMainThread(event)) {
            final ResourceSetChangeEvent eventToHandle = event;
            TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)this.editingDomainRef.get();
            if (editingDomain != null) {
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)editingDomain.createPrivilegedRunnable(new Runnable(){

                    public void run() {
                        LogicDiagramEventBroker.this.internal_resourceSetChanged(eventToHandle);
                    }
                }));
                return;
            }
        }
        super.resourceSetChanged(event);
    }

    private boolean shouldSynchronizeWithMainThread(ResourceSetChangeEvent event) {
        return Display.getCurrent() == null;
    }

    private void internal_resourceSetChanged(ResourceSetChangeEvent event) {
        super.resourceSetChanged(event);
    }

    public void addNotificationListener(EObject target, EStructuralFeature key, NotificationListener listener) {
        isMethodInvoked = true;
        super.addNotificationListener(target, key, listener);
    }

    public void addNotificationListener(EObject target, EStructuralFeature key, NotificationPreCommitListener listener) {
        isMethodInvoked = true;
        super.addNotificationListener(target, key, listener);
    }

    public void addNotificationListener(EObject target, NotificationListener listener) {
        isMethodInvoked = true;
        super.addNotificationListener(target, listener);
    }

    public void addNotificationListener(EObject target, NotificationPreCommitListener listener) {
        isMethodInvoked = true;
        super.addNotificationListener(target, listener);
    }

    protected void fireNotification(Notification event) {
        isMethodInvoked = true;
        super.fireNotification(event);
    }

    protected Set getInterestedNotificationListeners(Notification event, DiagramEventBroker.NotifierToKeyToListenersSetMap listeners) {
        isMethodInvoked = true;
        return super.getInterestedNotificationListeners(event, listeners);
    }

    protected DiagramEventBroker.NotifierToKeyToListenersSetMap getPostCommitListenersMap() {
        isMethodInvoked = true;
        return super.getPostCommitListenersMap();
    }

    protected DiagramEventBroker.NotifierToKeyToListenersSetMap getPreCommitListenersMap() {
        isMethodInvoked = true;
        return super.getPreCommitListenersMap();
    }

    protected void handleNotificationOnDeletedElement(ResourceSetChangeEvent event) {
        isMethodInvoked = true;
        super.handleNotificationOnDeletedElement(event);
    }

    public boolean isAggregatePrecommitListener() {
        isMethodInvoked = true;
        return super.isAggregatePrecommitListener();
    }

    protected boolean isDeleted(Set deletedObjects, EObject notifier) {
        isMethodInvoked = true;
        return super.isDeleted(deletedObjects, notifier);
    }

    public void removeNotificationListener(EObject target, NotificationListener listener) {
        isMethodInvoked = true;
        super.removeNotificationListener(target, listener);
    }

    public void removeNotificationListener(EObject target, NotificationPreCommitListener listener) {
        isMethodInvoked = true;
        super.removeNotificationListener(target, listener);
    }

    public void removeNotificationListener(EObject target, Object key, NotificationListener listener) {
        isMethodInvoked = true;
        super.removeNotificationListener(target, key, listener);
    }

    public void removeNotificationListener(EObject target, Object key, NotificationPreCommitListener listener) {
        isMethodInvoked = true;
        super.removeNotificationListener(target, key, listener);
    }

    protected boolean shouldIgnoreNotification(Notification notification) {
        isMethodInvoked = true;
        return super.shouldIgnoreNotification(notification);
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) {
        isMethodInvoked = true;
        return super.transactionAboutToCommit(event);
    }
}

