/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Wire;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.CanonicalTestFixture;

public class LogicCanonicalTests
extends AbstractTestBase {
    public static Test suite() {
        TestSuite s = new TestSuite(LogicCanonicalTests.class);
        return s;
    }

    public LogicCanonicalTests() {
        super("Canonical Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new CanonicalTestFixture();
    }

    protected CanonicalTestFixture getCanonicalTestFixture() {
        return (CanonicalTestFixture)this.getTestFixture();
    }

    public void test_DisableCanonical() {
        try {
            LogicCanonicalTests.println("test_DisableCanonical() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            _testFixture.enableCanonical(logicCompartment, false);
            int SIZE = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (i < count) {
                _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
                LogicCanonicalTests.assertEquals((String)"Unexpected LED", (int)SIZE, (int)logicCompartment.getChildren().size());
                ++i;
            }
            _testFixture.enableCanonical(logicCompartment, true);
            LogicCanonicalTests.assertEquals((String)"Unexpected LED", (int)count, (int)logicCompartment.getChildren().size());
        }
        finally {
            LogicCanonicalTests.println("test_DisableCanonical() complete.");
        }
    }

    public void test_RefreshWhileCollapsed() {
        try {
            LogicCanonicalTests.println("test_RefreshWhileCollapsed() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            _testFixture.setCollapsed((IResizableCompartmentEditPart)logicCompartment, true);
            int SIZE = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (i < count) {
                _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
                LogicCanonicalTests.assertEquals((String)"Unexpected LED", (int)SIZE, (int)logicCompartment.getChildren().size());
                ++i;
            }
            _testFixture.setCollapsed((IResizableCompartmentEditPart)logicCompartment, false);
            LogicCanonicalTests.assertEquals((String)"Unexpected LED", (int)count, (int)logicCompartment.getChildren().size());
        }
        finally {
            LogicCanonicalTests.println("test_RefreshWhileCollapsed() complete.");
        }
    }

    public void test_RefreshWhileVisible() {
        try {
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            LogicCanonicalTests.println("test_RefreshWhileVisible() starting ...");
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            View view = logicCompartment.getNotationView();
            _testFixture.setVisible(logicCompartment, false);
            int SIZE = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (i < count) {
                _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
                LogicCanonicalTests.assertEquals((String)"Unexpected LED", (int)SIZE, (int)logicCompartment.getChildren().size());
                ++i;
            }
            _testFixture.setVisible(view, true);
            IGraphicalEditPart logicCompartment1 = _testFixture.getCanonicalCompartment(0);
            LogicCanonicalTests.assertEquals((String)"Unexpected LED", (int)count, (int)logicCompartment1.getChildren().size());
        }
        finally {
            LogicCanonicalTests.println("test_RefreshWhileVisible() complete.");
        }
    }

    public void test_AddRemoveLED() {
        try {
            LogicCanonicalTests.println("test_AddRemoveLED() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            ArrayList<LED> properties = new ArrayList<LED>();
            int size = logicCompartment.getChildren().size();
            int count = 5;
            int i = 0;
            while (i < count) {
                properties.add(_testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView())));
                LogicCanonicalTests.assertEquals((String)"Unexpected LED count.", (int)(++size), (int)logicCompartment.getChildren().size());
                ++i;
            }
            size = logicCompartment.getChildren().size();
            EObject[] toDelete = new EObject[properties.size()];
            properties.toArray(toDelete);
            int i2 = 0;
            while (i2 < toDelete.length) {
                _testFixture.destroy(toDelete[i2]);
                LogicCanonicalTests.assertEquals((String)"Unexpected LED count.", (int)(--size), (int)logicCompartment.getChildren().size());
                ++i2;
            }
        }
        finally {
            LogicCanonicalTests.println("test_AddRemoveAttribute() complete.");
        }
    }

    public void test_AddDeleteWire() {
        try {
            LogicCanonicalTests.println("test_AddDeleteWire() starting ...");
            CanonicalTestFixture _testFixture = this.getCanonicalTestFixture();
            IGraphicalEditPart logicCompartment = _testFixture.getCanonicalCompartment(0);
            LED led1 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            LED led2 = _testFixture.createLED(ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView()));
            Terminal term1 = (Terminal)led1.getOutputTerminals().get(0);
            Terminal term2 = (Terminal)led2.getInputTerminals().get(0);
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            CreateRelationshipRequest crr = new CreateRelationshipRequest(this.getCanonicalTestFixture().getEditingDomain(), (EObject)term1, (EObject)term2, typeWire);
            ICommand createWire = typeCircuit.getEditHelper().getEditCommand((IEditCommandRequest)crr);
            _testFixture.execute(createWire);
            this.flushEventQueue();
            List connectorEPs = this.getDiagramEditPart().getConnections();
            LogicCanonicalTests.assertEquals((String)"Unexpected Wire count.", (int)1, (int)connectorEPs.size());
            ConnectionEditPart ep = (ConnectionEditPart)connectorEPs.get(0);
            LogicCanonicalTests.assertTrue((String)"Unexpected source.", (boolean)((View)ep.getSource().getModel()).getElement().equals(term1));
            LogicCanonicalTests.assertTrue((String)"Unexpected target.", (boolean)((View)ep.getTarget().getModel()).getElement().equals(term2));
            LogicCanonicalTests.assertTrue((boolean)(((View)ep.getModel()).getElement() instanceof Wire));
            _testFixture.destroy(((View)ep.getModel()).getElement());
            this.flushEventQueue();
            connectorEPs = this.getDiagramEditPart().getConnections();
            LogicCanonicalTests.assertEquals((String)"Unexpected Wire count.", (int)0, (int)connectorEPs.size());
        }
        finally {
            LogicCanonicalTests.println("test_AddDeleteWire() complete.");
        }
    }

    public void test_ReparentLED() {
        try {
            LogicCanonicalTests.println("test_ReparentLED() starting ...");
            CanonicalTestFixture fixture = (CanonicalTestFixture)this.getTestFixture();
            IGraphicalEditPart logicCompartment = fixture.getCanonicalCompartment(0);
            IGraphicalEditPart logicCompartment2 = fixture.getCanonicalCompartment(1);
            Circuit circuit1 = (Circuit)ViewUtil.resolveSemanticElement((View)logicCompartment.getNotationView());
            Circuit circuit2 = (Circuit)ViewUtil.resolveSemanticElement((View)logicCompartment2.getNotationView());
            LED movingLED = fixture.createLED((EObject)circuit1);
            this.flushEventQueue();
            LogicCanonicalTests.assertEquals((String)"Unexpected LED count.", (int)1, (int)logicCompartment.getChildren().size());
            MoveRequest mr = new MoveRequest(this.getTestFixture().getEditingDomain(), (EObject)circuit2, (EObject)movingLED);
            IElementType typeCircuit = ElementTypeRegistry.getInstance().getType("logic.circuit");
            ICommand reparentCmd = typeCircuit.getEditHelper().getEditCommand((IEditCommandRequest)mr);
            fixture.execute(reparentCmd);
            this.flushEventQueue();
            LogicCanonicalTests.assertTrue((String)"unexpected LED", (boolean)logicCompartment.getChildren().isEmpty());
            LogicCanonicalTests.assertEquals((String)"Unexpected LED count.", (int)1, (int)logicCompartment2.getChildren().size());
            mr = new MoveRequest(this.getTestFixture().getEditingDomain(), (EObject)circuit1, (EObject)movingLED);
            reparentCmd = typeCircuit.getEditHelper().getEditCommand((IEditCommandRequest)mr);
            fixture.execute(reparentCmd);
            this.flushEventQueue();
            LogicCanonicalTests.assertTrue((String)"unexpected LED", (boolean)logicCompartment2.getChildren().isEmpty());
            LogicCanonicalTests.assertEquals((String)"Unexpected LED count.", (int)1, (int)logicCompartment.getChildren().size());
        }
        finally {
            LogicCanonicalTests.println("test_ReparentLED() complete.");
        }
    }

    public void test_createLEDUsingTool() {
        CanonicalTestFixture fixture = (CanonicalTestFixture)this.getTestFixture();
        IGraphicalEditPart logicCompartment = fixture.getCanonicalCompartment(0);
        Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
        logicCompartment.getFigure().translateToAbsolute((Translatable)rect);
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        this.getCanonicalTestFixture().createShapeUsingTool(typeLED, rect.getCenter(), logicCompartment);
        LogicCanonicalTests.assertEquals((String)"Unexpected LED count.", (int)1, (int)logicCompartment.getChildren().size());
    }

    public void test_createWireUsingTool() {
        try {
            LogicCanonicalTests.println("test_AddDeleteWire() starting ...");
            CanonicalTestFixture fixture = (CanonicalTestFixture)this.getTestFixture();
            IGraphicalEditPart logicCompartment = fixture.getCanonicalCompartment(0);
            Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
            IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
            LEDEditPart ledEP1 = (LEDEditPart)this.getCanonicalTestFixture().createShapeUsingTool(typeLED, rect.getTopLeft().getTranslated(10, 10), logicCompartment);
            rect = new Rectangle(logicCompartment.getFigure().getBounds());
            LEDEditPart ledEP2 = (LEDEditPart)this.getCanonicalTestFixture().createShapeUsingTool(typeLED, rect.getBottomRight().getTranslated(-10, -10), logicCompartment);
            Terminal term1 = (Terminal)((LED)ledEP1.getNotationView().getElement()).getOutputTerminals().get(0);
            TerminalEditPart tep1 = null;
            ListIterator li = ledEP1.getChildren().listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
                if (!gep.getNotationView().getElement().equals(term1)) continue;
                tep1 = (TerminalEditPart)gep;
            }
            Terminal term2 = (Terminal)((LED)ledEP2.getNotationView().getElement()).getInputTerminals().get(0);
            TerminalEditPart tep2 = null;
            li = ledEP2.getChildren().listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
                if (!gep.getNotationView().getElement().equals(term2)) continue;
                tep2 = (TerminalEditPart)gep;
            }
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            this.getCanonicalTestFixture().createConnectorUsingTool((IGraphicalEditPart)tep1, (IGraphicalEditPart)tep2, typeWire);
            List connectorEPs = this.getDiagramEditPart().getConnections();
            LogicCanonicalTests.assertEquals((String)"Unexpected Wire count.", (int)1, (int)connectorEPs.size());
            ConnectionEditPart ep = (ConnectionEditPart)connectorEPs.get(0);
            LogicCanonicalTests.assertTrue((String)"Unexpected source.", (boolean)((View)ep.getSource().getModel()).getElement().equals(term1));
            LogicCanonicalTests.assertTrue((String)"Unexpected target.", (boolean)((View)ep.getTarget().getModel()).getElement().equals(term2));
            LogicCanonicalTests.assertTrue((boolean)(((View)ep.getModel()).getElement() instanceof Wire));
        }
        finally {
            LogicCanonicalTests.println("test_AddDeleteWire() complete.");
        }
    }
}

