/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.gmfgraph.Border;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.ColorConstants;
import org.eclipse.gmf.gmfgraph.ConstantColor;
import org.eclipse.gmf.gmfgraph.CustomAttribute;
import org.eclipse.gmf.gmfgraph.CustomConnection;
import org.eclipse.gmf.gmfgraph.CustomDecoration;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Insets;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LineBorder;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;
import org.eclipse.gmf.tests.gen.GenericFigureCheck;

public class FigureCodegenTest
extends FigureCodegenTestBase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public FigureCodegenTest(String name) {
        super(name);
    }

    public void testGenPolylineConnection() {
        this.performTests((Figure)this.ecoreContainmentRef(), new FigureCodegenTestBase.FigureCheck(){

            public void checkFigure(IFigure figure) {
                1.assertTrue((boolean)(figure instanceof PolylineConnectionEx));
            }
        });
    }

    public void testGenCustomFigure() {
        this.performTests(this.figure1());
    }

    public void testGenSimpleShape() {
        this.performTests(this.figure2());
    }

    public void testGenComplexShape() {
        this.performTests(this.figure3());
    }

    public void testGenFigureWithoutPackageStmt() {
        this.myFigurePackageName = null;
        this.setCustomFigureGenerator(new FigureGenerator((FigureQualifiedNameSwitch)new RuntimeFQNSwitch(), false));
        this.testGenComplexShape();
    }

    public void testGenCustomFigureWithAttributes() {
        CustomFigure result = GMFGraphFactory.eINSTANCE.createCustomFigure();
        result.setName("MyHorizontalScrollBar");
        result.setBundleName("org.eclipse.draw2d");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ScrollBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.setQualifiedClassName(clazz.getName());
        CustomAttribute minimum = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        minimum.setName("minimum");
        minimum.setValue("1");
        result.getAttributes().add((Object)minimum);
        CustomAttribute maximum = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        maximum.setName("Maximum");
        maximum.setValue("99");
        result.getAttributes().add((Object)maximum);
        CustomAttribute orientation = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        orientation.setName("horizontal");
        orientation.setValue("true");
        result.getAttributes().add((Object)orientation);
        org.eclipse.gmf.gmfgraph.Dimension outerPrefSize = GMFGraphFactory.eINSTANCE.createDimension();
        outerPrefSize.setDx(100);
        outerPrefSize.setDy(100);
        result.setPreferredSize(outerPrefSize);
        FigureCodegenTestBase.FigureCheck customCheck = new FigureCodegenTestBase.FigureCheck(){

            public void checkFigure(IFigure figure) {
                2.assertTrue((boolean)(figure instanceof ScrollBar));
                ScrollBar custom = (ScrollBar)figure;
                2.assertEquals((int)1, (int)custom.getMinimum());
                2.assertEquals((int)99, (int)custom.getMaximum());
                2.assertTrue((boolean)custom.isHorizontal());
                2.assertEquals((Object)new Dimension(100, 100), (Object)custom.getPreferredSize());
            }
        };
        GenericFigureCheck defaultCheckWithoutChildren = new GenericFigureCheck((Figure)result){

            protected void checkFigureChildren(Figure gmfFigure, IFigure d2dFigure) {
            }
        };
        this.performTests((Figure)result, FigureCodegenTest.combineChecks(customCheck, defaultCheckWithoutChildren));
    }

    public void testGenCustomDecoration() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.geometry.PointList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String POINT_LIST = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.draw2d.PolygonDecoration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String POLYGON_DECORATION = clazz2.getName();
        CustomDecoration result = GMFGraphFactory.eINSTANCE.createCustomDecoration();
        result.setName("MyPolygonDecoration");
        result.setBundleName("org.eclipse.draw2d");
        result.setQualifiedClassName(POLYGON_DECORATION);
        Insets insets = GMFGraphFactory.eINSTANCE.createInsets();
        insets.setBottom(12);
        insets.setLeft(23);
        insets.setRight(34);
        insets.setTop(45);
        result.setInsets(insets);
        ConstantColor color = GMFGraphFactory.eINSTANCE.createConstantColor();
        color.setValue(ColorConstants.YELLOW_LITERAL);
        result.setBackgroundColor((Color)color);
        CustomAttribute scale = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        scale.setName("scale");
        scale.setValue("1, 1");
        result.getAttributes().add((Object)scale);
        CustomAttribute pointList = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        pointList.setName("Template");
        pointList.setMultiStatementValue(true);
        pointList.setValue(String.valueOf(POINT_LIST) + " {0} = new " + POINT_LIST + "();" + "{0}.addAll(" + POLYGON_DECORATION + ".TRIANGLE_TIP);");
        result.getAttributes().add((Object)pointList);
        FigureCodegenTestBase.FigureCheck customCheck = new FigureCodegenTestBase.FigureCheck(){

            public void checkFigure(IFigure figure) {
                4.assertTrue((boolean)(figure instanceof PolygonDecoration));
                PolygonDecoration decoration = (PolygonDecoration)figure;
                4.assertTrue((boolean)Arrays.equals(PolygonDecoration.TRIANGLE_TIP.toIntArray(), decoration.getPoints().toIntArray()));
            }
        };
        this.performTests((Figure)result, FigureCodegenTest.combineChecks(customCheck, new GenericFigureCheck((Figure)result)));
    }

    public void testGenCustomConnection() {
        CustomConnection result = GMFGraphFactory.eINSTANCE.createCustomConnection();
        result.setName("MyPolylineConnection");
        result.setBundleName("org.eclipse.draw2d");
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.draw2d.PolylineConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.setQualifiedClassName(clazz.getName());
        CustomAttribute router = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        router.setName("connectionRouter");
        router.setValue("new org.eclipse.draw2d.BendpointConnectionRouter()");
        result.getAttributes().add((Object)router);
        CustomAttribute fakeConstarint = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        fakeConstarint.setName("routingConstraint");
        fakeConstarint.setValue("new Integer(42)");
        result.getAttributes().add((Object)fakeConstarint);
        GenericFigureCheck constraintCheck = new GenericFigureCheck((Figure)result){

            protected void checkFigureItself(Figure gmfFigure, IFigure d2dFigure) {
                5.assertEquals((String)"Only one figure expected", (String)"MyPolylineConnection", (String)gmfFigure.getName());
                super.checkFigureItself(gmfFigure, d2dFigure);
                this.checkConstraint(d2dFigure);
            }

            private void checkConstraint(IFigure figure) {
                5.assertTrue((boolean)(figure instanceof PolylineConnection));
                PolylineConnection decoration = (PolylineConnection)figure;
                5.assertTrue((boolean)(decoration.getConnectionRouter() instanceof BendpointConnectionRouter));
                5.assertEquals((Object)new Integer(42), (Object)decoration.getRoutingConstraint());
            }
        };
        this.performTests((Figure)result, constraintCheck);
    }

    public void testCustomFigureWithSameNameAsReferredClassName() {
        CustomFigure custom = GMFGraphFactory.eINSTANCE.createCustomFigure();
        custom.setBundleName("org.eclipse.draw2d");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ScrollBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        custom.setQualifiedClassName(clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.draw2d.ScrollBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        custom.setName(CodeGenUtil.getSimpleClassName((String)clazz2.getName()));
        this.performTests((Figure)custom, CHECK_CAN_CREATE_INSTANCE);
    }

    public void testFigureWithTwoBorderedChildren() {
        Rectangle root = GMFGraphFactory.eINSTANCE.createRectangle();
        root.setName("MultiBorderedRoot");
        Rectangle constantlyBordered = GMFGraphFactory.eINSTANCE.createRectangle();
        constantlyBordered.setName("WithRedConstantBorder");
        LineBorder constantRedBorder = GMFGraphFactory.eINSTANCE.createLineBorder();
        constantRedBorder.setColor((Color)FigureCodegenTest.createConstantColor(ColorConstants.RED_LITERAL));
        constantRedBorder.setWidth(5);
        constantlyBordered.setBorder((Border)constantRedBorder);
        root.getChildren().add((Object)constantlyBordered);
        Rectangle rgbBordered = GMFGraphFactory.eINSTANCE.createRectangle();
        rgbBordered.setName("WithRedRGBBorder");
        LineBorder rgbRedBorder = GMFGraphFactory.eINSTANCE.createLineBorder();
        rgbRedBorder.setColor((Color)FigureCodegenTest.createRGBColor(255, 0, 0));
        rgbRedBorder.setWidth(7);
        rgbBordered.setBorder((Border)rgbRedBorder);
        root.getChildren().add((Object)rgbBordered);
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.swt.graphics.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StaticFieldsChecker staticFieldsCheck = new StaticFieldsChecker(1, clazz);
        this.performTests((Figure)root, FigureCodegenTest.combineChecks(new GenericFigureCheck((Figure)root), staticFieldsCheck));
    }

    public void testFigureWithStaticFieldsForColorAndFonts() {
        Ellipse root = GMFGraphFactory.eINSTANCE.createEllipse();
        root.setName("FullOfColorsAndFonts");
        root.setFont(FigureCodegenTest.createBasicFont("Arial", 23, FontStyle.BOLD_LITERAL));
        root.setForegroundColor((Color)FigureCodegenTest.createConstantColor(ColorConstants.ORANGE_LITERAL));
        root.setBackgroundColor((Color)FigureCodegenTest.createConstantColor(ColorConstants.GREEN_LITERAL));
        Label sansLabel = GMFGraphFactory.eINSTANCE.createLabel();
        sansLabel.setName("SansLabel");
        sansLabel.setFont(FigureCodegenTest.createBasicFont("Sans", 8, FontStyle.ITALIC_LITERAL));
        sansLabel.setForegroundColor((Color)FigureCodegenTest.createConstantColor(ColorConstants.BLUE_LITERAL));
        root.getChildren().add((Object)sansLabel);
        Label tahomaLabel = GMFGraphFactory.eINSTANCE.createLabel();
        tahomaLabel.setName("TahomaLabel");
        tahomaLabel.setFont(FigureCodegenTest.createBasicFont("Tahoma", 12, FontStyle.NORMAL_LITERAL));
        tahomaLabel.setForegroundColor((Color)FigureCodegenTest.createConstantColor(ColorConstants.YELLOW_LITERAL));
        root.getChildren().add((Object)tahomaLabel);
        Rectangle deepLabelContainer = GMFGraphFactory.eINSTANCE.createRectangle();
        deepLabelContainer.setName("DeepLabelContainer");
        deepLabelContainer.setForegroundColor((Color)FigureCodegenTest.createRGBColor(123, 23, 3));
        deepLabelContainer.setBackgroundColor((Color)FigureCodegenTest.createRGBColor(2, 123, 23));
        root.getChildren().add((Object)deepLabelContainer);
        Label defaultFontLabel = GMFGraphFactory.eINSTANCE.createLabel();
        defaultFontLabel.setName("DefaultFontLabel");
        defaultFontLabel.setFont(FigureCodegenTest.createBasicFont(null, 34, FontStyle.BOLD_LITERAL));
        defaultFontLabel.setForegroundColor((Color)FigureCodegenTest.createConstantColor(ColorConstants.CYAN_LITERAL));
        deepLabelContainer.getChildren().add((Object)defaultFontLabel);
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.swt.graphics.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StaticFieldsChecker fontFieldsCheck = new StaticFieldsChecker(4, clazz);
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.swt.graphics.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StaticFieldsChecker colorFieldsCheck = new StaticFieldsChecker(2, clazz2);
        this.performTests((Figure)root, FigureCodegenTest.combineChecks(fontFieldsCheck, colorFieldsCheck));
    }

    public void testConnectionWithColor() {
        org.eclipse.gmf.gmfgraph.PolylineConnection link = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        link.setName("AlmostRedLink");
        link.setForegroundColor((Color)FigureCodegenTest.createRGBColor(255, 1, 1));
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.swt.graphics.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StaticFieldsChecker colorFieldsCheck = new StaticFieldsChecker(1, clazz);
        this.performTests((Figure)link, colorFieldsCheck);
    }

    private static class StaticFieldsChecker
    extends FigureCodegenTestBase.FigureCheck {
        private final int myExpectedFieldCount;
        private final Class myFieldClazz;

        public StaticFieldsChecker(int expectedFieldCount, Class fieldClazz) {
            this.myExpectedFieldCount = expectedFieldCount;
            this.myFieldClazz = fieldClazz;
        }

        public void checkFigure(IFigure figure) {
            Class<?> figureClazz = figure.getClass();
            Field[] fields = figureClazz.getDeclaredFields();
            int staticFinalFields = 0;
            int i = 0;
            while (i < fields.length) {
                Field next = fields[i];
                int modifiers = next.getModifiers();
                if (this.myFieldClazz.equals(next.getType()) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                    ++staticFinalFields;
                }
                ++i;
            }
            StaticFieldsChecker.assertTrue((String)("Expected: at least " + this.myExpectedFieldCount + " constants of type :" + this.myFieldClazz.getName() + ". Actual: " + staticFinalFields), (staticFinalFields >= this.myExpectedFieldCount ? 1 : 0) != 0);
        }
    }
}

