/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.validate;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    public static final ConstraintHelper OCL = new ConstraintHelper("ocl");
    public static final ConstraintHelper REGEXP = new ConstraintHelper("regexp");

    private AnnotationUtil() {
    }

    public static Object getDiagnosticSource(Diagnostic diagnostic) {
        if (diagnostic.getData() != null && !diagnostic.getData().isEmpty()) {
            return diagnostic.getData().get(0);
        }
        return null;
    }

    public static Diagnostic getChildDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getChildren() != null && !diagnostic.getChildren().isEmpty()) {
            return (Diagnostic)diagnostic.getChildren().get(0);
        }
        return null;
    }

    public static Object getChildDiagnosticSource(Diagnostic diagnostic) {
        return AnnotationUtil.getDiagnosticSource(AnnotationUtil.getChildDiagnostic(diagnostic));
    }

    public static EAnnotation createAnnotation(EModelElement modelElement, String source) {
        assert (modelElement != null);
        assert (source != null);
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        modelElement.getEAnnotations().add((Object)eAnnotation);
        eAnnotation.setSource(source);
        return eAnnotation;
    }

    public static EAnnotation addLanguageDefAnnotation(EStructuralFeature langFeature) {
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation((EModelElement)langFeature, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)"lang");
        return eAnnotation;
    }

    public static EAnnotation addBodyDefAnnotation(EStructuralFeature bodyFeature) {
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation((EModelElement)bodyFeature, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)"body");
        return eAnnotation;
    }

    public static EAnnotation addContextRefAnnotation(EModelElement contextResolutionElement, String ctxRef) {
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation(contextResolutionElement, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)"context");
        eAnnotation.getDetails().put((Object)"ref", (Object)ctxRef);
        return eAnnotation;
    }

    public static EAnnotation addContextDefAnnotation(EModelElement contextResolutionElement, String oclExpression) {
        EAnnotation eAnnotation = AnnotationUtil.createAnnotation(contextResolutionElement, "http://www.eclipse.org/gmf/2005/constraints/meta");
        eAnnotation.getDetails().put((Object)"def", (Object)"context");
        eAnnotation.getDetails().put((Object)"ocl", (Object)oclExpression);
        return eAnnotation;
    }

    static Map.Entry<String, String> getDetailByKey(EAnnotation constraint, String key) {
        for (Map.Entry entry : constraint.getDetails()) {
            if (!key.equals(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstraintHelper {
        private String lang;

        public ConstraintHelper(String lang) {
            this.lang = lang;
        }

        public Map.Entry<String, String> getConstraintBodyDetail(EAnnotation constraint) {
            return AnnotationUtil.getDetailByKey(constraint, this.lang);
        }

        public Map.Entry<String, String> getConstraintDescDetail(EAnnotation constraint) {
            return AnnotationUtil.getDetailByKey(constraint, "description");
        }

        public EAnnotation createConstraint(EModelElement modelElement, String body) {
            EAnnotation eAnnotation = AnnotationUtil.createAnnotation(modelElement, "http://www.eclipse.org/gmf/2005/constraints");
            eAnnotation.getDetails().put((Object)this.lang, (Object)body);
            return eAnnotation;
        }

        public EAnnotation createConstraint(EModelElement modelElement, String body, String description) {
            EAnnotation eAnnotation = this.createConstraint(modelElement, body);
            eAnnotation.getDetails().put((Object)"description", (Object)description);
            return eAnnotation;
        }
    }
}

